/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslCachingKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.util.internal.ObjectUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509KeyManager;

public final class OpenSslCachingX509KeyManagerFactory
extends KeyManagerFactory {
    private final int maxCachedEntries;

    /*
     * WARNING - void declaration
     */
    public OpenSslCachingX509KeyManagerFactory(KeyManagerFactory factory) {
        this((KeyManagerFactory)var1_1, 1024);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public OpenSslCachingX509KeyManagerFactory(final KeyManagerFactory factory, int maxCachedEntries) {
        super(new KeyManagerFactorySpi(){

            /*
             * WARNING - void declaration
             */
            @Override
            protected void engineInit(KeyStore keyStore, char[] chars) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
                void var2_2;
                void var1_1;
                factory.init((KeyStore)var1_1, (char[])var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
                void var1_1;
                factory.init((ManagerFactoryParameters)var1_1);
            }

            @Override
            protected KeyManager[] engineGetKeyManagers() {
                return factory.getKeyManagers();
            }
        }, factory.getProvider(), var1_1.getAlgorithm());
        void var2_2;
        void var1_1;
        this.maxCachedEntries = ObjectUtil.checkPositive((int)var2_2, (String)"maxCachedEntries");
    }

    /*
     * WARNING - void declaration
     */
    final OpenSslKeyMaterialProvider newProvider(String password) {
        void var1_1;
        X509KeyManager keyManager = ReferenceCountedOpenSslContext.chooseX509KeyManager(this.getKeyManagers());
        if ("sun.security.ssl.X509KeyManagerImpl".equals(keyManager.getClass().getName())) {
            void var2_2;
            return new OpenSslKeyMaterialProvider((X509KeyManager)var2_2, password);
        }
        return new OpenSslCachingKeyMaterialProvider(ReferenceCountedOpenSslContext.chooseX509KeyManager(this.getKeyManagers()), (String)var1_1, this.maxCachedEntries);
    }
}

