/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.X509KeyManager;

final class OpenSslCachingKeyMaterialProvider
extends OpenSslKeyMaterialProvider {
    private final int maxCachedEntries;
    private volatile boolean full;
    private final ConcurrentMap<String, OpenSslKeyMaterial> cache = new ConcurrentHashMap<String, OpenSslKeyMaterial>();

    /*
     * WARNING - void declaration
     */
    OpenSslCachingKeyMaterialProvider(X509KeyManager keyManager, String password, int maxCachedEntries) {
        super((X509KeyManager)var1_1, (String)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.maxCachedEntries = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator allocator, String alias) throws Exception {
        void var3_3;
        OpenSslKeyMaterial material = (OpenSslKeyMaterial)this.cache.get(alias);
        if (material == null) {
            void var2_2;
            material = super.chooseKeyMaterial(allocator, alias);
            if (material == null) {
                return null;
            }
            if (this.full) {
                return material;
            }
            if (this.cache.size() > this.maxCachedEntries) {
                this.full = true;
                return material;
            }
            OpenSslKeyMaterial old = this.cache.putIfAbsent((String)var2_2, material);
            if (old != null) {
                void var1_1;
                material.release();
                material = var1_1;
            }
        }
        return var3_3.retain();
    }

    @Override
    final void destroy() {
        do {
            Iterator iterator = this.cache.values().iterator();
            while (iterator.hasNext()) {
                ((OpenSslKeyMaterial)iterator.next()).release();
                iterator.remove();
            }
        } while (!this.cache.isEmpty());
    }
}

