/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkSslEngine;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.eclipse.jetty.npn.NextProtoNego;

final class JettyNpnSslEngine
extends JdkSslEngine {
    private static boolean available;

    static boolean isAvailable() {
        JettyNpnSslEngine.updateAvailability();
        return available;
    }

    private static void updateAvailability() {
        if (available) {
            return;
        }
        try {
            Class.forName("sun.security.ssl.NextProtoNegoExtension", true, null);
            available = true;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    JettyNpnSslEngine(SSLEngine engine, JdkApplicationProtocolNegotiator applicationNegotiator, boolean server) {
        super(engine);
        void var3_5;
        void var1_1;
        void var2_2;
        ObjectUtil.checkNotNull((Object)applicationNegotiator, (String)"applicationNegotiator");
        if (server) {
            JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolListener = (JdkApplicationProtocolNegotiator.ProtocolSelectionListener)ObjectUtil.checkNotNull((Object)applicationNegotiator.protocolListenerFactory().newListener(this, applicationNegotiator.protocols()), (String)"protocolListener");
            NextProtoNego.put((SSLEngine)engine, (NextProtoNego.Provider)new NextProtoNego.ServerProvider(this, protocolListener, applicationNegotiator){
                final /* synthetic */ JdkApplicationProtocolNegotiator.ProtocolSelectionListener val$protocolListener;
                final /* synthetic */ JdkApplicationProtocolNegotiator val$applicationNegotiator;
                final /* synthetic */ JettyNpnSslEngine this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$protocolListener = protocolSelectionListener;
                    this.val$applicationNegotiator = jdkApplicationProtocolNegotiator;
                }

                public void unsupported() {
                    this.val$protocolListener.unsupported();
                }

                public List<String> protocols() {
                    return this.val$applicationNegotiator.protocols();
                }

                public void protocolSelected(String protocol) {
                    Throwable throwable;
                    try {
                        this.val$protocolListener.selected((String)((Object)throwable));
                        return;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        PlatformDependent.throwException((Throwable)throwable2);
                        return;
                    }
                }
            });
            return;
        }
        JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector = (JdkApplicationProtocolNegotiator.ProtocolSelector)ObjectUtil.checkNotNull((Object)applicationNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(var2_2.protocols())), (String)"protocolSelector");
        NextProtoNego.put((SSLEngine)var1_1, (NextProtoNego.Provider)new NextProtoNego.ClientProvider(this, (JdkApplicationProtocolNegotiator.ProtocolSelector)var3_5){
            final /* synthetic */ JdkApplicationProtocolNegotiator.ProtocolSelector val$protocolSelector;
            final /* synthetic */ JettyNpnSslEngine this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$protocolSelector = protocolSelector;
            }

            public boolean supports() {
                return true;
            }

            public void unsupported() {
                this.val$protocolSelector.unsupported();
            }

            public String selectProtocol(List<String> protocols) {
                Throwable throwable;
                try {
                    return this.val$protocolSelector.select((List<String>)((Object)throwable));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    PlatformDependent.throwException((Throwable)throwable2);
                    return null;
                }
            }
        });
    }

    @Override
    public final void closeInbound() throws SSLException {
        NextProtoNego.remove((SSLEngine)this.getWrappedEngine());
        super.closeInbound();
    }

    @Override
    public final void closeOutbound() {
        NextProtoNego.remove((SSLEngine)this.getWrappedEngine());
        super.closeOutbound();
    }
}

