/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkSslEngine;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.eclipse.jetty.alpn.ALPN;

abstract class JettyAlpnSslEngine
extends JdkSslEngine {
    private static final boolean available = JettyAlpnSslEngine.initAvailable();

    static boolean isAvailable() {
        return available;
    }

    private static boolean initAvailable() {
        if (PlatformDependent.javaVersion() <= 8) {
            try {
                Class.forName("sun.security.ssl.ALPNExtension", true, null);
                return true;
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static JettyAlpnSslEngine newClientEngine(SSLEngine engine, JdkApplicationProtocolNegotiator applicationNegotiator) {
        void var1_1;
        SSLEngine sSLEngine;
        return new ClientEngine(sSLEngine, (JdkApplicationProtocolNegotiator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static JettyAlpnSslEngine newServerEngine(SSLEngine engine, JdkApplicationProtocolNegotiator applicationNegotiator) {
        void var1_1;
        SSLEngine sSLEngine;
        return new ServerEngine(sSLEngine, (JdkApplicationProtocolNegotiator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private JettyAlpnSslEngine(SSLEngine engine) {
        super((SSLEngine)var1_1);
        void var1_1;
    }

    private static final class ServerEngine
    extends JettyAlpnSslEngine {
        /*
         * WARNING - void declaration
         */
        ServerEngine(SSLEngine engine, JdkApplicationProtocolNegotiator applicationNegotiator) {
            super(engine);
            void var2_2;
            void var1_1;
            ObjectUtil.checkNotNull((Object)applicationNegotiator, (String)"applicationNegotiator");
            JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector = (JdkApplicationProtocolNegotiator.ProtocolSelector)ObjectUtil.checkNotNull((Object)applicationNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(applicationNegotiator.protocols())), (String)"protocolSelector");
            ALPN.put((SSLEngine)var1_1, (ALPN.Provider)new ALPN.ServerProvider(this, (JdkApplicationProtocolNegotiator.ProtocolSelector)var2_2){
                final /* synthetic */ JdkApplicationProtocolNegotiator.ProtocolSelector val$protocolSelector;
                final /* synthetic */ ServerEngine this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$protocolSelector = protocolSelector;
                }

                public String select(List<String> protocols) throws SSLException {
                    Throwable throwable;
                    try {
                        return this.val$protocolSelector.select((List<String>)((Object)throwable));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw SslUtils.toSSLHandshakeException(throwable2);
                    }
                }

                public void unsupported() {
                    this.val$protocolSelector.unsupported();
                }
            });
        }

        @Override
        public final void closeInbound() throws SSLException {
            try {
                ALPN.remove((SSLEngine)this.getWrappedEngine());
                return;
            }
            finally {
                super.closeInbound();
            }
        }

        @Override
        public final void closeOutbound() {
            try {
                ALPN.remove((SSLEngine)this.getWrappedEngine());
                return;
            }
            finally {
                super.closeOutbound();
            }
        }
    }

    private static final class ClientEngine
    extends JettyAlpnSslEngine {
        /*
         * WARNING - void declaration
         */
        ClientEngine(SSLEngine engine, JdkApplicationProtocolNegotiator applicationNegotiator) {
            super(engine);
            void var3_3;
            void var2_2;
            void var1_1;
            ObjectUtil.checkNotNull((Object)applicationNegotiator, (String)"applicationNegotiator");
            JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolListener = (JdkApplicationProtocolNegotiator.ProtocolSelectionListener)ObjectUtil.checkNotNull((Object)applicationNegotiator.protocolListenerFactory().newListener(this, applicationNegotiator.protocols()), (String)"protocolListener");
            ALPN.put((SSLEngine)var1_1, (ALPN.Provider)new ALPN.ClientProvider(this, (JdkApplicationProtocolNegotiator)var2_2, (JdkApplicationProtocolNegotiator.ProtocolSelectionListener)var3_3){
                final /* synthetic */ JdkApplicationProtocolNegotiator val$applicationNegotiator;
                final /* synthetic */ JdkApplicationProtocolNegotiator.ProtocolSelectionListener val$protocolListener;
                final /* synthetic */ ClientEngine this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$applicationNegotiator = jdkApplicationProtocolNegotiator;
                    this.val$protocolListener = protocolSelectionListener;
                }

                public List<String> protocols() {
                    return this.val$applicationNegotiator.protocols();
                }

                public void selected(String protocol) throws SSLException {
                    Throwable throwable;
                    try {
                        this.val$protocolListener.selected((String)((Object)throwable));
                        return;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw SslUtils.toSSLHandshakeException(throwable2);
                    }
                }

                public void unsupported() {
                    this.val$protocolListener.unsupported();
                }
            });
        }

        @Override
        public final void closeInbound() throws SSLException {
            try {
                ALPN.remove((SSLEngine)this.getWrappedEngine());
                return;
            }
            finally {
                super.closeInbound();
            }
        }

        @Override
        public final void closeOutbound() {
            try {
                ALPN.remove((SSLEngine)this.getWrappedEngine());
                return;
            }
            finally {
                super.closeOutbound();
            }
        }
    }
}

