/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.Java7SslParametersUtils;
import io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkDefaultApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkNpnApplicationProtocolNegotiator;
import io.netty.handler.ssl.ResumptionController;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSessionContext;

public class JdkSslContext
extends SslContext {
    private static final InternalLogger logger;
    static final String PROTOCOL = "TLS";
    private static final String[] DEFAULT_PROTOCOLS;
    private static final List<String> DEFAULT_CIPHERS;
    private static final List<String> DEFAULT_CIPHERS_NON_TLSV13;
    private static final Set<String> SUPPORTED_CIPHERS;
    private static final Set<String> SUPPORTED_CIPHERS_NON_TLSV13;
    private static final Provider DEFAULT_PROVIDER;
    private final String[] protocols;
    private final String[] cipherSuites;
    private final List<String> unmodifiableCipherSuites;
    private final JdkApplicationProtocolNegotiator apn;
    private final ClientAuth clientAuth;
    private final SSLContext sslContext;
    private final boolean isClient;
    private final String endpointIdentificationAlgorithm;

    /*
     * WARNING - void declaration
     */
    private static String[] defaultProtocols(SSLContext context, SSLEngine engine) {
        void var1_1;
        void var2_2;
        String[] supportedProtocols = context.getDefaultSSLParameters().getProtocols();
        HashSet supportedProtocolsSet = new HashSet(supportedProtocols.length);
        Collections.addAll(supportedProtocolsSet, supportedProtocols);
        String[] protocols = new ArrayList();
        SslUtils.addIfSupported((Set<String>)var2_2, (List<String>)protocols, "TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1");
        if (!protocols.isEmpty()) {
            String[] stringArray;
            return stringArray.toArray(EmptyArrays.EMPTY_STRINGS);
        }
        return var1_1.getEnabledProtocols();
    }

    /*
     * WARNING - void declaration
     */
    private static Set<String> supportedCiphers(SSLEngine engine) {
        void var2_2;
        String[] supportedCiphers = engine.getSupportedCipherSuites();
        LinkedHashSet<String> supportedCiphersSet = new LinkedHashSet<String>(supportedCiphers.length);
        for (int i = 0; i < supportedCiphers.length; ++i) {
            String supportedCipher = supportedCiphers[i];
            supportedCiphersSet.add(supportedCipher);
            if (!supportedCipher.startsWith("SSL_")) continue;
            String tlsPrefixedCipherName = "TLS_" + supportedCipher.substring(4);
            try {
                engine.setEnabledCipherSuites(new String[]{tlsPrefixedCipherName});
                supportedCiphersSet.add(tlsPrefixedCipherName);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> defaultCiphers(SSLEngine engine, Set<String> supportedCiphers) {
        void var2_2;
        SSLEngine sSLEngine;
        void var1_1;
        ArrayList<String> ciphers = new ArrayList<String>();
        SslUtils.addIfSupported((Set<String>)var1_1, ciphers, SslUtils.DEFAULT_CIPHER_SUITES);
        SslUtils.useFallbackCiphersIfDefaultIsEmpty(ciphers, sSLEngine.getEnabledCipherSuites());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isTlsV13Supported(String[] protocols) {
        String[] stringArray = protocols;
        int n = protocols.length;
        for (int i = 0; i < n; ++i) {
            void var3_3;
            String protocol = stringArray[i];
            if (!"TLSv1.3".equals(var3_3)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public JdkSslContext(SSLContext sslContext, boolean isClient, ClientAuth clientAuth) {
        this((SSLContext)var1_1, (boolean)var2_2, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, JdkDefaultApplicationProtocolNegotiator.INSTANCE, (ClientAuth)var3_3, null, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public JdkSslContext(SSLContext sslContext, boolean isClient, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, ClientAuth clientAuth) {
        this((SSLContext)var1_1, (boolean)var2_2, (Iterable<String>)var3_3, cipherFilter, apn, clientAuth, null, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JdkSslContext(SSLContext sslContext, boolean isClient, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, ClientAuth clientAuth, String[] protocols, boolean startTls) {
        this((SSLContext)var1_1, isClient, (Iterable<String>)var3_3, cipherFilter, JdkSslContext.toNegotiator(apn, var2_2 == false), clientAuth, protocols == null ? null : (String[])protocols.clone(), startTls);
        void var2_2;
        void var3_3;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    JdkSslContext(SSLContext sslContext, boolean isClient, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, JdkApplicationProtocolNegotiator apn, ClientAuth clientAuth, String[] protocols, boolean startTls) {
        this((SSLContext)var1_1, (boolean)var2_2, (Iterable<String>)var3_3, cipherFilter, apn, clientAuth, protocols, startTls, null, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    JdkSslContext(SSLContext sslContext, boolean isClient, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, JdkApplicationProtocolNegotiator apn, ClientAuth clientAuth, String[] protocols, boolean startTls, String endpointIdentificationAlgorithm, ResumptionController resumptionController) {
        super(startTls, resumptionController);
        void var2_3;
        void var1_1;
        void var3_4;
        List<String> defaultCiphers;
        Set<String> supportedCiphers;
        this.apn = (JdkApplicationProtocolNegotiator)ObjectUtil.checkNotNull((Object)apn, (String)"apn");
        this.clientAuth = (ClientAuth)((Object)ObjectUtil.checkNotNull((Object)((Object)clientAuth), (String)"clientAuth"));
        this.sslContext = (SSLContext)ObjectUtil.checkNotNull((Object)sslContext, (String)"sslContext");
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
        if (DEFAULT_PROVIDER.equals(sslContext.getProvider())) {
            String[] stringArray = this.protocols = protocols == null ? DEFAULT_PROTOCOLS : protocols;
            if (JdkSslContext.isTlsV13Supported(this.protocols)) {
                supportedCiphers = SUPPORTED_CIPHERS;
                defaultCiphers = DEFAULT_CIPHERS;
            } else {
                supportedCiphers = SUPPORTED_CIPHERS_NON_TLSV13;
                defaultCiphers = DEFAULT_CIPHERS_NON_TLSV13;
            }
        } else {
            SSLEngine engine = ((SSLContext)((Object)defaultCiphers)).createSSLEngine();
            try {
                this.protocols = protocols == null ? JdkSslContext.defaultProtocols((SSLContext)((Object)defaultCiphers), engine) : protocols;
                supportedCiphers = JdkSslContext.supportedCiphers(engine);
                defaultCiphers = JdkSslContext.defaultCiphers(engine, supportedCiphers);
                if (!JdkSslContext.isTlsV13Supported(this.protocols)) {
                    String[] stringArray = SslUtils.DEFAULT_TLSV13_CIPHER_SUITES;
                    int n = SslUtils.DEFAULT_TLSV13_CIPHER_SUITES.length;
                    for (int i = 0; i < n; ++i) {
                        String cipher = stringArray[i];
                        supportedCiphers.remove(cipher);
                        defaultCiphers.remove(cipher);
                    }
                }
            }
            finally {
                ReferenceCountUtil.release((Object)engine);
            }
        }
        this.cipherSuites = ((CipherSuiteFilter)ObjectUtil.checkNotNull((Object)cipherFilter, (String)"cipherFilter")).filterCipherSuites((Iterable<String>)var3_4, (List<String>)var1_1, supportedCiphers);
        this.unmodifiableCipherSuites = Collections.unmodifiableList(Arrays.asList(this.cipherSuites));
        this.isClient = var2_3;
    }

    public final SSLContext context() {
        return this.sslContext;
    }

    @Override
    public final boolean isClient() {
        return this.isClient;
    }

    @Override
    public final SSLSessionContext sessionContext() {
        if (this.isServer()) {
            return this.context().getServerSessionContext();
        }
        return this.context().getClientSessionContext();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCipherSuites;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SSLEngine newEngine(ByteBufAllocator alloc) {
        void var1_1;
        JdkSslContext jdkSslContext = this;
        return jdkSslContext.configureAndWrapEngine(jdkSslContext.context().createSSLEngine(), (ByteBufAllocator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SSLEngine newEngine(ByteBufAllocator alloc, String peerHost, int peerPort) {
        void var1_1;
        void var3_3;
        void var2_2;
        JdkSslContext jdkSslContext = this;
        return jdkSslContext.configureAndWrapEngine(jdkSslContext.context().createSSLEngine((String)var2_2, (int)var3_3), (ByteBufAllocator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngine configureAndWrapEngine(SSLEngine engine, ByteBufAllocator alloc) {
        void var1_1;
        void var3_3;
        engine.setEnabledCipherSuites(this.cipherSuites);
        engine.setEnabledProtocols(this.protocols);
        engine.setUseClientMode(((SslContext)this).isClient());
        if (this.isServer()) {
            switch (this.clientAuth) {
                case OPTIONAL: {
                    engine.setWantClientAuth(true);
                    break;
                }
                case REQUIRE: {
                    engine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new Error("Unknown auth " + (Object)((Object)this.clientAuth));
                }
            }
        }
        this.configureEndpointVerification(engine);
        JdkApplicationProtocolNegotiator.SslEngineWrapperFactory factory = this.apn.wrapperFactory();
        if (factory instanceof JdkApplicationProtocolNegotiator.AllocatorAwareSslEngineWrapperFactory) {
            void var2_2;
            return ((JdkApplicationProtocolNegotiator.AllocatorAwareSslEngineWrapperFactory)factory).wrapSslEngine(engine, (ByteBufAllocator)var2_2, this.apn, this.isServer());
        }
        return var3_3.wrapSslEngine((SSLEngine)var1_1, this.apn, this.isServer());
    }

    /*
     * WARNING - void declaration
     */
    private void configureEndpointVerification(SSLEngine engine) {
        int n = PlatformDependent.javaVersion();
        if (n >= 7) {
            void var2_3;
            void var1_1;
            SSLParameters params = engine.getSSLParameters();
            Java7SslParametersUtils.setEndpointIdentificationAlgorithm(params, this.endpointIdentificationAlgorithm);
            var1_1.setSSLParameters((SSLParameters)var2_3);
        }
    }

    @Override
    public final JdkApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    /*
     * WARNING - void declaration
     */
    static JdkApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig config, boolean isServer) {
        ApplicationProtocolConfig applicationProtocolConfig;
        if (config == null) {
            return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
        }
        switch (config.protocol()) {
            case NONE: {
                return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
            }
            case ALPN: {
                if (isServer) {
                    switch (config.selectorFailureBehavior()) {
                        case FATAL_ALERT: {
                            return new JdkAlpnApplicationProtocolNegotiator(true, config.supportedProtocols());
                        }
                        case NO_ADVERTISE: {
                            return new JdkAlpnApplicationProtocolNegotiator(false, config.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)config.selectorFailureBehavior()) + " failure behavior");
                }
                switch (config.selectedListenerFailureBehavior()) {
                    case ACCEPT: {
                        return new JdkAlpnApplicationProtocolNegotiator(false, config.supportedProtocols());
                    }
                    case FATAL_ALERT: {
                        return new JdkAlpnApplicationProtocolNegotiator(true, config.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)config.selectedListenerFailureBehavior()) + " failure behavior");
            }
            case NPN: {
                void var1_1;
                if (var1_1 != false) {
                    switch (config.selectedListenerFailureBehavior()) {
                        case ACCEPT: {
                            return new JdkNpnApplicationProtocolNegotiator(false, config.supportedProtocols());
                        }
                        case FATAL_ALERT: {
                            return new JdkNpnApplicationProtocolNegotiator(true, config.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)config.selectedListenerFailureBehavior()) + " failure behavior");
                }
                switch (config.selectorFailureBehavior()) {
                    case FATAL_ALERT: {
                        return new JdkNpnApplicationProtocolNegotiator(true, config.supportedProtocols());
                    }
                    case NO_ADVERTISE: {
                        return new JdkNpnApplicationProtocolNegotiator(false, config.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)config.selectorFailureBehavior()) + " failure behavior");
            }
        }
        throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.protocol()) + " protocol");
    }

    /*
     * WARNING - void declaration
     */
    static KeyManagerFactory buildKeyManagerFactory(File certChainFile, File keyFile, String keyPassword, KeyManagerFactory kmf, String keyStore) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, CertificateException, KeyException, IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        File file;
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        return JdkSslContext.buildKeyManagerFactory(file, algorithm, (File)var1_1, (String)var2_2, (KeyManagerFactory)var3_3, keyStore);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected static KeyManagerFactory buildKeyManagerFactory(File certChainFile, File keyFile, String keyPassword, KeyManagerFactory kmf) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, CertificateException, KeyException, IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return JdkSslContext.buildKeyManagerFactory(certChainFile, (File)var1_1, (String)var2_2, (KeyManagerFactory)var3_3, KeyStore.getDefaultType());
    }

    /*
     * WARNING - void declaration
     */
    static KeyManagerFactory buildKeyManagerFactory(File certChainFile, String keyAlgorithm, File keyFile, String keyPassword, KeyManagerFactory kmf, String keyStore) throws KeyStoreException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, IOException, CertificateException, KeyException, UnrecoverableKeyException {
        void var3_3;
        void var2_2;
        void var1_1;
        return JdkSslContext.buildKeyManagerFactory(JdkSslContext.toX509Certificates(certChainFile), (String)var1_1, JdkSslContext.toPrivateKey((File)var2_2, keyPassword), (String)var3_3, kmf, keyStore);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected static KeyManagerFactory buildKeyManagerFactory(File certChainFile, String keyAlgorithm, File keyFile, String keyPassword, KeyManagerFactory kmf) throws KeyStoreException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, IOException, CertificateException, KeyException, UnrecoverableKeyException {
        void var3_3;
        void var2_2;
        void var1_1;
        return JdkSslContext.buildKeyManagerFactory(JdkSslContext.toX509Certificates(certChainFile), (String)var1_1, JdkSslContext.toPrivateKey((File)var2_2, keyPassword), (String)var3_3, kmf, KeyStore.getDefaultType());
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String[] access$100(SSLContext x0, SSLEngine x1) {
        void var1_1;
        return JdkSslContext.defaultProtocols(x0, (SSLEngine)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ List access$300(SSLEngine x0, Set x1) {
        void var1_1;
        return JdkSslContext.defaultCiphers(x0, (Set<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        logger = InternalLoggerFactory.getInstance(JdkSslContext.class);
        Defaults defaults = new Defaults();
        defaults.init();
        DEFAULT_PROVIDER = defaults.defaultProvider;
        DEFAULT_PROTOCOLS = defaults.defaultProtocols;
        SUPPORTED_CIPHERS = defaults.supportedCiphers;
        DEFAULT_CIPHERS = defaults.defaultCiphers;
        DEFAULT_CIPHERS_NON_TLSV13 = defaults.defaultCiphersNonTLSv13;
        SUPPORTED_CIPHERS_NON_TLSV13 = var0.supportedCiphersNonTLSv13;
        if (logger.isDebugEnabled()) {
            logger.debug("Default protocols (JDK): {} ", Arrays.asList(DEFAULT_PROTOCOLS));
            logger.debug("Default cipher suites (JDK): {}", DEFAULT_CIPHERS);
        }
    }

    private static final class Defaults {
        String[] defaultProtocols;
        List<String> defaultCiphers;
        List<String> defaultCiphersNonTLSv13;
        Set<String> supportedCiphers;
        Set<String> supportedCiphersNonTLSv13;
        Provider defaultProvider;

        private Defaults() {
        }

        /*
         * WARNING - void declaration
         */
        final void init() {
            void var1_1;
            void var2_3;
            SSLContext context;
            try {
                context = SSLContext.getInstance(JdkSslContext.PROTOCOL);
                context.init(null, null, null);
            }
            catch (Exception e) {
                throw new Error("failed to initialize the default SSL context", e);
            }
            this.defaultProvider = context.getProvider();
            SSLEngine engine = context.createSSLEngine();
            this.defaultProtocols = JdkSslContext.access$100(context, engine);
            this.supportedCiphers = Collections.unmodifiableSet(JdkSslContext.supportedCiphers(engine));
            this.defaultCiphers = Collections.unmodifiableList(JdkSslContext.access$300((SSLEngine)var2_3, this.supportedCiphers));
            ArrayList<String> ciphersNonTLSv13 = new ArrayList<String>(this.defaultCiphers);
            ciphersNonTLSv13.removeAll(Arrays.asList(SslUtils.DEFAULT_TLSV13_CIPHER_SUITES));
            this.defaultCiphersNonTLSv13 = Collections.unmodifiableList(ciphersNonTLSv13);
            LinkedHashSet<String> suppertedCiphersNonTLSv13 = new LinkedHashSet<String>(this.supportedCiphers);
            suppertedCiphersNonTLSv13.removeAll(Arrays.asList(SslUtils.DEFAULT_TLSV13_CIPHER_SUITES));
            this.supportedCiphersNonTLSv13 = Collections.unmodifiableSet(var1_1);
        }
    }
}

