/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ApplicationProtocolUtil;
import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkSslEngine;
import io.netty.util.internal.ObjectUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;

class JdkBaseApplicationProtocolNegotiator
implements JdkApplicationProtocolNegotiator {
    private final List<String> protocols;
    private final JdkApplicationProtocolNegotiator.ProtocolSelectorFactory selectorFactory;
    private final JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory listenerFactory;
    private final JdkApplicationProtocolNegotiator.SslEngineWrapperFactory wrapperFactory;
    static final JdkApplicationProtocolNegotiator.ProtocolSelectorFactory FAIL_SELECTOR_FACTORY = new JdkApplicationProtocolNegotiator.ProtocolSelectorFactory(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final JdkApplicationProtocolNegotiator.ProtocolSelector newSelector(SSLEngine engine, Set<String> supportedProtocols) {
            void var2_2;
            void var1_1;
            return new FailProtocolSelector((JdkSslEngine)var1_1, (Set<String>)var2_2);
        }
    };
    static final JdkApplicationProtocolNegotiator.ProtocolSelectorFactory NO_FAIL_SELECTOR_FACTORY = new JdkApplicationProtocolNegotiator.ProtocolSelectorFactory(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final JdkApplicationProtocolNegotiator.ProtocolSelector newSelector(SSLEngine engine, Set<String> supportedProtocols) {
            void var2_2;
            void var1_1;
            return new NoFailProtocolSelector((JdkSslEngine)var1_1, (Set<String>)var2_2);
        }
    };
    static final JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory FAIL_SELECTION_LISTENER_FACTORY = new JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final JdkApplicationProtocolNegotiator.ProtocolSelectionListener newListener(SSLEngine engine, List<String> supportedProtocols) {
            void var2_2;
            void var1_1;
            return new FailProtocolSelectionListener((JdkSslEngine)var1_1, (List<String>)var2_2);
        }
    };
    static final JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory NO_FAIL_SELECTION_LISTENER_FACTORY = new JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final JdkApplicationProtocolNegotiator.ProtocolSelectionListener newListener(SSLEngine engine, List<String> supportedProtocols) {
            void var2_2;
            void var1_1;
            return new NoFailProtocolSelectionListener((JdkSslEngine)var1_1, (List<String>)var2_2);
        }
    };

    /*
     * WARNING - void declaration
     */
    JdkBaseApplicationProtocolNegotiator(JdkApplicationProtocolNegotiator.SslEngineWrapperFactory wrapperFactory, JdkApplicationProtocolNegotiator.ProtocolSelectorFactory selectorFactory, JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory listenerFactory, Iterable<String> protocols) {
        this((JdkApplicationProtocolNegotiator.SslEngineWrapperFactory)var1_1, (JdkApplicationProtocolNegotiator.ProtocolSelectorFactory)var2_2, (JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory)var3_3, ApplicationProtocolUtil.toList(protocols));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    JdkBaseApplicationProtocolNegotiator(JdkApplicationProtocolNegotiator.SslEngineWrapperFactory wrapperFactory, JdkApplicationProtocolNegotiator.ProtocolSelectorFactory selectorFactory, JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory listenerFactory, String ... protocols) {
        this((JdkApplicationProtocolNegotiator.SslEngineWrapperFactory)var1_1, (JdkApplicationProtocolNegotiator.ProtocolSelectorFactory)var2_2, (JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory)var3_3, ApplicationProtocolUtil.toList(protocols));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private JdkBaseApplicationProtocolNegotiator(JdkApplicationProtocolNegotiator.SslEngineWrapperFactory wrapperFactory, JdkApplicationProtocolNegotiator.ProtocolSelectorFactory selectorFactory, JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory listenerFactory, List<String> protocols) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.wrapperFactory = (JdkApplicationProtocolNegotiator.SslEngineWrapperFactory)ObjectUtil.checkNotNull((Object)var1_1, (String)"wrapperFactory");
        this.selectorFactory = (JdkApplicationProtocolNegotiator.ProtocolSelectorFactory)ObjectUtil.checkNotNull((Object)var2_2, (String)"selectorFactory");
        this.listenerFactory = (JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory)ObjectUtil.checkNotNull((Object)var3_3, (String)"listenerFactory");
        this.protocols = Collections.unmodifiableList((List)ObjectUtil.checkNotNull(protocols, (String)"protocols"));
    }

    @Override
    public List<String> protocols() {
        return this.protocols;
    }

    @Override
    public JdkApplicationProtocolNegotiator.ProtocolSelectorFactory protocolSelectorFactory() {
        return this.selectorFactory;
    }

    @Override
    public JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory protocolListenerFactory() {
        return this.listenerFactory;
    }

    @Override
    public JdkApplicationProtocolNegotiator.SslEngineWrapperFactory wrapperFactory() {
        return this.wrapperFactory;
    }

    private static final class FailProtocolSelectionListener
    extends NoFailProtocolSelectionListener {
        /*
         * WARNING - void declaration
         */
        FailProtocolSelectionListener(JdkSslEngine engineWrapper, List<String> supportedProtocols) {
            super((JdkSslEngine)var1_1, (List<String>)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        protected final void noSelectedMatchFound(String protocol) throws Exception {
            throw new SSLHandshakeException("No compatible protocols found");
        }
    }

    private static class NoFailProtocolSelectionListener
    implements JdkApplicationProtocolNegotiator.ProtocolSelectionListener {
        private final JdkSslEngine engineWrapper;
        private final List<String> supportedProtocols;

        /*
         * WARNING - void declaration
         */
        NoFailProtocolSelectionListener(JdkSslEngine engineWrapper, List<String> supportedProtocols) {
            void var2_2;
            void var1_1;
            this.engineWrapper = var1_1;
            this.supportedProtocols = var2_2;
        }

        @Override
        public void unsupported() {
            this.engineWrapper.setNegotiatedApplicationProtocol(null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void selected(String protocol) throws Exception {
            void var1_1;
            if (this.supportedProtocols.contains(protocol)) {
                this.engineWrapper.setNegotiatedApplicationProtocol(protocol);
                return;
            }
            this.noSelectedMatchFound((String)var1_1);
        }

        protected void noSelectedMatchFound(String protocol) throws Exception {
        }
    }

    private static final class FailProtocolSelector
    extends NoFailProtocolSelector {
        /*
         * WARNING - void declaration
         */
        FailProtocolSelector(JdkSslEngine engineWrapper, Set<String> supportedProtocols) {
            super((JdkSslEngine)var1_1, (Set<String>)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public final String noSelectMatchFound() throws Exception {
            throw new SSLHandshakeException("Selected protocol is not supported");
        }
    }

    static class NoFailProtocolSelector
    implements JdkApplicationProtocolNegotiator.ProtocolSelector {
        private final JdkSslEngine engineWrapper;
        private final Set<String> supportedProtocols;

        /*
         * WARNING - void declaration
         */
        NoFailProtocolSelector(JdkSslEngine engineWrapper, Set<String> supportedProtocols) {
            void var2_2;
            void var1_1;
            this.engineWrapper = var1_1;
            this.supportedProtocols = var2_2;
        }

        @Override
        public void unsupported() {
            this.engineWrapper.setNegotiatedApplicationProtocol(null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String select(List<String> protocols) throws Exception {
            for (String p : this.supportedProtocols) {
                void var3_3;
                if (!protocols.contains(p)) continue;
                this.engineWrapper.setNegotiatedApplicationProtocol(p);
                return var3_3;
            }
            return this.noSelectMatchFound();
        }

        public String noSelectMatchFound() throws Exception {
            this.engineWrapper.setNegotiatedApplicationProtocol(null);
            return null;
        }
    }
}

