/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.JdkAlpnSslUtils;
import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkSslEngine;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.internal.SuppressJava6Requirement;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

@SuppressJava6Requirement(reason="Usage guarded by java version check")
class JdkAlpnSslEngine
extends JdkSslEngine {
    private final JdkApplicationProtocolNegotiator.ProtocolSelectionListener selectionListener;
    private final AlpnSelector alpnSelector;

    /*
     * WARNING - void declaration
     */
    JdkAlpnSslEngine(SSLEngine engine, JdkApplicationProtocolNegotiator applicationNegotiator, boolean isServer, BiConsumer<SSLEngine, AlpnSelector> setHandshakeApplicationProtocolSelector, BiConsumer<SSLEngine, List<String>> setApplicationProtocols) {
        super(engine);
        void var2_2;
        void var1_1;
        void var3_3;
        if (var3_3 != false) {
            this.selectionListener = null;
            this.alpnSelector = new AlpnSelector(this, applicationNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(applicationNegotiator.protocols())));
            setHandshakeApplicationProtocolSelector.accept(engine, this.alpnSelector);
            return;
        }
        this.selectionListener = applicationNegotiator.protocolListenerFactory().newListener(this, applicationNegotiator.protocols());
        this.alpnSelector = null;
        setApplicationProtocols.accept((SSLEngine)var1_1, var2_2.protocols());
    }

    /*
     * WARNING - void declaration
     */
    JdkAlpnSslEngine(SSLEngine engine, JdkApplicationProtocolNegotiator applicationNegotiator, boolean isServer) {
        this((SSLEngine)var1_1, (JdkApplicationProtocolNegotiator)var2_2, (boolean)var3_3, new BiConsumer<SSLEngine, AlpnSelector>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void accept(SSLEngine e, AlpnSelector s) {
                void var2_2;
                JdkAlpnSslUtils.setHandshakeApplicationProtocolSelector(e, (BiFunction<SSLEngine, List<String>, String>)var2_2);
            }
        }, new BiConsumer<SSLEngine, List<String>>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void accept(SSLEngine e, List<String> p) {
                void var2_2;
                JdkAlpnSslUtils.setApplicationProtocols(e, (List<String>)var2_2);
            }
        });
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult verifyProtocolSelection(SSLEngineResult result) throws SSLException {
        void var1_1;
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            if (this.alpnSelector == null) {
                try {
                    void var2_2;
                    String protocol = this.getApplicationProtocol();
                    assert (protocol != null);
                    if (protocol.isEmpty()) {
                        this.selectionListener.unsupported();
                    }
                    this.selectionListener.selected((String)var2_2);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw SslUtils.toSSLHandshakeException(throwable);
                }
            } else {
                assert (this.selectionListener == null);
                this.alpnSelector.checkUnsupported();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SSLEngineResult wrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        void var2_2;
        void var1_1;
        JdkAlpnSslEngine jdkAlpnSslEngine = this;
        return jdkAlpnSslEngine.verifyProtocolSelection(super.wrap((ByteBuffer)var1_1, (ByteBuffer)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, ByteBuffer dst) throws SSLException {
        void var2_2;
        void var1_1;
        JdkAlpnSslEngine jdkAlpnSslEngine = this;
        return jdkAlpnSslEngine.verifyProtocolSelection(super.wrap((ByteBuffer[])var1_1, (ByteBuffer)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int len, ByteBuffer dst) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        JdkAlpnSslEngine jdkAlpnSslEngine = this;
        return jdkAlpnSslEngine.verifyProtocolSelection(super.wrap((ByteBuffer[])var1_1, (int)var2_2, (int)var3_3, dst));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        void var2_2;
        void var1_1;
        JdkAlpnSslEngine jdkAlpnSslEngine = this;
        return jdkAlpnSslEngine.verifyProtocolSelection(super.unwrap((ByteBuffer)var1_1, (ByteBuffer)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts) throws SSLException {
        void var2_2;
        void var1_1;
        JdkAlpnSslEngine jdkAlpnSslEngine = this;
        return jdkAlpnSslEngine.verifyProtocolSelection(super.unwrap((ByteBuffer)var1_1, (ByteBuffer[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dst, int offset, int len) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        JdkAlpnSslEngine jdkAlpnSslEngine = this;
        return jdkAlpnSslEngine.verifyProtocolSelection(super.unwrap((ByteBuffer)var1_1, (ByteBuffer[])var2_2, (int)var3_3, len));
    }

    @Override
    void setNegotiatedApplicationProtocol(String applicationProtocol) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getNegotiatedApplicationProtocol() {
        String protocol = this.getApplicationProtocol();
        if (protocol != null) {
            void var1_1;
            if (protocol.isEmpty()) {
                return null;
            }
            return var1_1;
        }
        return null;
    }

    @Override
    public String getApplicationProtocol() {
        return JdkAlpnSslUtils.getApplicationProtocol(this.getWrappedEngine());
    }

    @Override
    public String getHandshakeApplicationProtocol() {
        return JdkAlpnSslUtils.getHandshakeApplicationProtocol(this.getWrappedEngine());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> selector) {
        void var1_1;
        JdkAlpnSslUtils.setHandshakeApplicationProtocolSelector(this.getWrappedEngine(), (BiFunction<SSLEngine, List<String>, String>)var1_1);
    }

    @Override
    public BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector() {
        return JdkAlpnSslUtils.getHandshakeApplicationProtocolSelector(this.getWrappedEngine());
    }

    final class AlpnSelector
    implements BiFunction<SSLEngine, List<String>, String> {
        private final JdkApplicationProtocolNegotiator.ProtocolSelector selector;
        private boolean called;
        final /* synthetic */ JdkAlpnSslEngine this$0;

        /*
         * WARNING - void declaration
         */
        AlpnSelector(JdkAlpnSslEngine this$0, JdkApplicationProtocolNegotiator.ProtocolSelector selector) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.selector = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String apply(SSLEngine sslEngine, List<String> strings) {
            assert (!this.called);
            this.called = true;
            try {
                void var1_1;
                void var2_2;
                String selected = this.selector.select((List<String>)var2_2);
                if (selected == null) {
                    return "";
                }
                return var1_1;
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        final void checkUnsupported() {
            void var1_1;
            if (this.called) {
                return;
            }
            String protocol = this.this$0.getApplicationProtocol();
            assert (protocol != null);
            if (var1_1.isEmpty()) {
                this.selector.unsupported();
            }
        }
    }
}

