/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.util.CharsetUtil;
import io.netty.util.internal.SuppressJava6Requirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;

@SuppressJava6Requirement(reason="Usage guarded by java version check")
final class Java8SslUtils {
    private Java8SslUtils() {
    }

    /*
     * WARNING - void declaration
     */
    static List<String> getSniHostNames(SSLParameters sslParameters) {
        void var1_1;
        List<SNIServerName> list;
        List<SNIServerName> names = sslParameters.getServerNames();
        if (names == null || names.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> strings = new ArrayList<String>(names.size());
        list = list.iterator();
        while (list.hasNext()) {
            void var2_2;
            SNIServerName serverName = (SNIServerName)list.next();
            if (serverName instanceof SNIHostName) {
                strings.add(((SNIHostName)serverName).getAsciiName());
                continue;
            }
            throw new IllegalArgumentException("Only " + SNIHostName.class.getName() + " instances are supported, but found: " + var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static void setSniHostNames(SSLParameters sslParameters, List<String> names) {
        void var1_1;
        sslParameters.setServerNames(Java8SslUtils.getSniHostNames((List<String>)var1_1));
    }

    static boolean isValidHostNameForSNI(String hostname) {
        try {
            String string;
            new SNIHostName(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    static List getSniHostNames(List<String> names) {
        void var1_1;
        Iterator<String> iterator;
        if (names == null || names.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SNIHostName> sniServerNames = new ArrayList<SNIHostName>(names.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            String name = (String)iterator.next();
            sniServerNames.add(new SNIHostName(var2_2.getBytes(CharsetUtil.UTF_8)));
        }
        return var1_1;
    }

    static List getSniHostName(byte[] hostname) {
        byte[] byArray;
        if (hostname == null || hostname.length == 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new SNIHostName(byArray));
    }

    static boolean getUseCipherSuitesOrder(SSLParameters sslParameters) {
        return sslParameters.getUseCipherSuitesOrder();
    }

    /*
     * WARNING - void declaration
     */
    static void setUseCipherSuitesOrder(SSLParameters sslParameters, boolean useOrder) {
        void var1_1;
        sslParameters.setUseCipherSuitesOrder((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void setSNIMatchers(SSLParameters sslParameters, Collection<?> matchers) {
        void var1_1;
        sslParameters.setSNIMatchers((Collection<SNIMatcher>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static boolean checkSniHostnameMatch(Collection<?> matchers, byte[] hostname) {
        if (matchers != null && !matchers.isEmpty()) {
            SNIHostName name = new SNIHostName(hostname);
            for (SNIMatcher matcher : matchers) {
                void var2_2;
                if (matcher.getType() != 0 || !var2_2.matches(name)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

