/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.util.internal.SuppressJava6Requirement;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

@SuppressJava6Requirement(reason="Usage guarded by java version check")
final class EnhancingX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager wrapped;

    /*
     * WARNING - void declaration
     */
    EnhancingX509ExtendedTrustManager(X509TrustManager wrapped) {
        void var1_1;
        this.wrapped = (X509ExtendedTrustManager)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.wrapped.checkClientTrusted((X509Certificate[])var1_1, (String)var2_2, (Socket)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        try {
            void var3_4;
            this.wrapped.checkServerTrusted(chain, authType, (Socket)var3_4);
            return;
        }
        catch (CertificateException e) {
            void var2_3;
            void var1_1;
            EnhancingX509ExtendedTrustManager.throwEnhancedCertificateException((X509Certificate[])var1_1, (CertificateException)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.wrapped.checkClientTrusted((X509Certificate[])var1_1, (String)var2_2, (SSLEngine)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        try {
            void var3_4;
            this.wrapped.checkServerTrusted(chain, authType, (SSLEngine)var3_4);
            return;
        }
        catch (CertificateException e) {
            void var2_3;
            void var1_1;
            EnhancingX509ExtendedTrustManager.throwEnhancedCertificateException((X509Certificate[])var1_1, (CertificateException)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        void var2_2;
        void var1_1;
        this.wrapped.checkClientTrusted((X509Certificate[])var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.wrapped.checkServerTrusted(chain, authType);
            return;
        }
        catch (CertificateException e) {
            void var2_3;
            void var1_1;
            EnhancingX509ExtendedTrustManager.throwEnhancedCertificateException((X509Certificate[])var1_1, (CertificateException)var2_3);
            return;
        }
    }

    @Override
    public final X509Certificate[] getAcceptedIssuers() {
        return this.wrapped.getAcceptedIssuers();
    }

    /*
     * WARNING - void declaration
     */
    private static void throwEnhancedCertificateException(X509Certificate[] chain, CertificateException e) throws CertificateException {
        void var1_1;
        String message = e.getMessage();
        if (message != null && e.getMessage().startsWith("No subject alternative DNS name matching")) {
            StringBuilder names = new StringBuilder(64);
            for (int i = 0; i < chain.length; ++i) {
                X509Certificate x509Certificate = chain[i];
                Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
                if (collection == null) continue;
                for (List list : collection) {
                    if (list.size() < 2 || (Integer)list.get(0) != 2) continue;
                    names.append((String)list.get(1)).append(",");
                }
            }
            if (names.length() != 0) {
                void var3_3;
                X509Certificate[] x509CertificateArray;
                void var2_2;
                StringBuilder stringBuilder = names;
                stringBuilder.setLength(stringBuilder.length() - 1);
                throw new CertificateException((String)var2_2 + " Subject alternative DNS names in the certificate chain of " + x509CertificateArray.length + " certificate(s): " + var3_3, e);
            }
        }
        throw var1_1;
    }
}

