/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.internal.tcnative.SSL;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import java.security.cert.X509Certificate;

final class DefaultOpenSslKeyMaterial
extends AbstractReferenceCounted
implements OpenSslKeyMaterial {
    private static final ResourceLeakDetector<DefaultOpenSslKeyMaterial> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(DefaultOpenSslKeyMaterial.class);
    private final ResourceLeakTracker<DefaultOpenSslKeyMaterial> leak;
    private final X509Certificate[] x509CertificateChain;
    private long chain;
    private long privateKey;

    /*
     * WARNING - void declaration
     */
    DefaultOpenSslKeyMaterial(long chain, long privateKey, X509Certificate[] x509CertificateChain) {
        void var3_2;
        void var1_1;
        this.chain = var1_1;
        this.privateKey = var3_2;
        this.x509CertificateChain = x509CertificateChain;
        this.leak = leakDetector.track((Object)this);
    }

    @Override
    public final X509Certificate[] certificateChain() {
        return (X509Certificate[])this.x509CertificateChain.clone();
    }

    @Override
    public final long certificateChainAddress() {
        if (this.refCnt() <= 0) {
            throw new IllegalReferenceCountException();
        }
        return this.chain;
    }

    @Override
    public final long privateKeyAddress() {
        if (this.refCnt() <= 0) {
            throw new IllegalReferenceCountException();
        }
        return this.privateKey;
    }

    /*
     * WARNING - void declaration
     */
    protected final void deallocate() {
        SSL.freeX509Chain((long)this.chain);
        this.chain = 0L;
        SSL.freePrivateKey((long)this.privateKey);
        this.privateKey = 0L;
        if (this.leak != null) {
            void var1_1;
            boolean closed = this.leak.close((Object)this);
            assert (var1_1 != false);
        }
    }

    @Override
    public final DefaultOpenSslKeyMaterial retain() {
        if (this.leak != null) {
            this.leak.record();
        }
        super.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultOpenSslKeyMaterial retain(int increment) {
        void var1_1;
        if (this.leak != null) {
            this.leak.record();
        }
        super.retain((int)var1_1);
        return this;
    }

    @Override
    public final DefaultOpenSslKeyMaterial touch() {
        if (this.leak != null) {
            this.leak.record();
        }
        super.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DefaultOpenSslKeyMaterial touch(Object hint) {
        if (this.leak != null) {
            void var1_1;
            this.leak.record((Object)var1_1);
        }
        return this;
    }

    @Override
    public final boolean release() {
        if (this.leak != null) {
            this.leak.record();
        }
        return super.release();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean release(int decrement) {
        void var1_1;
        if (this.leak != null) {
            this.leak.record();
        }
        return super.release((int)var1_1);
    }
}

