/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkSslEngine;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.conscrypt.AllocatedBuffer;
import org.conscrypt.BufferAllocator;
import org.conscrypt.Conscrypt;
import org.conscrypt.HandshakeListener;

abstract class ConscryptAlpnSslEngine
extends JdkSslEngine {
    private static final boolean USE_BUFFER_ALLOCATOR = SystemPropertyUtil.getBoolean((String)"io.netty.handler.ssl.conscrypt.useBufferAllocator", (boolean)true);

    /*
     * WARNING - void declaration
     */
    static ConscryptAlpnSslEngine newClientEngine(SSLEngine engine, ByteBufAllocator alloc, JdkApplicationProtocolNegotiator applicationNegotiator) {
        void var2_2;
        void var1_1;
        SSLEngine sSLEngine;
        return new ClientEngine(sSLEngine, (ByteBufAllocator)var1_1, (JdkApplicationProtocolNegotiator)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static ConscryptAlpnSslEngine newServerEngine(SSLEngine engine, ByteBufAllocator alloc, JdkApplicationProtocolNegotiator applicationNegotiator) {
        void var2_2;
        void var1_1;
        SSLEngine sSLEngine;
        return new ServerEngine(sSLEngine, (ByteBufAllocator)var1_1, (JdkApplicationProtocolNegotiator)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ConscryptAlpnSslEngine(SSLEngine engine, ByteBufAllocator alloc, List<String> protocols) {
        super(engine);
        void var3_3;
        void var1_1;
        if (USE_BUFFER_ALLOCATOR) {
            void var2_2;
            Conscrypt.setBufferAllocator((SSLEngine)engine, (BufferAllocator)new BufferAllocatorAdapter((ByteBufAllocator)var2_2));
        }
        Conscrypt.setApplicationProtocols((SSLEngine)var1_1, (String[])var3_3.toArray(EmptyArrays.EMPTY_STRINGS));
    }

    /*
     * WARNING - void declaration
     */
    final int calculateOutNetBufSize(int plaintextBytes, int numBuffers) {
        void var2_2;
        void var1_1;
        return this.calculateSpace((int)var1_1, (int)var2_2, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    final int calculateRequiredOutBufSpace(int plaintextBytes, int numBuffers) {
        void var2_2;
        void var1_1;
        return this.calculateSpace((int)var1_1, (int)var2_2, Conscrypt.maxEncryptedPacketLength());
    }

    /*
     * WARNING - void declaration
     */
    private int calculateSpace(int plaintextBytes, int numBuffers, long maxPacketLength) {
        void var1_1;
        void var3_3;
        void var2_2;
        long maxOverhead = (long)Conscrypt.maxSealOverhead((SSLEngine)this.getWrappedEngine()) * (long)var2_2;
        return (int)Math.min((long)var3_3, (long)var1_1 + maxOverhead);
    }

    /*
     * WARNING - void declaration
     */
    final SSLEngineResult unwrap(ByteBuffer[] srcs, ByteBuffer[] dests) throws SSLException {
        void var2_2;
        void var1_1;
        return Conscrypt.unwrap((SSLEngine)this.getWrappedEngine(), (ByteBuffer[])var1_1, (ByteBuffer[])var2_2);
    }

    private static final class BufferAdapter
    extends AllocatedBuffer {
        private final ByteBuf nettyBuffer;
        private final ByteBuffer buffer;

        /*
         * WARNING - void declaration
         */
        BufferAdapter(ByteBuf nettyBuffer) {
            void var1_1;
            this.nettyBuffer = nettyBuffer;
            this.buffer = nettyBuffer.nioBuffer(0, var1_1.capacity());
        }

        public final ByteBuffer nioBuffer() {
            return this.buffer;
        }

        public final AllocatedBuffer retain() {
            this.nettyBuffer.retain();
            return this;
        }

        public final AllocatedBuffer release() {
            this.nettyBuffer.release();
            return this;
        }
    }

    private static final class BufferAllocatorAdapter
    extends BufferAllocator {
        private final ByteBufAllocator alloc;

        /*
         * WARNING - void declaration
         */
        BufferAllocatorAdapter(ByteBufAllocator alloc) {
            void var1_1;
            this.alloc = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final AllocatedBuffer allocateDirectBuffer(int capacity) {
            void var1_1;
            return new BufferAdapter(this.alloc.directBuffer((int)var1_1));
        }
    }

    private static final class ServerEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector;

        /*
         * WARNING - void declaration
         */
        ServerEngine(SSLEngine engine, ByteBufAllocator alloc, JdkApplicationProtocolNegotiator applicationNegotiator) {
            super(engine, (ByteBufAllocator)var2_2, applicationNegotiator.protocols());
            void var3_3;
            void var1_1;
            void var2_2;
            Conscrypt.setHandshakeListener((SSLEngine)var1_1, (HandshakeListener)new HandshakeListener(this){
                final /* synthetic */ ServerEngine this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                public void onHandshakeFinished() throws SSLException {
                    this.this$0.selectProtocol();
                }
            });
            this.protocolSelector = (JdkApplicationProtocolNegotiator.ProtocolSelector)ObjectUtil.checkNotNull((Object)applicationNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(var3_3.protocols())), (String)"protocolSelector");
        }

        /*
         * WARNING - void declaration
         */
        private void selectProtocol() throws SSLException {
            try {
                void var1_1;
                String protocol = Conscrypt.getApplicationProtocol((SSLEngine)this.getWrappedEngine());
                this.protocolSelector.select(protocol != null ? Collections.singletonList(var1_1) : Collections.emptyList());
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw SslUtils.toSSLHandshakeException(throwable);
            }
        }
    }

    private static final class ClientEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolListener;

        /*
         * WARNING - void declaration
         */
        ClientEngine(SSLEngine engine, ByteBufAllocator alloc, JdkApplicationProtocolNegotiator applicationNegotiator) {
            super(engine, (ByteBufAllocator)var2_2, applicationNegotiator.protocols());
            void var3_3;
            void var1_1;
            void var2_2;
            Conscrypt.setHandshakeListener((SSLEngine)var1_1, (HandshakeListener)new HandshakeListener(this){
                final /* synthetic */ ClientEngine this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                public void onHandshakeFinished() throws SSLException {
                    this.this$0.selectProtocol();
                }
            });
            this.protocolListener = (JdkApplicationProtocolNegotiator.ProtocolSelectionListener)ObjectUtil.checkNotNull((Object)applicationNegotiator.protocolListenerFactory().newListener(this, var3_3.protocols()), (String)"protocolListener");
        }

        private void selectProtocol() throws SSLException {
            Throwable throwable;
            String protocol = Conscrypt.getApplicationProtocol((SSLEngine)this.getWrappedEngine());
            try {
                this.protocolListener.selected((String)((Object)throwable));
                return;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw SslUtils.toSSLHandshakeException(throwable2);
            }
        }
    }
}

