/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ConscryptAlpnSslEngine;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;

final class Conscrypt {
    private static final Method IS_CONSCRYPT_SSLENGINE;

    static boolean isAvailable() {
        return IS_CONSCRYPT_SSLENGINE != null;
    }

    /*
     * WARNING - void declaration
     */
    static boolean isEngineSupported(SSLEngine engine) {
        try {
            return IS_CONSCRYPT_SSLENGINE != null && (Boolean)IS_CONSCRYPT_SSLENGINE.invoke(null, engine) != false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException ex) {
            void var0_1;
            throw new RuntimeException((Throwable)var0_1);
        }
    }

    private Conscrypt() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        Method isConscryptSSLEngine = null;
        if (PlatformDependent.javaVersion() >= 8 && PlatformDependent.javaVersion() < 15 || PlatformDependent.isAndroid()) {
            try {
                Class<?> clazz = Class.forName("org.conscrypt.OpenSSLProvider", true, PlatformDependent.getClassLoader(ConscryptAlpnSslEngine.class));
                clazz.newInstance();
                clazz = Class.forName("org.conscrypt.Conscrypt", true, PlatformDependent.getClassLoader(ConscryptAlpnSslEngine.class));
                isConscryptSSLEngine = clazz.getMethod("isConscrypt", SSLEngine.class);
            }
            catch (Throwable throwable) {}
        }
        IS_CONSCRYPT_SSLENGINE = var0;
    }
}

