/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CipherSuiteConverter {
    private static final InternalLogger logger;
    private static final Pattern JAVA_CIPHERSUITE_PATTERN;
    private static final Pattern OPENSSL_CIPHERSUITE_PATTERN;
    private static final Pattern JAVA_AES_CBC_PATTERN;
    private static final Pattern JAVA_AES_PATTERN;
    private static final Pattern OPENSSL_AES_CBC_PATTERN;
    private static final Pattern OPENSSL_AES_PATTERN;
    private static final ConcurrentMap<String, CachedValue> j2o;
    private static final ConcurrentMap<String, Map<String, String>> o2j;
    private static final Map<String, String> j2oTls13;
    private static final Map<String, Map<String, String>> o2jTls13;

    static void clearCache() {
        j2o.clear();
        o2j.clear();
    }

    /*
     * WARNING - void declaration
     */
    static boolean isJ2OCached(String key, String value) {
        CachedValue cachedValue;
        void var1_1;
        CachedValue cached = (CachedValue)j2o.get(key);
        return cached != null && var1_1.equals(cachedValue.value);
    }

    /*
     * WARNING - void declaration
     */
    static boolean isO2JCached(String key, String protocol, String value) {
        void var1_1;
        Map map;
        void var2_2;
        Map p2j = (Map)o2j.get(key);
        if (p2j == null) {
            return false;
        }
        return var2_2.equals(map.get(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String toOpenSsl(String javaCipherSuite, boolean boringSSL) {
        void var1_1;
        String string;
        CachedValue converted = (CachedValue)j2o.get(javaCipherSuite);
        if (converted != null) {
            void var2_2;
            return var2_2.value;
        }
        return CipherSuiteConverter.cacheFromJava(string, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static String cacheFromJava(String javaCipherSuite, boolean boringSSL) {
        void var1_2;
        String string;
        void var3_4;
        void var2_3;
        String converted = j2oTls13.get(javaCipherSuite);
        if (converted != null) {
            if (boringSSL) {
                return converted;
            }
            return javaCipherSuite;
        }
        String openSslCipherSuite = CipherSuiteConverter.toOpenSslUncached(javaCipherSuite, boringSSL);
        j2o.putIfAbsent(javaCipherSuite, CachedValue.of(openSslCipherSuite));
        if (openSslCipherSuite == null) {
            return null;
        }
        String javaCipherSuiteSuffix = javaCipherSuite.substring(4);
        HashMap<String, String> p2j = new HashMap<String, String>(4);
        p2j.put("", javaCipherSuiteSuffix);
        p2j.put("SSL", "SSL_" + javaCipherSuiteSuffix);
        p2j.put("TLS", "TLS_" + (String)var2_3);
        o2j.put(openSslCipherSuite, (Map<String, String>)var3_4);
        logger.debug("Cipher suite mapping: {} => {}", (Object)string, (Object)openSslCipherSuite);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    static String toOpenSslUncached(String javaCipherSuite, boolean boringSSL) {
        String string;
        void var2_3;
        void var1_2;
        String converted = j2oTls13.get(javaCipherSuite);
        if (converted != null) {
            if (boringSSL) {
                return converted;
            }
            return javaCipherSuite;
        }
        String m = JAVA_CIPHERSUITE_PATTERN.matcher(javaCipherSuite);
        if (!((Matcher)((Object)m)).matches()) {
            return null;
        }
        String handshakeAlgo = CipherSuiteConverter.toOpenSslHandshakeAlgo(((Matcher)((Object)m)).group(1));
        String bulkCipher = CipherSuiteConverter.toOpenSslBulkCipher(((Matcher)((Object)m)).group(2));
        String hmacAlgo = CipherSuiteConverter.toOpenSslHmacAlgo(((Matcher)((Object)m)).group(3));
        if (handshakeAlgo.isEmpty()) {
            return bulkCipher + '-' + (String)hmacAlgo;
        }
        if (bulkCipher.contains("CHACHA20")) {
            return handshakeAlgo + '-' + bulkCipher;
        }
        return (String)var1_2 + '-' + (String)var2_3 + '-' + (String)string;
    }

    /*
     * WARNING - void declaration
     */
    private static String toOpenSslHandshakeAlgo(String handshakeAlgo) {
        String string;
        void var1_1;
        boolean export = handshakeAlgo.endsWith("_EXPORT");
        if (export) {
            handshakeAlgo = handshakeAlgo.substring(0, handshakeAlgo.length() - 7);
        }
        if ("RSA".equals(handshakeAlgo)) {
            handshakeAlgo = "";
        } else if (handshakeAlgo.endsWith("_anon")) {
            handshakeAlgo = "A" + handshakeAlgo.substring(0, handshakeAlgo.length() - 5);
        }
        if (var1_1 != false) {
            handshakeAlgo = handshakeAlgo.isEmpty() ? "EXP" : "EXP-" + handshakeAlgo;
        }
        return string.replace('_', '-');
    }

    /*
     * WARNING - void declaration
     */
    private static String toOpenSslBulkCipher(String bulkCipher) {
        String string;
        if (bulkCipher.startsWith("AES_")) {
            Matcher m = JAVA_AES_CBC_PATTERN.matcher(bulkCipher);
            if (m.matches()) {
                return m.replaceFirst("$1$2");
            }
            m = JAVA_AES_PATTERN.matcher(bulkCipher);
            if (m.matches()) {
                void var1_1;
                return var1_1.replaceFirst("$1$2-$3");
            }
        }
        if ("3DES_EDE_CBC".equals(bulkCipher)) {
            return "DES-CBC3";
        }
        if ("RC4_128".equals(bulkCipher) || "RC4_40".equals(bulkCipher)) {
            return "RC4";
        }
        if ("DES40_CBC".equals(bulkCipher) || "DES_CBC_40".equals(bulkCipher)) {
            return "DES-CBC";
        }
        if ("RC2_CBC_40".equals(bulkCipher)) {
            return "RC2-CBC";
        }
        return string.replace('_', '-');
    }

    private static String toOpenSslHmacAlgo(String hmacAlgo) {
        return hmacAlgo;
    }

    /*
     * WARNING - void declaration
     */
    public static String toJava(String openSslCipherSuite, String protocol) {
        String string;
        Map<String, String> p2j = (Map<String, String>)o2j.get(openSslCipherSuite);
        if (p2j == null && (p2j = CipherSuiteConverter.cacheFromOpenSsl(openSslCipherSuite)) == null) {
            return null;
        }
        String javaCipherSuite = (String)p2j.get(protocol);
        if (javaCipherSuite == null) {
            void var1_1;
            void var2_2;
            String cipher = (String)var2_2.get("");
            if (cipher == null) {
                return null;
            }
            string = (String)var1_1 + '_' + string;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> cacheFromOpenSsl(String openSslCipherSuite) {
        String string;
        void var2_2;
        void var3_3;
        void var1_1;
        Map<String, String> converted = o2jTls13.get(openSslCipherSuite);
        if (converted != null) {
            return converted;
        }
        String javaCipherSuiteSuffix = CipherSuiteConverter.toJavaUncached0(openSslCipherSuite, false);
        if (javaCipherSuiteSuffix == null) {
            return null;
        }
        String javaCipherSuiteSsl = "SSL_" + javaCipherSuiteSuffix;
        String javaCipherSuiteTls = "TLS_" + javaCipherSuiteSuffix;
        HashMap<String, String> p2j = new HashMap<String, String>(4);
        p2j.put("", javaCipherSuiteSuffix);
        p2j.put("SSL", javaCipherSuiteSsl);
        p2j.put("TLS", javaCipherSuiteTls);
        o2j.putIfAbsent(openSslCipherSuite, p2j);
        CachedValue cachedValue = CachedValue.of(openSslCipherSuite);
        j2o.putIfAbsent(javaCipherSuiteTls, cachedValue);
        j2o.putIfAbsent(javaCipherSuiteSsl, (CachedValue)var1_1);
        logger.debug("Cipher suite mapping: {} => {}", (Object)var3_3, (Object)openSslCipherSuite);
        logger.debug("Cipher suite mapping: {} => {}", (Object)var2_2, (Object)string);
        return p2j;
    }

    static String toJavaUncached(String openSslCipherSuite) {
        return CipherSuiteConverter.toJavaUncached0(openSslCipherSuite, true);
    }

    /*
     * Unable to fully structure code
     */
    private static String toJavaUncached0(String openSslCipherSuite, boolean checkTls13) {
        block7: {
            if (checkTls13 && (converted = CipherSuiteConverter.o2jTls13.get(openSslCipherSuite)) != null) {
                return converted.get("TLS");
            }
            m = CipherSuiteConverter.OPENSSL_CIPHERSUITE_PATTERN.matcher(openSslCipherSuite);
            if (!m.matches()) {
                return null;
            }
            handshakeAlgo = m.group(1);
            if (handshakeAlgo != null) break block7;
            handshakeAlgo = "";
            ** GOTO lbl-1000
        }
        if (handshakeAlgo.startsWith("EXP-")) {
            handshakeAlgo = handshakeAlgo.substring(4);
            export = true;
        } else if ("EXP".equals(handshakeAlgo)) {
            handshakeAlgo = "";
            export = true;
        } else lbl-1000:
        // 2 sources

        {
            export = false;
        }
        handshakeAlgo = CipherSuiteConverter.toJavaHandshakeAlgo(handshakeAlgo, export);
        bulkCipher = CipherSuiteConverter.toJavaBulkCipher(m.group(2), export);
        hmacAlgo = CipherSuiteConverter.toJavaHmacAlgo(m.group(3));
        javaCipherSuite = handshakeAlgo + "_WITH_" + bulkCipher + '_' + (String)var1_3;
        if (var2_5.contains("CHACHA20")) {
            return javaCipherSuite + "_SHA256";
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static String toJavaHandshakeAlgo(String handshakeAlgo, boolean export) {
        String string;
        void var1_1;
        if (handshakeAlgo.isEmpty()) {
            handshakeAlgo = "RSA";
        } else if ("ADH".equals(handshakeAlgo)) {
            handshakeAlgo = "DH_anon";
        } else if ("AECDH".equals(handshakeAlgo)) {
            handshakeAlgo = "ECDH_anon";
        }
        handshakeAlgo = handshakeAlgo.replace('-', '_');
        if (var1_1 != false) {
            return handshakeAlgo + "_EXPORT";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static String toJavaBulkCipher(String bulkCipher, boolean export) {
        String string;
        if (bulkCipher.startsWith("AES")) {
            Matcher m = OPENSSL_AES_CBC_PATTERN.matcher(bulkCipher);
            if (m.matches()) {
                return m.replaceFirst("$1_$2_CBC");
            }
            m = OPENSSL_AES_PATTERN.matcher(bulkCipher);
            if (m.matches()) {
                void var2_2;
                return var2_2.replaceFirst("$1_$2_$3");
            }
        }
        if ("DES-CBC3".equals(bulkCipher)) {
            return "3DES_EDE_CBC";
        }
        if ("RC4".equals(bulkCipher)) {
            if (export) {
                return "RC4_40";
            }
            return "RC4_128";
        }
        if ("DES-CBC".equals(bulkCipher)) {
            if (export) {
                return "DES_CBC_40";
            }
            return "DES_CBC";
        }
        if ("RC2-CBC".equals(bulkCipher)) {
            void var1_1;
            if (var1_1 != false) {
                return "RC2_CBC_40";
            }
            return "RC2_CBC";
        }
        return string.replace('-', '_');
    }

    private static String toJavaHmacAlgo(String hmacAlgo) {
        return hmacAlgo;
    }

    /*
     * WARNING - void declaration
     */
    static void convertToCipherStrings(Iterable<String> cipherSuites, StringBuilder cipherBuilder, StringBuilder cipherTLSv13Builder, boolean boringSSL) {
        String c;
        Iterator<String> iterator = cipherSuites.iterator();
        while (iterator.hasNext() && (c = (String)iterator.next()) != null) {
            String converted = CipherSuiteConverter.toOpenSsl(c, boringSSL);
            if (converted == null) {
                converted = c;
            }
            if (!OpenSsl.isCipherSuiteAvailable(converted)) {
                throw new IllegalArgumentException("unsupported cipher suite: " + c + '(' + converted + ')');
            }
            if (SslUtils.isTLSv13Cipher(converted) || SslUtils.isTLSv13Cipher(c)) {
                cipherTLSv13Builder.append(converted);
                cipherTLSv13Builder.append(':');
                continue;
            }
            cipherBuilder.append(converted);
            cipherBuilder.append(':');
        }
        if (cipherBuilder.length() == 0 && cipherTLSv13Builder.length() == 0) {
            throw new IllegalArgumentException("empty cipher suites");
        }
        if (cipherBuilder.length() > 0) {
            void var1_1;
            void v0 = var1_1;
            v0.setLength(v0.length() - 1);
        }
        if (cipherTLSv13Builder.length() > 0) {
            void var2_2;
            void v1 = var2_2;
            v1.setLength(v1.length() - 1);
        }
    }

    private CipherSuiteConverter() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        logger = InternalLoggerFactory.getInstance(CipherSuiteConverter.class);
        JAVA_CIPHERSUITE_PATTERN = Pattern.compile("^(?:TLS|SSL)_((?:(?!_WITH_).)+)_WITH_(.*)_(.*)$");
        OPENSSL_CIPHERSUITE_PATTERN = Pattern.compile("^(?:((?:(?:EXP-)?(?:(?:DHE|EDH|ECDH|ECDHE|SRP|RSA)-(?:DSS|RSA|ECDSA|PSK)|(?:ADH|AECDH|KRB5|PSK|SRP)))|EXP)-)?(.*)-(.*)$");
        JAVA_AES_CBC_PATTERN = Pattern.compile("^(AES)_([0-9]+)_CBC$");
        JAVA_AES_PATTERN = Pattern.compile("^(AES)_([0-9]+)_(.*)$");
        OPENSSL_AES_CBC_PATTERN = Pattern.compile("^(AES)([0-9]+)$");
        OPENSSL_AES_PATTERN = Pattern.compile("^(AES)([0-9]+)-(.*)$");
        j2o = PlatformDependent.newConcurrentHashMap();
        o2j = PlatformDependent.newConcurrentHashMap();
        HashMap<String, String> j2oTls13Map = new HashMap<String, String>();
        j2oTls13Map.put("TLS_AES_128_GCM_SHA256", "AEAD-AES128-GCM-SHA256");
        j2oTls13Map.put("TLS_AES_256_GCM_SHA384", "AEAD-AES256-GCM-SHA384");
        j2oTls13Map.put("TLS_CHACHA20_POLY1305_SHA256", "AEAD-CHACHA20-POLY1305-SHA256");
        j2oTls13 = Collections.unmodifiableMap(j2oTls13Map);
        HashMap<String, Map<String, String>> o2jTls13Map = new HashMap<String, Map<String, String>>();
        o2jTls13Map.put("TLS_AES_128_GCM_SHA256", Collections.singletonMap("TLS", "TLS_AES_128_GCM_SHA256"));
        o2jTls13Map.put("TLS_AES_256_GCM_SHA384", Collections.singletonMap("TLS", "TLS_AES_256_GCM_SHA384"));
        o2jTls13Map.put("TLS_CHACHA20_POLY1305_SHA256", Collections.singletonMap("TLS", "TLS_CHACHA20_POLY1305_SHA256"));
        o2jTls13Map.put("AEAD-AES128-GCM-SHA256", Collections.singletonMap("TLS", "TLS_AES_128_GCM_SHA256"));
        o2jTls13Map.put("AEAD-AES256-GCM-SHA384", Collections.singletonMap("TLS", "TLS_AES_256_GCM_SHA384"));
        o2jTls13Map.put("AEAD-CHACHA20-POLY1305-SHA256", Collections.singletonMap("TLS", "TLS_CHACHA20_POLY1305_SHA256"));
        o2jTls13 = Collections.unmodifiableMap(var0);
    }

    private static final class CachedValue {
        private static final CachedValue NULL = new CachedValue(null);
        final String value;

        static CachedValue of(String value) {
            if (value != null) {
                String string;
                return new CachedValue(string);
            }
            return NULL;
        }

        /*
         * WARNING - void declaration
         */
        private CachedValue(String value) {
            void var1_1;
            this.value = var1_1;
        }
    }
}

