/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.util.CharsetUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;

final class BouncyCastlePemReader {
    private static final String BC_PROVIDER = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final String BC_PEMPARSER = "org.bouncycastle.openssl.PEMParser";
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(BouncyCastlePemReader.class);
    private static volatile Throwable unavailabilityCause;
    private static volatile Provider bcProvider;
    private static volatile boolean attemptedLoading;

    public static boolean hasAttemptedLoading() {
        return attemptedLoading;
    }

    public static boolean isAvailable() {
        if (!BouncyCastlePemReader.hasAttemptedLoading()) {
            BouncyCastlePemReader.tryLoading();
        }
        return unavailabilityCause == null;
    }

    public static Throwable unavailabilityCause() {
        return unavailabilityCause;
    }

    private static void tryLoading() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final Void run() {
                try {
                    void var2_3;
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Class<?> bcProviderClass = Class.forName(BouncyCastlePemReader.BC_PROVIDER, true, classLoader);
                    Class.forName(BouncyCastlePemReader.BC_PEMPARSER, true, classLoader);
                    bcProvider = (Provider)var2_3.getConstructor(new Class[0]).newInstance(new Object[0]);
                    logger.debug("Bouncy Castle provider available");
                    attemptedLoading = true;
                }
                catch (Throwable e) {
                    void var1_2;
                    logger.debug("Cannot load Bouncy Castle provider", e);
                    unavailabilityCause = (Throwable)var1_2;
                    attemptedLoading = true;
                }
                return null;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static PrivateKey getPrivateKey(InputStream keyInputStream, String keyPassword) {
        if (!BouncyCastlePemReader.isAvailable()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Bouncy castle provider is unavailable.", BouncyCastlePemReader.unavailabilityCause());
            }
            return null;
        }
        try {
            void var1_2;
            keyInputStream = BouncyCastlePemReader.newParser(keyInputStream);
            return BouncyCastlePemReader.getPrivateKey((PEMParser)keyInputStream, (String)var1_2);
        }
        catch (Exception e) {
            void var0_1;
            logger.debug("Unable to extract private key", (Throwable)var0_1);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static PrivateKey getPrivateKey(File keyFile, String keyPassword) {
        if (!BouncyCastlePemReader.isAvailable()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Bouncy castle provider is unavailable.", BouncyCastlePemReader.unavailabilityCause());
            }
            return null;
        }
        try {
            void var1_2;
            keyFile = BouncyCastlePemReader.newParser(keyFile);
            return BouncyCastlePemReader.getPrivateKey((PEMParser)keyFile, (String)var1_2);
        }
        catch (Exception e) {
            void var0_1;
            logger.debug("Unable to extract private key", (Throwable)var0_1);
            return null;
        }
    }

    private static JcaPEMKeyConverter newConverter() {
        return new JcaPEMKeyConverter().setProvider(bcProvider);
    }

    /*
     * WARNING - void declaration
     */
    private static PrivateKey getPrivateKey(PEMParser pemParser, String keyPassword) throws IOException, PKCSException, OperatorCreationException {
        PrivateKey privateKey;
        block20: {
            try {
                JcaPEMKeyConverter converter = BouncyCastlePemReader.newConverter();
                PrivateKey pk = null;
                Object object = pemParser.readObject();
                while (object != null && pk == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Parsed PEM object of type {} and assume key is {}encrypted", (Object)object.getClass().getName(), (Object)(keyPassword == null ? "not " : ""));
                    }
                    if (keyPassword == null) {
                        if (object instanceof PrivateKeyInfo) {
                            pk = converter.getPrivateKey((PrivateKeyInfo)object);
                        } else if (object instanceof PEMKeyPair) {
                            pk = converter.getKeyPair((PEMKeyPair)object).getPrivate();
                        } else {
                            logger.debug("Unable to handle PEM object of type {} as a non encrypted key", object.getClass());
                        }
                    } else if (object instanceof PEMEncryptedKeyPair) {
                        Object decProv = new JcePEMDecryptorProviderBuilder().setProvider(bcProvider).build(keyPassword.toCharArray());
                        decProv = converter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(decProv)).getPrivate();
                    } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                        InputDecryptorProvider pkcs8InputDecryptorProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider(bcProvider).build(keyPassword.toCharArray());
                        privateKey = converter.getPrivateKey(((PKCS8EncryptedPrivateKeyInfo)object).decryptPrivateKeyInfo((InputDecryptorProvider)privateKey));
                    } else {
                        logger.debug("Unable to handle PEM object of type {} as a encrypted key", object.getClass());
                    }
                    if (privateKey != null) continue;
                    object = pemParser.readObject();
                }
                if (privateKey == null && logger.isDebugEnabled()) {
                    logger.debug("No key found");
                }
                if (pemParser == null) break block20;
            }
            catch (Throwable throwable) {
                PEMParser exception;
                if (exception != null) {
                    try {
                        exception.close();
                    }
                    catch (Exception exception2) {
                        void var0_2;
                        logger.debug("Failed closing pem parser", (Throwable)var0_2);
                    }
                }
                throw throwable;
            }
            try {
                pemParser.close();
            }
            catch (Exception exception) {
                logger.debug("Failed closing pem parser", (Throwable)exception);
            }
        }
        return privateKey;
    }

    private static PEMParser newParser(File keyFile) throws FileNotFoundException {
        File file;
        return new PEMParser((Reader)new FileReader(file));
    }

    private static PEMParser newParser(InputStream keyInputStream) {
        InputStream inputStream;
        return new PEMParser((Reader)new InputStreamReader(inputStream, CharsetUtil.US_ASCII));
    }

    private BouncyCastlePemReader() {
    }
}

