/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.JdkAlpnSslUtils;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

@SuppressJava6Requirement(reason="Usage guarded by java version check")
final class BouncyCastleAlpnSslUtils {
    private static final InternalLogger logger;
    private static final Method SET_PARAMETERS;
    private static final Method GET_PARAMETERS;
    private static final Method SET_APPLICATION_PROTOCOLS;
    private static final Method GET_APPLICATION_PROTOCOL;
    private static final Method GET_HANDSHAKE_APPLICATION_PROTOCOL;
    private static final Method SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;
    private static final Method GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;
    private static final Class BC_APPLICATION_PROTOCOL_SELECTOR;
    private static final Method BC_APPLICATION_PROTOCOL_SELECTOR_SELECT;

    private BouncyCastleAlpnSslUtils() {
    }

    /*
     * WARNING - void declaration
     */
    static String getApplicationProtocol(SSLEngine sslEngine) {
        try {
            return (String)GET_APPLICATION_PROTOCOL.invoke(sslEngine, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            sslEngine = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception ex) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void setApplicationProtocols(SSLEngine engine, List<String> supportedProtocols) {
        String[] protocolArray = supportedProtocols.toArray(EmptyArrays.EMPTY_STRINGS);
        try {
            void var2_2;
            Object bcSslParameters = GET_PARAMETERS.invoke((Object)engine, new Object[0]);
            SET_APPLICATION_PROTOCOLS.invoke(bcSslParameters, var2_2);
            SET_PARAMETERS.invoke((Object)engine, bcSslParameters);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            UnsupportedOperationException bcSslParameters = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception ex) {
            void var3_5;
            throw new IllegalStateException((Throwable)var3_5);
        }
        if (PlatformDependent.javaVersion() >= 9) {
            void var1_1;
            SSLEngine sSLEngine;
            JdkAlpnSslUtils.setApplicationProtocols(sSLEngine, (List<String>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static String getHandshakeApplicationProtocol(SSLEngine sslEngine) {
        try {
            return (String)GET_HANDSHAKE_APPLICATION_PROTOCOL.invoke(sslEngine, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            sslEngine = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception ex) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void setHandshakeApplicationProtocolSelector(SSLEngine engine, final BiFunction<SSLEngine, List<String>, String> selector) {
        Object selectorProxyInstance;
        try {
            SSLEngine sSLEngine;
            selectorProxyInstance = Proxy.newProxyInstance(BouncyCastleAlpnSslUtils.class.getClassLoader(), new Class[]{BC_APPLICATION_PROTOCOL_SELECTOR}, new InvocationHandler(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    void var2_3;
                    if (method.getName().equals("select")) {
                        try {
                            void var3_4;
                            return selector.apply((SSLEngine)args[0], (List)var3_4[1]);
                        }
                        catch (ClassCastException e) {
                            void var1_2;
                            throw new RuntimeException("BCApplicationProtocolSelector select method parameter of invalid type.", (Throwable)var1_2);
                        }
                    }
                    throw new UnsupportedOperationException(String.format("Method '%s' not supported.", var2_3.getName()));
                }
            });
            SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke((Object)sSLEngine, selectorProxyInstance);
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            selectorProxyInstance = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception ex) {
            void var1_2;
            throw new IllegalStateException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    static BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector(SSLEngine engine) {
        Object selector;
        try {
            selector = GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke((Object)engine, new Object[0]);
            return new BiFunction<SSLEngine, List<String>, String>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final String apply(SSLEngine sslEngine, List<String> strings) {
                    try {
                        void var2_3;
                        return (String)BC_APPLICATION_PROTOCOL_SELECTOR_SELECT.invoke(selector, sslEngine, var2_3);
                    }
                    catch (Exception e) {
                        void var1_2;
                        throw new RuntimeException("Could not call getHandshakeApplicationProtocolSelector", (Throwable)var1_2);
                    }
                }
            };
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            selector = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception ex) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_7;
        void var2_8;
        void var1_9;
        Method getHandshakeApplicationProtocolSelector;
        Method setHandshakeApplicationProtocolSelector;
        Method getHandshakeApplicationProtocol;
        Method getApplicationProtocol;
        Method setApplicationProtocols;
        Method setParameters;
        Method getParameters;
        Method bcApplicationProtocolSelectorSelect;
        Class<?> bcApplicationProtocolSelector;
        Object object;
        logger = InternalLoggerFactory.getInstance(BouncyCastleAlpnSslUtils.class);
        try {
            object = Class.forName("org.bouncycastle.jsse.BCSSLEngine");
            final Class<?> testBCSslEngine = object;
            final Class<?> testBCApplicationProtocolSelector = bcApplicationProtocolSelector = Class.forName("org.bouncycastle.jsse.BCApplicationProtocolSelector");
            bcApplicationProtocolSelectorSelect = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() throws Exception {
                    return testBCApplicationProtocolSelector.getMethod("select", Object.class, List.class);
                }
            });
            object = SslUtils.getSSLContext("BCJSSE");
            SSLEngine engine = ((SSLContext)object).createSSLEngine();
            getParameters = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() throws Exception {
                    return testBCSslEngine.getMethod("getParameters", new Class[0]);
                }
            });
            Object bcSslParameters = getParameters.invoke((Object)engine, new Object[0]);
            final Class<?> bCSslParametersClass = bcSslParameters.getClass();
            setParameters = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() throws Exception {
                    return testBCSslEngine.getMethod("setParameters", bCSslParametersClass);
                }
            });
            setParameters.invoke((Object)engine, bcSslParameters);
            setApplicationProtocols = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() throws Exception {
                    return bCSslParametersClass.getMethod("setApplicationProtocols", String[].class);
                }
            });
            setApplicationProtocols.invoke(bcSslParameters, new Object[]{EmptyArrays.EMPTY_STRINGS});
            getApplicationProtocol = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() throws Exception {
                    return testBCSslEngine.getMethod("getApplicationProtocol", new Class[0]);
                }
            });
            getApplicationProtocol.invoke((Object)engine, new Object[0]);
            getHandshakeApplicationProtocol = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() throws Exception {
                    return testBCSslEngine.getMethod("getHandshakeApplicationProtocol", new Class[0]);
                }
            });
            getHandshakeApplicationProtocol.invoke((Object)engine, new Object[0]);
            setHandshakeApplicationProtocolSelector = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() throws Exception {
                    return testBCSslEngine.getMethod("setBCHandshakeApplicationProtocolSelector", testBCApplicationProtocolSelector);
                }
            });
            getHandshakeApplicationProtocolSelector = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() throws Exception {
                    return testBCSslEngine.getMethod("getBCHandshakeApplicationProtocolSelector", new Class[0]);
                }
            });
            getHandshakeApplicationProtocolSelector.invoke((Object)engine, new Object[0]);
        }
        catch (Throwable t) {
            logger.error("Unable to initialize BouncyCastleAlpnSslUtils.", t);
            setParameters = null;
            getParameters = null;
            setApplicationProtocols = null;
            getApplicationProtocol = null;
            getHandshakeApplicationProtocol = null;
            setHandshakeApplicationProtocolSelector = null;
            getHandshakeApplicationProtocolSelector = null;
            bcApplicationProtocolSelectorSelect = null;
            bcApplicationProtocolSelector = null;
        }
        SET_PARAMETERS = var1_9;
        GET_PARAMETERS = object;
        SET_APPLICATION_PROTOCOLS = var2_8;
        GET_APPLICATION_PROTOCOL = var3_7;
        GET_HANDSHAKE_APPLICATION_PROTOCOL = getHandshakeApplicationProtocol;
        SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = setHandshakeApplicationProtocolSelector;
        GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = getHandshakeApplicationProtocolSelector;
        BC_APPLICATION_PROTOCOL_SELECTOR_SELECT = bcApplicationProtocolSelectorSelect;
        BC_APPLICATION_PROTOCOL_SELECTOR = bcApplicationProtocolSelector;
    }
}

