/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.RecyclableArrayList;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import javax.net.ssl.SSLException;

public abstract class ApplicationProtocolNegotiationHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ApplicationProtocolNegotiationHandler.class);
    private final String fallbackProtocol;
    private final RecyclableArrayList bufferedMessages = RecyclableArrayList.newInstance();
    private ChannelHandlerContext ctx;
    private boolean sslHandlerChecked;

    /*
     * WARNING - void declaration
     */
    protected ApplicationProtocolNegotiationHandler(String fallbackProtocol) {
        void var1_1;
        this.fallbackProtocol = (String)ObjectUtil.checkNotNull((Object)var1_1, (String)"fallbackProtocol");
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.ctx = ctx;
        super.handlerAdded((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.fireBufferedMessages();
        this.bufferedMessages.recycle();
        super.handlerRemoved((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        this.bufferedMessages.add((Object)var2_2);
        if (!this.sslHandlerChecked) {
            this.sslHandlerChecked = true;
            if (ctx.pipeline().get(SslHandler.class) == null) {
                void var1_1;
                this.removeSelfIfPresent((ChannelHandlerContext)var1_1);
            }
        }
    }

    private void fireBufferedMessages() {
        if (!this.bufferedMessages.isEmpty()) {
            for (int i = 0; i < this.bufferedMessages.size(); ++i) {
                this.ctx.fireChannelRead(this.bufferedMessages.get(i));
            }
            this.ctx.fireChannelReadComplete();
            this.bufferedMessages.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        void var2_2;
        void var1_1;
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
            try {
                if (handshakeEvent.isSuccess()) {
                    SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                    if (sslHandler == null) {
                        throw new IllegalStateException("cannot find an SslHandler in the pipeline (required for application-level protocol negotiation)");
                    }
                    String protocol = sslHandler.applicationProtocol();
                    this.configurePipeline(ctx, protocol != null ? protocol : this.fallbackProtocol);
                }
            }
            catch (Throwable cause) {
                this.exceptionCaught(ctx, cause);
            }
            finally {
                if (handshakeEvent.isSuccess()) {
                    this.removeSelfIfPresent(ctx);
                }
            }
        }
        if (evt instanceof ChannelInputShutdownEvent) {
            this.fireBufferedMessages();
        }
        var1_1.fireUserEventTriggered((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.fireBufferedMessages();
        super.channelInactive((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void removeSelfIfPresent(ChannelHandlerContext ctx) {
        void var1_1;
        ChannelPipeline pipeline = ctx.pipeline();
        if (!var1_1.isRemoved()) {
            void var2_2;
            var2_2.remove((ChannelHandler)this);
        }
    }

    protected abstract void configurePipeline(ChannelHandlerContext var1, String var2) throws Exception;

    /*
     * WARNING - void declaration
     */
    protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        void var1_1;
        void var2_2;
        logger.warn("{} TLS handshake failed:", (Object)ctx.channel(), (Object)var2_2);
        var1_1.close();
    }

    /*
     * WARNING - void declaration
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        void var1_1;
        void var2_2;
        Throwable wrapped;
        if (cause instanceof DecoderException && (wrapped = cause.getCause()) instanceof SSLException) {
            try {
                void var3_4;
                this.handshakeFailure(ctx, (Throwable)var3_4);
                return;
            }
            finally {
                this.removeSelfIfPresent(ctx);
            }
        }
        logger.warn("{} Failed to select the application-level protocol:", (Object)ctx.channel(), (Object)cause);
        ctx.fireExceptionCaught((Throwable)var2_2);
        var1_1.close();
    }
}

