/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ApplicationProtocolUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.Collections;
import java.util.List;

public final class ApplicationProtocolConfig {
    public static final ApplicationProtocolConfig DISABLED = new ApplicationProtocolConfig();
    private final List<String> supportedProtocols;
    private final Protocol protocol;
    private final SelectorFailureBehavior selectorBehavior;
    private final SelectedListenerFailureBehavior selectedBehavior;

    /*
     * WARNING - void declaration
     */
    public ApplicationProtocolConfig(Protocol protocol, SelectorFailureBehavior selectorBehavior, SelectedListenerFailureBehavior selectedBehavior, Iterable<String> supportedProtocols) {
        this((Protocol)var1_1, (SelectorFailureBehavior)var2_2, (SelectedListenerFailureBehavior)var3_3, ApplicationProtocolUtil.toList(supportedProtocols));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ApplicationProtocolConfig(Protocol protocol, SelectorFailureBehavior selectorBehavior, SelectedListenerFailureBehavior selectedBehavior, String ... supportedProtocols) {
        this((Protocol)var1_1, (SelectorFailureBehavior)var2_2, (SelectedListenerFailureBehavior)var3_3, ApplicationProtocolUtil.toList(supportedProtocols));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ApplicationProtocolConfig(Protocol protocol, SelectorFailureBehavior selectorBehavior, SelectedListenerFailureBehavior selectedBehavior, List<String> supportedProtocols) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.supportedProtocols = Collections.unmodifiableList((List)ObjectUtil.checkNotNull(supportedProtocols, (String)"supportedProtocols"));
        this.protocol = (Protocol)((Object)ObjectUtil.checkNotNull((Object)((Object)protocol), (String)"protocol"));
        this.selectorBehavior = (SelectorFailureBehavior)((Object)ObjectUtil.checkNotNull((Object)var2_2, (String)"selectorBehavior"));
        this.selectedBehavior = (SelectedListenerFailureBehavior)((Object)ObjectUtil.checkNotNull((Object)var3_3, (String)"selectedBehavior"));
        if (var1_1 == Protocol.NONE) {
            throw new IllegalArgumentException("protocol (" + (Object)((Object)Protocol.NONE) + ") must not be " + (Object)((Object)Protocol.NONE) + '.');
        }
        ObjectUtil.checkNonEmpty(supportedProtocols, (String)"supportedProtocols");
    }

    private ApplicationProtocolConfig() {
        this.supportedProtocols = Collections.emptyList();
        this.protocol = Protocol.NONE;
        this.selectorBehavior = SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL;
        this.selectedBehavior = SelectedListenerFailureBehavior.ACCEPT;
    }

    public final List<String> supportedProtocols() {
        return this.supportedProtocols;
    }

    public final Protocol protocol() {
        return this.protocol;
    }

    public final SelectorFailureBehavior selectorFailureBehavior() {
        return this.selectorBehavior;
    }

    public final SelectedListenerFailureBehavior selectedListenerFailureBehavior() {
        return this.selectedBehavior;
    }

    public static enum SelectedListenerFailureBehavior {
        ACCEPT,
        FATAL_ALERT,
        CHOOSE_MY_LAST_PROTOCOL;

    }

    public static enum SelectorFailureBehavior {
        FATAL_ALERT,
        NO_ADVERTISE,
        CHOOSE_MY_LAST_PROTOCOL;

    }

    public static enum Protocol {
        NONE,
        NPN,
        ALPN,
        NPN_AND_ALPN;

    }
}

