/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SslClientHelloHandler;
import io.netty.handler.ssl.SslHandshakeTimeoutException;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public abstract class AbstractSniHandler<T>
extends SslClientHelloHandler<T> {
    protected final long handshakeTimeoutMillis;
    private ScheduledFuture<?> timeoutFuture;
    private String hostname;

    /*
     * WARNING - void declaration
     */
    private static String extractSniHostname(ByteBuf in) {
        int offset = in.readerIndex();
        int endOffset = in.writerIndex();
        if (endOffset - (offset += 34) >= 6) {
            int extensionsLength;
            int extensionsLimit;
            short sessionIdLength = in.getUnsignedByte(offset);
            int cipherSuitesLength = in.getUnsignedShort(offset += sessionIdLength + 1);
            short compressionMethodLength = in.getUnsignedByte(offset += cipherSuitesLength + 2);
            offset += compressionMethodLength + 1;
            if ((extensionsLimit = (offset += 2) + (extensionsLength = in.getUnsignedShort(offset))) <= endOffset) {
                while (extensionsLimit - offset >= 4) {
                    int extensionLength;
                    int extensionType = in.getUnsignedShort(offset);
                    offset += 2;
                    if (extensionsLimit - (offset += 2) < (extensionLength = in.getUnsignedShort(offset))) break;
                    if (extensionType == 0) {
                        void var2_2;
                        int serverNameLength;
                        if (extensionsLimit - (offset += 2) < 3) break;
                        short serverNameType = in.getUnsignedByte(offset);
                        ++offset;
                        if (serverNameType != 0 || extensionsLimit - (offset += 2) < (serverNameLength = in.getUnsignedShort(offset))) break;
                        in = in.toString(offset, (int)var2_2, CharsetUtil.US_ASCII);
                        return in.toLowerCase(Locale.US);
                    }
                    offset += extensionLength;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractSniHandler(long handshakeTimeoutMillis) {
        this(0, (long)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractSniHandler(int maxClientHelloLength, long handshakeTimeoutMillis) {
        super((int)var1_1);
        void var2_2;
        void var1_1;
        this.handshakeTimeoutMillis = ObjectUtil.checkPositiveOrZero((long)var2_2, (String)"handshakeTimeoutMillis");
    }

    public AbstractSniHandler() {
        this(0, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive()) {
            void var1_1;
            this.checkStartTimeout((ChannelHandlerContext)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        ctx.fireChannelActive();
        this.checkStartTimeout((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkStartTimeout(ChannelHandlerContext ctx) {
        void var1_1;
        if (this.handshakeTimeoutMillis <= 0L || this.timeoutFuture != null) {
            return;
        }
        this.timeoutFuture = ctx.executor().schedule(new Runnable(this, (ChannelHandlerContext)var1_1){
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ AbstractSniHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$ctx = channelHandlerContext;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                if (this.val$ctx.channel().isActive()) {
                    void var1_1;
                    SslHandshakeTimeoutException exception = new SslHandshakeTimeoutException("handshake timed out after " + this.this$0.handshakeTimeoutMillis + "ms");
                    this.val$ctx.fireUserEventTriggered((Object)new SniCompletionEvent((Throwable)var1_1));
                    this.val$ctx.close();
                }
            }
        }, this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Future<T> lookup(ChannelHandlerContext ctx, ByteBuf clientHello) throws Exception {
        void var1_1;
        void var2_2;
        this.hostname = clientHello == null ? null : AbstractSniHandler.extractSniHostname((ByteBuf)var2_2);
        return this.lookup((ChannelHandlerContext)var1_1, this.hostname);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onLookupComplete(ChannelHandlerContext ctx, Future<T> future) throws Exception {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        try {
            this.onLookupComplete(ctx, this.hostname, future);
        }
        catch (Throwable throwable) {
            void var2_2;
            void var1_1;
            AbstractSniHandler.fireSniCompletionEvent((ChannelHandlerContext)var1_1, this.hostname, var2_2);
            throw throwable;
        }
        AbstractSniHandler.fireSniCompletionEvent(ctx, this.hostname, future);
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, String var2) throws Exception;

    protected abstract void onLookupComplete(ChannelHandlerContext var1, String var2, Future<T> var3) throws Exception;

    /*
     * WARNING - void declaration
     */
    private static void fireSniCompletionEvent(ChannelHandlerContext ctx, String hostname, Future<?> future) {
        void var2_2;
        void var1_1;
        ChannelHandlerContext channelHandlerContext;
        Throwable cause = future.cause();
        if (cause == null) {
            ctx.fireUserEventTriggered((Object)new SniCompletionEvent(hostname));
            return;
        }
        channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent((String)var1_1, (Throwable)var2_2));
    }
}

