/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.pcap;

import io.netty.buffer.ByteBuf;
import io.netty.handler.pcap.PcapHeaders;
import io.netty.handler.pcap.PcapWriteHandler;
import io.netty.handler.pcap.State;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;

final class PcapWriter
implements Closeable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PcapWriter.class);
    private final PcapWriteHandler pcapWriteHandler;
    private final OutputStream outputStream;

    /*
     * WARNING - void declaration
     */
    PcapWriter(PcapWriteHandler pcapWriteHandler) throws IOException {
        this.pcapWriteHandler = pcapWriteHandler;
        this.outputStream = pcapWriteHandler.outputStream();
        if (!pcapWriteHandler.sharedOutputStream()) {
            void var1_1;
            PcapHeaders.writeGlobalHeader(var1_1.outputStream());
        }
    }

    /*
     * WARNING - void declaration
     */
    final void writePacket(ByteBuf packetHeaderBuf, ByteBuf packet) throws IOException {
        void var3_4;
        if (this.pcapWriteHandler.state() == State.CLOSED) {
            logger.debug("Pcap Write attempted on closed PcapWriter");
        }
        long timestamp = System.currentTimeMillis();
        PcapHeaders.writePacketHeader(packetHeaderBuf, (int)(timestamp / 1000L), (int)(var3_4 % 1000L * 1000L), packet.readableBytes(), packet.readableBytes());
        if (this.pcapWriteHandler.sharedOutputStream()) {
            OutputStream outputStream = this.outputStream;
            synchronized (outputStream) {
                packetHeaderBuf.readBytes(this.outputStream, packetHeaderBuf.readableBytes());
                packet.readBytes(this.outputStream, packet.readableBytes());
            }
        } else {
            void var2_3;
            void var1_1;
            packetHeaderBuf.readBytes(this.outputStream, var1_1.readableBytes());
            packet.readBytes(this.outputStream, var2_3.readableBytes());
        }
    }

    public final String toString() {
        return "PcapWriter{outputStream=" + this.outputStream + '}';
    }

    @Override
    public final void close() throws IOException {
        if (this.pcapWriteHandler.state() == State.CLOSED) {
            logger.debug("PcapWriter is already closed");
            return;
        }
        if (this.pcapWriteHandler.sharedOutputStream()) {
            OutputStream outputStream = this.outputStream;
            synchronized (outputStream) {
                this.outputStream.flush();
            }
        } else {
            this.outputStream.flush();
            this.outputStream.close();
        }
        this.pcapWriteHandler.markClosed();
        logger.debug("PcapWriter is now closed");
    }
}

