/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.pcap;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.pcap.EthernetPacket;
import io.netty.handler.pcap.IPPacket;
import io.netty.handler.pcap.PcapHeaders;
import io.netty.handler.pcap.PcapWriter;
import io.netty.handler.pcap.State;
import io.netty.handler.pcap.TCPPacket;
import io.netty.handler.pcap.UDPPacket;
import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicReference;

public final class PcapWriteHandler
extends ChannelDuplexHandler
implements Closeable {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(PcapWriteHandler.class);
    private PcapWriter pCapWriter;
    private final OutputStream outputStream;
    private final boolean captureZeroByte;
    private final boolean writePcapGlobalHeader;
    private final boolean sharedOutputStream;
    private int sendSegmentNumber = 1;
    private int receiveSegmentNumber = 1;
    private ChannelType channelType;
    private InetSocketAddress initiatorAddr;
    private InetSocketAddress handlerAddr;
    private boolean isServerPipeline;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public PcapWriteHandler(OutputStream outputStream) {
        this((OutputStream)var1_1, false, true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public PcapWriteHandler(OutputStream outputStream, boolean captureZeroByte, boolean writePcapGlobalHeader) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.outputStream = (OutputStream)ObjectUtil.checkNotNull((Object)var1_1, (String)"OutputStream");
        this.captureZeroByte = var2_2;
        this.writePcapGlobalHeader = var3_3;
        this.sharedOutputStream = false;
    }

    /*
     * WARNING - void declaration
     */
    private PcapWriteHandler(Builder builder, OutputStream outputStream) {
        void var1_1;
        void var2_2;
        this.outputStream = var2_2;
        this.captureZeroByte = builder.captureZeroByte;
        this.sharedOutputStream = builder.sharedOutputStream;
        this.writePcapGlobalHeader = builder.writePcapGlobalHeader;
        this.channelType = builder.channelType;
        this.handlerAddr = builder.handlerAddr;
        this.initiatorAddr = builder.initiatorAddr;
        this.isServerPipeline = ((Builder)var1_1).isServerPipeline;
    }

    public static void writeGlobalHeader(OutputStream outputStream) throws IOException {
        PcapHeaders.writeGlobalHeader(outputStream);
    }

    /*
     * WARNING - void declaration
     */
    private void initializeIfNecessary(ChannelHandlerContext ctx) throws Exception {
        block10: {
            DatagramChannel datagramChannel;
            if (this.state.get() != State.INIT) {
                return;
            }
            this.pCapWriter = new PcapWriter(this);
            if (this.channelType == null) {
                if (ctx.channel() instanceof SocketChannel) {
                    this.channelType = ChannelType.TCP;
                    if (ctx.channel().parent() instanceof ServerSocketChannel) {
                        this.isServerPipeline = true;
                        this.initiatorAddr = (InetSocketAddress)ctx.channel().remoteAddress();
                        this.handlerAddr = PcapWriteHandler.getLocalAddress(ctx.channel(), this.initiatorAddr);
                    } else {
                        this.isServerPipeline = false;
                        this.handlerAddr = (InetSocketAddress)ctx.channel().remoteAddress();
                        this.initiatorAddr = PcapWriteHandler.getLocalAddress(ctx.channel(), this.handlerAddr);
                    }
                } else if (ctx.channel() instanceof DatagramChannel) {
                    this.channelType = ChannelType.UDP;
                    datagramChannel = (DatagramChannel)ctx.channel();
                    if (datagramChannel.isConnected()) {
                        this.handlerAddr = (InetSocketAddress)ctx.channel().remoteAddress();
                        this.initiatorAddr = PcapWriteHandler.getLocalAddress(ctx.channel(), this.handlerAddr);
                    }
                }
            }
            if (this.channelType != ChannelType.TCP) break block10;
            this.logger.debug("Initiating Fake TCP 3-Way Handshake");
            ByteBuf tcpBuf = ctx.alloc().buffer();
            try {
                void var1_1;
                TCPPacket.writePacket(tcpBuf, null, 0, 0, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.SYN);
                PcapWriteHandler pcapWriteHandler = this;
                pcapWriteHandler.completeTCPWrite(pcapWriteHandler.initiatorAddr, this.handlerAddr, tcpBuf, ctx.alloc(), ctx);
                TCPPacket.writePacket(tcpBuf, null, 0, 1, this.handlerAddr.getPort(), this.initiatorAddr.getPort(), TCPPacket.TCPFlag.SYN, TCPPacket.TCPFlag.ACK);
                PcapWriteHandler pcapWriteHandler2 = this;
                pcapWriteHandler2.completeTCPWrite(pcapWriteHandler2.handlerAddr, this.initiatorAddr, tcpBuf, ctx.alloc(), ctx);
                TCPPacket.writePacket(tcpBuf, null, 1, 1, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.ACK);
                PcapWriteHandler pcapWriteHandler3 = this;
                pcapWriteHandler3.completeTCPWrite(pcapWriteHandler3.initiatorAddr, this.handlerAddr, tcpBuf, ctx.alloc(), (ChannelHandlerContext)var1_1);
            }
            catch (Throwable throwable) {
                datagramChannel.release();
                throw throwable;
            }
            tcpBuf.release();
            this.logger.debug("Finished Fake TCP 3-Way Handshake");
        }
        this.state.set(State.WRITING);
    }

    /*
     * WARNING - void declaration
     */
    public final void channelActive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.initializeIfNecessary(ctx);
        super.channelActive((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        if (this.state.get() == State.INIT) {
            this.initializeIfNecessary(ctx);
        }
        if (this.state.get() == State.WRITING) {
            if (this.channelType == ChannelType.TCP) {
                this.handleTCP(ctx, msg, false);
            } else if (this.channelType == ChannelType.UDP) {
                this.handleUDP(ctx, msg);
            } else {
                this.logDiscard();
            }
        }
        super.channelRead((ChannelHandlerContext)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.state.get() == State.INIT) {
            this.initializeIfNecessary(ctx);
        }
        if (this.state.get() == State.WRITING) {
            if (this.channelType == ChannelType.TCP) {
                this.handleTCP(ctx, msg, true);
            } else if (this.channelType == ChannelType.UDP) {
                this.handleUDP(ctx, msg);
            } else {
                this.logDiscard();
            }
        }
        super.write((ChannelHandlerContext)var1_1, (Object)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void handleTCP(ChannelHandlerContext ctx, Object msg, boolean isWriteOperation) {
        void var2_3;
        if (msg instanceof ByteBuf) {
            if (((ByteBuf)msg).readableBytes() == 0 && !this.captureZeroByte) {
                this.logger.debug("Discarding Zero Byte TCP Packet. isWriteOperation {}", (Object)isWriteOperation);
                return;
            }
            ByteBufAllocator byteBufAllocator = ctx.alloc();
            ByteBuf packet = ((ByteBuf)msg).duplicate();
            ByteBuf tcpBuf = byteBufAllocator.buffer();
            int bytes = packet.readableBytes();
            try {
                void var3_6;
                void var1_1;
                InetSocketAddress dstAddr;
                InetSocketAddress srcAddr;
                if (isWriteOperation) {
                    InetSocketAddress dstAddr2;
                    InetSocketAddress srcAddr2;
                    if (this.isServerPipeline) {
                        srcAddr2 = this.handlerAddr;
                        dstAddr2 = this.initiatorAddr;
                    } else {
                        srcAddr2 = this.initiatorAddr;
                        dstAddr2 = this.handlerAddr;
                    }
                    TCPPacket.writePacket(tcpBuf, packet, this.sendSegmentNumber, this.receiveSegmentNumber, srcAddr2.getPort(), dstAddr2.getPort(), TCPPacket.TCPFlag.ACK);
                    this.completeTCPWrite(srcAddr2, dstAddr2, tcpBuf, byteBufAllocator, ctx);
                    this.logTCP(true, bytes, this.sendSegmentNumber, this.receiveSegmentNumber, srcAddr2, dstAddr2, false);
                    this.sendSegmentNumber += bytes;
                    TCPPacket.writePacket(tcpBuf, null, this.receiveSegmentNumber, this.sendSegmentNumber, dstAddr2.getPort(), srcAddr2.getPort(), TCPPacket.TCPFlag.ACK);
                    this.completeTCPWrite(dstAddr2, srcAddr2, tcpBuf, byteBufAllocator, ctx);
                    this.logTCP(true, bytes, this.sendSegmentNumber, this.receiveSegmentNumber, dstAddr2, srcAddr2, true);
                }
                if (this.isServerPipeline) {
                    srcAddr = this.initiatorAddr;
                    dstAddr = this.handlerAddr;
                } else {
                    srcAddr = this.handlerAddr;
                    dstAddr = this.initiatorAddr;
                }
                TCPPacket.writePacket(tcpBuf, (ByteBuf)var2_3, this.receiveSegmentNumber, this.sendSegmentNumber, srcAddr.getPort(), dstAddr.getPort(), TCPPacket.TCPFlag.ACK);
                this.completeTCPWrite(srcAddr, dstAddr, tcpBuf, byteBufAllocator, ctx);
                this.logTCP(false, bytes, this.receiveSegmentNumber, this.sendSegmentNumber, srcAddr, dstAddr, false);
                this.receiveSegmentNumber += bytes;
                TCPPacket.writePacket(tcpBuf, null, this.sendSegmentNumber, this.receiveSegmentNumber, dstAddr.getPort(), srcAddr.getPort(), TCPPacket.TCPFlag.ACK);
                this.completeTCPWrite(dstAddr, srcAddr, tcpBuf, byteBufAllocator, (ChannelHandlerContext)var1_1);
                this.logTCP(false, bytes, this.sendSegmentNumber, this.receiveSegmentNumber, dstAddr, (InetSocketAddress)var3_6, true);
            }
            finally {
                tcpBuf.release();
            }
        } else {
            this.logger.debug("Discarding Pcap Write for TCP Object: {}", (Object)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void completeTCPWrite(InetSocketAddress srcAddr, InetSocketAddress dstAddr, ByteBuf tcpBuf, ByteBufAllocator byteBufAllocator, ChannelHandlerContext ctx) {
        ByteBuf ipBuf = byteBufAllocator.buffer();
        ByteBuf ethernetBuf = byteBufAllocator.buffer();
        ByteBuf pcap = byteBufAllocator.buffer();
        try {
            if (srcAddr.getAddress() instanceof Inet4Address && dstAddr.getAddress() instanceof Inet4Address) {
                IPPacket.writeTCPv4(ipBuf, tcpBuf, NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)srcAddr.getAddress())), NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)dstAddr.getAddress())));
                EthernetPacket.writeIPv4(ethernetBuf, ipBuf);
            } else if (srcAddr.getAddress() instanceof Inet6Address && dstAddr.getAddress() instanceof Inet6Address) {
                void var3_5;
                IPPacket.writeTCPv6(ipBuf, (ByteBuf)var3_5, srcAddr.getAddress().getAddress(), dstAddr.getAddress().getAddress());
                EthernetPacket.writeIPv6(ethernetBuf, ipBuf);
            } else {
                void var2_4;
                this.logger.error("Source and Destination IP Address versions are not same. Source Address: {}, Destination Address: {}", (Object)srcAddr.getAddress(), (Object)var2_4.getAddress());
                return;
            }
            this.pCapWriter.writePacket(pcap, ethernetBuf);
            return;
        }
        catch (IOException ex) {
            void var1_2;
            this.logger.error("Caught Exception While Writing Packet into Pcap", (Throwable)ex);
            ctx.fireExceptionCaught((Throwable)var1_2);
            return;
        }
        finally {
            ipBuf.release();
            ethernetBuf.release();
            pcap.release();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleUDP(ChannelHandlerContext ctx, Object msg) {
        block6: {
            block7: {
                block5: {
                    udpBuf = ctx.alloc().buffer();
                    try {
                        if (!(msg instanceof DatagramPacket)) ** GOTO lbl24
                        if (((ByteBuf)((DatagramPacket)msg).content()).readableBytes() != 0 || this.captureZeroByte) break block5;
                        this.logger.debug("Discarding Zero Byte UDP Packet");
                    }
                    catch (Throwable var1_2) {
                        var3_4.release();
                        throw var1_2;
                    }
                    udpBuf.release();
                    return;
                }
                datagramPacket = ((DatagramPacket)msg).duplicate();
                srcAddr = (InetSocketAddress)datagramPacket.sender();
                dstAddr = (InetSocketAddress)datagramPacket.recipient();
                if (srcAddr == null) {
                    srcAddr = PcapWriteHandler.getLocalAddress(ctx.channel(), dstAddr);
                }
                this.logger.debug("Writing UDP Data of {} Bytes, Src Addr {}, Dst Addr {}", new Object[]{((ByteBuf)datagramPacket.content()).readableBytes(), srcAddr, dstAddr});
                UDPPacket.writePacket(udpBuf, (ByteBuf)datagramPacket.content(), srcAddr.getPort(), dstAddr.getPort());
                this.completeUDPWrite(srcAddr, dstAddr, udpBuf, ctx.alloc(), ctx);
                break block6;
lbl24:
                // 1 sources

                if (!(datagramPacket instanceof ByteBuf) || ctx.channel() instanceof DatagramChannel && !((DatagramChannel)ctx.channel()).isConnected()) ** GOTO lbl38
                if (((ByteBuf)datagramPacket).readableBytes() != 0 || this.captureZeroByte) break block7;
                this.logger.debug("Discarding Zero Byte UDP Packet");
                udpBuf.release();
                return;
            }
            byteBuf = ((ByteBuf)datagramPacket).duplicate();
            this.logger.debug("Writing UDP Data of {} Bytes, Src Addr {}, Dst Addr {}", new Object[]{byteBuf.readableBytes(), this.initiatorAddr, this.handlerAddr});
            UDPPacket.writePacket(udpBuf, (ByteBuf)var2_3, this.initiatorAddr.getPort(), this.handlerAddr.getPort());
            v0 = this;
            v0.completeUDPWrite(v0.initiatorAddr, this.handlerAddr, udpBuf, ctx.alloc(), (ChannelHandlerContext)var1_1);
            break block6;
lbl38:
            // 1 sources

            this.logger.debug("Discarding Pcap Write for UDP Object: {}", (Object)var2_3);
        }
        udpBuf.release();
    }

    /*
     * WARNING - void declaration
     */
    private void completeUDPWrite(InetSocketAddress srcAddr, InetSocketAddress dstAddr, ByteBuf udpBuf, ByteBufAllocator byteBufAllocator, ChannelHandlerContext ctx) {
        ByteBuf ipBuf = byteBufAllocator.buffer();
        ByteBuf ethernetBuf = byteBufAllocator.buffer();
        ByteBuf pcap = byteBufAllocator.buffer();
        try {
            if (srcAddr.getAddress() instanceof Inet4Address && dstAddr.getAddress() instanceof Inet4Address) {
                IPPacket.writeUDPv4(ipBuf, udpBuf, NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)srcAddr.getAddress())), NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)dstAddr.getAddress())));
                EthernetPacket.writeIPv4(ethernetBuf, ipBuf);
            } else if (srcAddr.getAddress() instanceof Inet6Address && dstAddr.getAddress() instanceof Inet6Address) {
                void var3_5;
                IPPacket.writeUDPv6(ipBuf, (ByteBuf)var3_5, srcAddr.getAddress().getAddress(), dstAddr.getAddress().getAddress());
                EthernetPacket.writeIPv6(ethernetBuf, ipBuf);
            } else {
                void var2_4;
                this.logger.error("Source and Destination IP Address versions are not same. Source Address: {}, Destination Address: {}", (Object)srcAddr.getAddress(), (Object)var2_4.getAddress());
                return;
            }
            this.pCapWriter.writePacket(pcap, ethernetBuf);
            return;
        }
        catch (IOException ex) {
            void var1_2;
            this.logger.error("Caught Exception While Writing Packet into Pcap", (Throwable)ex);
            ctx.fireExceptionCaught((Throwable)var1_2);
            return;
        }
        finally {
            ipBuf.release();
            ethernetBuf.release();
            pcap.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static InetSocketAddress getLocalAddress(Channel ch, InetSocketAddress remote) {
        InetSocketAddress inetSocketAddress;
        InetSocketAddress local = (InetSocketAddress)ch.localAddress();
        if (remote != null && local.getAddress().isAnyLocalAddress()) {
            void var1_1;
            if (local.getAddress() instanceof Inet4Address && remote.getAddress() instanceof Inet6Address) {
                return new InetSocketAddress(WildcardAddressHolder.wildcard6, local.getPort());
            }
            if (local.getAddress() instanceof Inet6Address && var1_1.getAddress() instanceof Inet4Address) {
                return new InetSocketAddress(WildcardAddressHolder.wildcard4, local.getPort());
            }
        }
        return inetSocketAddress;
    }

    /*
     * WARNING - void declaration
     */
    public final void handlerRemoved(ChannelHandlerContext ctx2) throws Exception {
        void var1_1;
        block2: {
            if (this.channelType != ChannelType.TCP) break block2;
            this.logger.debug("Starting Fake TCP FIN+ACK Flow to close connection");
            ByteBufAllocator byteBufAllocator = ctx2.alloc();
            ByteBuf tcpBuf = byteBufAllocator.buffer();
            try {
                void var2_3;
                TCPPacket.writePacket(tcpBuf, null, this.sendSegmentNumber, this.receiveSegmentNumber, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.FIN, TCPPacket.TCPFlag.ACK);
                PcapWriteHandler pcapWriteHandler = this;
                pcapWriteHandler.completeTCPWrite(pcapWriteHandler.initiatorAddr, this.handlerAddr, tcpBuf, byteBufAllocator, ctx2);
                TCPPacket.writePacket(tcpBuf, null, this.receiveSegmentNumber, this.sendSegmentNumber, this.handlerAddr.getPort(), this.initiatorAddr.getPort(), TCPPacket.TCPFlag.FIN, TCPPacket.TCPFlag.ACK);
                PcapWriteHandler pcapWriteHandler2 = this;
                pcapWriteHandler2.completeTCPWrite(pcapWriteHandler2.handlerAddr, this.initiatorAddr, tcpBuf, byteBufAllocator, ctx2);
                TCPPacket.writePacket(tcpBuf, null, this.sendSegmentNumber + 1, this.receiveSegmentNumber + 1, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.ACK);
                PcapWriteHandler pcapWriteHandler3 = this;
                pcapWriteHandler3.completeTCPWrite(pcapWriteHandler3.initiatorAddr, this.handlerAddr, tcpBuf, (ByteBufAllocator)var2_3, ctx2);
            }
            catch (Throwable ctx2) {
                void var3_4;
                var3_4.release();
                throw ctx2;
            }
            tcpBuf.release();
            this.logger.debug("Finished Fake TCP FIN+ACK Flow to close connection");
        }
        this.close();
        super.handlerRemoved((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void exceptionCaught(ChannelHandlerContext ctx2, Throwable cause) throws Exception {
        void var2_3;
        void var1_1;
        block2: {
            if (this.channelType != ChannelType.TCP) break block2;
            ByteBuf tcpBuf = ctx2.alloc().buffer();
            try {
                TCPPacket.writePacket(tcpBuf, null, this.sendSegmentNumber, this.receiveSegmentNumber, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.RST, TCPPacket.TCPFlag.ACK);
                PcapWriteHandler pcapWriteHandler = this;
                pcapWriteHandler.completeTCPWrite(pcapWriteHandler.initiatorAddr, this.handlerAddr, tcpBuf, ctx2.alloc(), ctx2);
            }
            catch (Throwable ctx2) {
                void var3_4;
                var3_4.release();
                throw ctx2;
            }
            tcpBuf.release();
            this.logger.debug("Sent Fake TCP RST to close connection");
        }
        this.close();
        var1_1.fireExceptionCaught((Throwable)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private void logTCP(boolean isWriteOperation, int bytes, int sendSegmentNumber, int receiveSegmentNumber, InetSocketAddress srcAddr, InetSocketAddress dstAddr, boolean ackOnly) {
        if (this.logger.isDebugEnabled()) {
            void var3_3;
            void var1_1;
            void var2_2;
            if (ackOnly) {
                this.logger.debug("Writing TCP ACK, isWriteOperation {}, Segment Number {}, Ack Number {}, Src Addr {}, Dst Addr {}", new Object[]{isWriteOperation, sendSegmentNumber, receiveSegmentNumber, dstAddr, srcAddr});
                return;
            }
            this.logger.debug("Writing TCP Data of {} Bytes, isWriteOperation {}, Segment Number {}, Ack Number {}, Src Addr {}, Dst Addr {}", new Object[]{(int)var2_2, (boolean)var1_1, (int)var3_3, receiveSegmentNumber, srcAddr, dstAddr});
        }
    }

    final OutputStream outputStream() {
        return this.outputStream;
    }

    final boolean sharedOutputStream() {
        return this.sharedOutputStream;
    }

    public final boolean isWriting() {
        return this.state.get() == State.WRITING;
    }

    final State state() {
        return this.state.get();
    }

    public final void pause() {
        if (!this.state.compareAndSet(State.WRITING, State.PAUSED)) {
            throw new IllegalStateException("State must be 'STARTED' to pause but current state is: " + this.state);
        }
    }

    public final void resume() {
        if (!this.state.compareAndSet(State.PAUSED, State.WRITING)) {
            throw new IllegalStateException("State must be 'PAUSED' to resume but current state is: " + this.state);
        }
    }

    final void markClosed() {
        if (this.state.get() != State.CLOSED) {
            this.state.set(State.CLOSED);
        }
    }

    final PcapWriter pCapWriter() {
        return this.pCapWriter;
    }

    private void logDiscard() {
        this.logger.warn("Discarding pcap write because channel type is unknown. The channel this handler is registered on is not a SocketChannel or DatagramChannel, so the inference does not work. Please call forceTcpChannel or forceUdpChannel before registering the handler.");
    }

    public final String toString() {
        return "PcapWriteHandler{captureZeroByte=" + this.captureZeroByte + ", writePcapGlobalHeader=" + this.writePcapGlobalHeader + ", sharedOutputStream=" + this.sharedOutputStream + ", sendSegmentNumber=" + this.sendSegmentNumber + ", receiveSegmentNumber=" + this.receiveSegmentNumber + ", channelType=" + (Object)((Object)this.channelType) + ", initiatorAddr=" + this.initiatorAddr + ", handlerAddr=" + this.handlerAddr + ", isServerPipeline=" + this.isServerPipeline + ", state=" + this.state + '}';
    }

    @Override
    public final void close() throws IOException {
        if (this.state.get() == State.CLOSED) {
            this.logger.debug("PcapWriterHandler is already closed");
            return;
        }
        this.pCapWriter.close();
        this.markClosed();
        this.logger.debug("PcapWriterHandler is now closed");
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class WildcardAddressHolder {
        static final InetAddress wildcard4;
        static final InetAddress wildcard6;

        private WildcardAddressHolder() {
        }

        /*
         * WARNING - void declaration
         */
        static {
            try {
                wildcard4 = InetAddress.getByAddress(new byte[4]);
                wildcard6 = InetAddress.getByAddress(new byte[16]);
                return;
            }
            catch (UnknownHostException e) {
                void var0;
                throw new AssertionError(var0);
            }
        }
    }

    public static final class Builder {
        private boolean captureZeroByte;
        private boolean sharedOutputStream;
        private boolean writePcapGlobalHeader = true;
        private ChannelType channelType;
        private InetSocketAddress initiatorAddr;
        private InetSocketAddress handlerAddr;
        private boolean isServerPipeline;

        private Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public final Builder captureZeroByte(boolean captureZeroByte) {
            void var1_1;
            this.captureZeroByte = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder sharedOutputStream(boolean sharedOutputStream) {
            void var1_1;
            this.sharedOutputStream = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder writePcapGlobalHeader(boolean writePcapGlobalHeader) {
            void var1_1;
            this.writePcapGlobalHeader = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder forceTcpChannel(InetSocketAddress serverAddress, InetSocketAddress clientAddress, boolean isServerPipeline) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.channelType = ChannelType.TCP;
            this.handlerAddr = (InetSocketAddress)ObjectUtil.checkNotNull((Object)var1_1, (String)"serverAddress");
            this.initiatorAddr = (InetSocketAddress)ObjectUtil.checkNotNull((Object)var2_2, (String)"clientAddress");
            this.isServerPipeline = var3_3;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder forceUdpChannel(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
            void var1_1;
            void var2_2;
            this.channelType = ChannelType.UDP;
            this.handlerAddr = (InetSocketAddress)ObjectUtil.checkNotNull((Object)var2_2, (String)"remoteAddress");
            this.initiatorAddr = (InetSocketAddress)ObjectUtil.checkNotNull((Object)var1_1, (String)"localAddress");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final PcapWriteHandler build(OutputStream outputStream) {
            void var1_1;
            ObjectUtil.checkNotNull((Object)outputStream, (String)"outputStream");
            return new PcapWriteHandler(this, (OutputStream)var1_1);
        }
    }

    private static enum ChannelType {
        TCP,
        UDP;

    }
}

