/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.logging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.logging.ByteBufFormat;
import io.netty.handler.logging.LogLevel;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;

@ChannelHandler.Sharable
public class LoggingHandler
extends ChannelDuplexHandler {
    private static final LogLevel DEFAULT_LEVEL = LogLevel.DEBUG;
    protected final InternalLogger logger;
    protected final InternalLogLevel internalLevel;
    private final LogLevel level;
    private final ByteBufFormat byteBufFormat;

    public LoggingHandler() {
        this(DEFAULT_LEVEL);
    }

    /*
     * WARNING - void declaration
     */
    public LoggingHandler(ByteBufFormat format) {
        this(DEFAULT_LEVEL, (ByteBufFormat)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingHandler(LogLevel level) {
        this((LogLevel)var1_1, ByteBufFormat.HEX_DUMP);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingHandler(LogLevel level, ByteBufFormat byteBufFormat) {
        void var1_1;
        void var2_2;
        this.level = (LogLevel)((Object)ObjectUtil.checkNotNull((Object)((Object)level), (String)"level"));
        this.byteBufFormat = (ByteBufFormat)((Object)ObjectUtil.checkNotNull((Object)var2_2, (String)"byteBufFormat"));
        this.logger = InternalLoggerFactory.getInstance(((Object)((Object)this)).getClass());
        this.internalLevel = var1_1.toInternalLevel();
    }

    /*
     * WARNING - void declaration
     */
    public LoggingHandler(Class<?> clazz) {
        this((Class<?>)var1_1, DEFAULT_LEVEL);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingHandler(Class<?> clazz, LogLevel level) {
        this((Class<?>)var1_1, (LogLevel)var2_2, ByteBufFormat.HEX_DUMP);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingHandler(Class<?> clazz, LogLevel level, ByteBufFormat byteBufFormat) {
        void var2_2;
        void var1_1;
        void var3_3;
        ObjectUtil.checkNotNull(clazz, (String)"clazz");
        this.level = (LogLevel)((Object)ObjectUtil.checkNotNull((Object)((Object)level), (String)"level"));
        this.byteBufFormat = (ByteBufFormat)((Object)ObjectUtil.checkNotNull((Object)var3_3, (String)"byteBufFormat"));
        this.logger = InternalLoggerFactory.getInstance((Class)var1_1);
        this.internalLevel = var2_2.toInternalLevel();
    }

    /*
     * WARNING - void declaration
     */
    public LoggingHandler(String name) {
        this((String)var1_1, DEFAULT_LEVEL);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingHandler(String name, LogLevel level) {
        this((String)var1_1, (LogLevel)var2_2, ByteBufFormat.HEX_DUMP);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingHandler(String name, LogLevel level, ByteBufFormat byteBufFormat) {
        void var2_2;
        void var1_1;
        void var3_3;
        ObjectUtil.checkNotNull((Object)name, (String)"name");
        this.level = (LogLevel)((Object)ObjectUtil.checkNotNull((Object)((Object)level), (String)"level"));
        this.byteBufFormat = (ByteBufFormat)((Object)ObjectUtil.checkNotNull((Object)var3_3, (String)"byteBufFormat"));
        this.logger = InternalLoggerFactory.getInstance((String)var1_1);
        this.internalLevel = var2_2.toInternalLevel();
    }

    public LogLevel level() {
        return this.level;
    }

    public ByteBufFormat byteBufFormat() {
        return this.byteBufFormat;
    }

    /*
     * WARNING - void declaration
     */
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "REGISTERED"));
        }
        var1_1.fireChannelRegistered();
    }

    /*
     * WARNING - void declaration
     */
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "UNREGISTERED"));
        }
        var1_1.fireChannelUnregistered();
    }

    /*
     * WARNING - void declaration
     */
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "ACTIVE"));
        }
        var1_1.fireChannelActive();
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "INACTIVE"));
        }
        var1_1.fireChannelInactive();
    }

    /*
     * WARNING - void declaration
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        void var2_2;
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "EXCEPTION", cause), cause);
        }
        var1_1.fireExceptionCaught((Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        void var2_2;
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "USER_EVENT", evt));
        }
        var1_1.fireUserEventTriggered((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "BIND", localAddress));
        }
        var1_1.bind((SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "CONNECT", remoteAddress, localAddress));
        }
        var1_1.connect((SocketAddress)var2_2, (SocketAddress)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "DISCONNECT"));
        }
        var1_1.disconnect((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "CLOSE"));
        }
        var1_1.close((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "DEREGISTER"));
        }
        var1_1.deregister((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "READ COMPLETE"));
        }
        var1_1.fireChannelReadComplete();
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "READ", msg));
        }
        var1_1.fireChannelRead((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "WRITE", msg));
        }
        var1_1.write((Object)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "WRITABILITY CHANGED"));
        }
        var1_1.fireChannelWritabilityChanged();
    }

    /*
     * WARNING - void declaration
     */
    public void flush(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(ctx, "FLUSH"));
        }
        var1_1.flush();
    }

    /*
     * WARNING - void declaration
     */
    protected String format(ChannelHandlerContext ctx, String eventName) {
        void var2_2;
        void var1_1;
        String chStr = ctx.channel().toString();
        return new StringBuilder(chStr.length() + 1 + eventName.length()).append((String)var1_1).append(' ').append((String)var2_2).toString();
    }

    /*
     * WARNING - void declaration
     */
    protected String format(ChannelHandlerContext ctx, String eventName, Object arg) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (arg instanceof ByteBuf) {
            return this.formatByteBuf(ctx, eventName, (ByteBuf)arg);
        }
        if (arg instanceof ByteBufHolder) {
            return this.formatByteBufHolder(ctx, eventName, (ByteBufHolder)arg);
        }
        return LoggingHandler.formatSimple((ChannelHandlerContext)var1_1, (String)var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected String format(ChannelHandlerContext ctx, String eventName, Object firstArg, Object secondArg) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (secondArg == null) {
            return LoggingHandler.formatSimple(ctx, eventName, firstArg);
        }
        String chStr = ctx.channel().toString();
        String arg1Str = String.valueOf(firstArg);
        String arg2Str = secondArg.toString();
        StringBuilder buf = new StringBuilder(chStr.length() + 1 + eventName.length() + 2 + arg1Str.length() + 2 + arg2Str.length());
        buf.append((String)var1_1).append(' ').append((String)var2_2).append(": ").append((String)var3_3).append(", ").append(arg2Str);
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String formatByteBuf(ChannelHandlerContext ctx, String eventName, ByteBuf msg) {
        void var2_2;
        void var1_1;
        String chStr = ctx.channel().toString();
        int length = msg.readableBytes();
        if (length == 0) {
            StringBuilder buf = new StringBuilder(chStr.length() + 1 + eventName.length() + 4);
            buf.append(chStr).append(' ').append(eventName).append(": 0B");
            return buf.toString();
        }
        int outputLength = chStr.length() + 1 + eventName.length() + 2 + 10 + 1;
        if (this.byteBufFormat == ByteBufFormat.HEX_DUMP) {
            int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
            int hexDumpLength = 2 + rows * 80;
            outputLength += hexDumpLength;
        }
        StringBuilder buf = new StringBuilder(outputLength);
        buf.append((String)var1_1).append(' ').append((String)var2_2).append(": ").append(length).append('B');
        if (this.byteBufFormat == ByteBufFormat.HEX_DUMP) {
            void var3_3;
            buf.append(StringUtil.NEWLINE);
            ByteBufUtil.appendPrettyHexDump((StringBuilder)buf, (ByteBuf)var3_3);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String formatByteBufHolder(ChannelHandlerContext ctx, String eventName, ByteBufHolder msg) {
        void var2_2;
        void var1_1;
        String chStr = ctx.channel().toString();
        String msgStr = msg.toString();
        ByteBuf content = msg.content();
        int length = content.readableBytes();
        if (length == 0) {
            StringBuilder buf = new StringBuilder(chStr.length() + 1 + eventName.length() + 2 + msgStr.length() + 4);
            buf.append(chStr).append(' ').append(eventName).append(", ").append(msgStr).append(", 0B");
            return buf.toString();
        }
        int outputLength = chStr.length() + 1 + eventName.length() + 2 + msgStr.length() + 2 + 10 + 1;
        if (this.byteBufFormat == ByteBufFormat.HEX_DUMP) {
            int rows = length / 16 + (length % 15 == 0 ? 0 : 1) + 4;
            int hexDumpLength = 2 + rows * 80;
            outputLength += hexDumpLength;
        }
        StringBuilder buf = new StringBuilder(outputLength);
        buf.append((String)var1_1).append(' ').append((String)var2_2).append(": ").append(msgStr).append(", ").append(length).append('B');
        if (this.byteBufFormat == ByteBufFormat.HEX_DUMP) {
            void var3_3;
            buf.append(StringUtil.NEWLINE);
            ByteBufUtil.appendPrettyHexDump((StringBuilder)buf, (ByteBuf)var3_3);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String formatSimple(ChannelHandlerContext ctx, String eventName, Object msg) {
        void var2_2;
        void var1_1;
        String string;
        String chStr = ctx.channel().toString();
        String msgStr = String.valueOf(msg);
        StringBuilder stringBuilder = new StringBuilder(chStr.length() + 1 + eventName.length() + 2 + msgStr.length());
        return stringBuilder.append(string).append(' ').append((String)var1_1).append(": ").append((String)var2_2).toString();
    }
}

