/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final boolean acceptIfNotFound;
    private final List<IpFilterRule> rules;

    /*
     * WARNING - void declaration
     */
    public RuleBasedIpFilter(IpFilterRule ... rules) {
        this(true, (IpFilterRule[])var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RuleBasedIpFilter(boolean acceptIfNotFound, IpFilterRule ... rules) {
        void var2_3;
        void var1_1;
        ObjectUtil.checkNotNull((Object)rules, (String)"rules");
        this.acceptIfNotFound = var1_1;
        this.rules = new ArrayList<IpFilterRule>(rules.length);
        for (void rule : var2_3) {
            if (rule == null) continue;
            this.rules.add((IpFilterRule)rule);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean accept(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) throws Exception {
        for (IpFilterRule rule : this.rules) {
            void var3_3;
            if (!rule.matches(remoteAddress)) continue;
            return var3_3.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return this.acceptIfNotFound;
    }
}

