/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SocketUtils;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class IpSubnetFilterRule
implements IpFilterRule,
Comparable<IpSubnetFilterRule> {
    private final IpFilterRule filterRule;
    private final String ipAddress;

    /*
     * WARNING - void declaration
     */
    public IpSubnetFilterRule(String ipAddressWithCidr, IpFilterRuleType ruleType) {
        try {
            void var2_3;
            void var1_2;
            String[] ipAndCidr = ipAddressWithCidr.split("/");
            if (ipAndCidr.length != 2) {
                throw new IllegalArgumentException("ipAddressWithCidr: " + ipAddressWithCidr + " (expected: \"<ip-address>/<mask-size>\")");
            }
            this.ipAddress = ipAndCidr[0];
            int cidrPrefix = Integer.parseInt(ipAndCidr[1]);
            this.filterRule = IpSubnetFilterRule.selectFilterRule(SocketUtils.addressByName((String)this.ipAddress), (int)var1_2, (IpFilterRuleType)var2_3);
            return;
        }
        catch (UnknownHostException e) {
            void var3_5;
            throw new IllegalArgumentException("ipAddressWithCidr", (Throwable)var3_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    public IpSubnetFilterRule(String ipAddress, int cidrPrefix, IpFilterRuleType ruleType) {
        try {
            void var3_4;
            void var2_3;
            this.ipAddress = ipAddress;
            this.filterRule = IpSubnetFilterRule.selectFilterRule(SocketUtils.addressByName((String)ipAddress), (int)var2_3, (IpFilterRuleType)var3_4);
            return;
        }
        catch (UnknownHostException e) {
            void var1_2;
            throw new IllegalArgumentException("ipAddress", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public IpSubnetFilterRule(InetAddress ipAddress, int cidrPrefix, IpFilterRuleType ruleType) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.ipAddress = ipAddress.getHostAddress();
        this.filterRule = IpSubnetFilterRule.selectFilterRule((InetAddress)var1_1, (int)var2_2, (IpFilterRuleType)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static IpFilterRule selectFilterRule(InetAddress ipAddress, int cidrPrefix, IpFilterRuleType ruleType) {
        ObjectUtil.checkNotNull((Object)ipAddress, (String)"ipAddress");
        ObjectUtil.checkNotNull((Object)((Object)ruleType), (String)"ruleType");
        if (ipAddress instanceof Inet4Address) {
            return new Ip4SubnetFilterRule((Inet4Address)ipAddress, cidrPrefix, ruleType);
        }
        if (ipAddress instanceof Inet6Address) {
            void var2_2;
            void var1_1;
            InetAddress inetAddress;
            return new Ip6SubnetFilterRule((Inet6Address)inetAddress, (int)var1_1, (IpFilterRuleType)var2_2);
        }
        throw new IllegalArgumentException("Only IPv4 and IPv6 addresses are supported");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean matches(InetSocketAddress remoteAddress) {
        void var1_1;
        return this.filterRule.matches((InetSocketAddress)var1_1);
    }

    @Override
    public final IpFilterRuleType ruleType() {
        return this.filterRule.ruleType();
    }

    final String getIpAddress() {
        return this.ipAddress;
    }

    final IpFilterRule getFilterRule() {
        return this.filterRule;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(IpSubnetFilterRule ipSubnetFilterRule) {
        void var1_1;
        if (this.filterRule instanceof Ip4SubnetFilterRule) {
            return IpSubnetFilterRule.compareInt(((Ip4SubnetFilterRule)this.filterRule).networkAddress, ((Ip4SubnetFilterRule)ipSubnetFilterRule.filterRule).networkAddress);
        }
        return ((Ip6SubnetFilterRule)this.filterRule).networkAddress.compareTo(((Ip6SubnetFilterRule)var1_1.filterRule).networkAddress);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int compareTo(InetSocketAddress inetSocketAddress) {
        void var2_3;
        void var1_1;
        if (this.filterRule instanceof Ip4SubnetFilterRule) {
            Ip4SubnetFilterRule ip4SubnetFilterRule = (Ip4SubnetFilterRule)this.filterRule;
            return IpSubnetFilterRule.compareInt(ip4SubnetFilterRule.networkAddress, NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)inetSocketAddress.getAddress())) & ip4SubnetFilterRule.subnetMask);
        }
        Ip6SubnetFilterRule ip6SubnetFilterRule = (Ip6SubnetFilterRule)this.filterRule;
        return ip6SubnetFilterRule.networkAddress.compareTo(Ip6SubnetFilterRule.ipToInt((Inet6Address)var1_1.getAddress()).and(((Ip6SubnetFilterRule)var2_3).networkAddress));
    }

    /*
     * WARNING - void declaration
     */
    private static int compareInt(int x, int y) {
        void var1_1;
        int n;
        if (x < y) {
            return -1;
        }
        if (n == var1_1) {
            return 0;
        }
        return 1;
    }

    static final class Ip6SubnetFilterRule
    implements IpFilterRule {
        private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
        private final BigInteger networkAddress;
        private final BigInteger subnetMask;
        private final IpFilterRuleType ruleType;

        /*
         * WARNING - void declaration
         */
        private Ip6SubnetFilterRule(Inet6Address ipAddress, int cidrPrefix, IpFilterRuleType ruleType) {
            void var3_3;
            void var1_1;
            void var2_2;
            if (cidrPrefix < 0 || cidrPrefix > 128) {
                throw new IllegalArgumentException(String.format("IPv6 requires the subnet prefix to be in range of [0,128]. The prefix was: %d", cidrPrefix));
            }
            this.subnetMask = Ip6SubnetFilterRule.prefixToSubnetMask((int)var2_2);
            this.networkAddress = Ip6SubnetFilterRule.ipToInt((Inet6Address)var1_1).and(this.subnetMask);
            this.ruleType = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(InetSocketAddress remoteAddress) {
            InetAddress inetAddress = remoteAddress.getAddress();
            if (inetAddress instanceof Inet6Address) {
                void var1_1;
                BigInteger ipAddress = Ip6SubnetFilterRule.ipToInt((Inet6Address)inetAddress);
                return ipAddress.and(this.subnetMask).equals(this.subnetMask) || var1_1.and(this.subnetMask).equals(this.networkAddress);
            }
            return false;
        }

        @Override
        public final IpFilterRuleType ruleType() {
            return this.ruleType;
        }

        private static BigInteger ipToInt(Inet6Address ipAddress) {
            Object object;
            Object octets = ipAddress.getAddress();
            assert (((Object)octets).length == 16);
            return new BigInteger((byte[])object);
        }

        private static BigInteger prefixToSubnetMask(int cidrPrefix) {
            int n;
            return MINUS_ONE.shiftLeft(128 - n);
        }
    }

    static final class Ip4SubnetFilterRule
    implements IpFilterRule {
        private final int networkAddress;
        private final int subnetMask;
        private final IpFilterRuleType ruleType;

        /*
         * WARNING - void declaration
         */
        private Ip4SubnetFilterRule(Inet4Address ipAddress, int cidrPrefix, IpFilterRuleType ruleType) {
            void var3_3;
            void var1_1;
            void var2_2;
            if (cidrPrefix < 0 || cidrPrefix > 32) {
                throw new IllegalArgumentException(String.format("IPv4 requires the subnet prefix to be in range of [0,32]. The prefix was: %d", cidrPrefix));
            }
            this.subnetMask = Ip4SubnetFilterRule.prefixToSubnetMask((int)var2_2);
            this.networkAddress = NetUtil.ipv4AddressToInt((Inet4Address)var1_1) & this.subnetMask;
            this.ruleType = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(InetSocketAddress remoteAddress) {
            InetAddress inetAddress = remoteAddress.getAddress();
            if (inetAddress instanceof Inet4Address) {
                void var1_1;
                int n = NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)var1_1));
                return (n & this.subnetMask) == this.networkAddress;
            }
            return false;
        }

        @Override
        public final IpFilterRuleType ruleType() {
            return this.ruleType;
        }

        private static int prefixToSubnetMask(int cidrPrefix) {
            int n;
            return (int)(-1L << 32 - n);
        }
    }
}

