/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.flush;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.Future;

public class FlushConsolidationHandler
extends ChannelDuplexHandler {
    private final int explicitFlushAfterFlushes;
    private final boolean consolidateWhenNoReadInProgress;
    private final Runnable flushTask;
    private int flushPendingCount;
    private boolean readInProgress;
    private ChannelHandlerContext ctx;
    private Future<?> nextScheduledFlush;
    public static final int DEFAULT_EXPLICIT_FLUSH_AFTER_FLUSHES = 256;

    public FlushConsolidationHandler() {
        this(256, false);
    }

    /*
     * WARNING - void declaration
     */
    public FlushConsolidationHandler(int explicitFlushAfterFlushes) {
        this((int)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FlushConsolidationHandler(int explicitFlushAfterFlushes, boolean consolidateWhenNoReadInProgress) {
        void var2_2;
        void var1_1;
        this.explicitFlushAfterFlushes = ObjectUtil.checkPositive((int)var1_1, (String)"explicitFlushAfterFlushes");
        this.consolidateWhenNoReadInProgress = consolidateWhenNoReadInProgress;
        this.flushTask = var2_2 != false ? new Runnable(this){
            final /* synthetic */ FlushConsolidationHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                if (this.this$0.flushPendingCount > 0 && !this.this$0.readInProgress) {
                    FlushConsolidationHandler.access$002(this.this$0, 0);
                    FlushConsolidationHandler.access$202(this.this$0, null);
                    this.this$0.ctx.flush();
                }
            }
        } : null;
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.ctx = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void flush(ChannelHandlerContext ctx) throws Exception {
        block2: {
            void var1_1;
            block3: {
                block1: {
                    if (!this.readInProgress) break block1;
                    if (++this.flushPendingCount != this.explicitFlushAfterFlushes) break block2;
                    break block3;
                }
                if (this.consolidateWhenNoReadInProgress && ++this.flushPendingCount != this.explicitFlushAfterFlushes) {
                    this.scheduleFlush(ctx);
                    return;
                }
            }
            this.flushNow((ChannelHandlerContext)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.resetReadAndFlushIfNeeded(ctx);
        var1_1.fireChannelReadComplete();
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        this.readInProgress = true;
        var1_1.fireChannelRead((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        void var2_2;
        void var1_1;
        this.resetReadAndFlushIfNeeded(ctx);
        var1_1.fireExceptionCaught((Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        this.resetReadAndFlushIfNeeded(ctx);
        var1_1.disconnect((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        this.resetReadAndFlushIfNeeded(ctx);
        var1_1.close((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (!ctx.channel().isWritable()) {
            this.flushIfNeeded(ctx);
        }
        var1_1.fireChannelWritabilityChanged();
    }

    /*
     * WARNING - void declaration
     */
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.flushIfNeeded((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void resetReadAndFlushIfNeeded(ChannelHandlerContext ctx) {
        void var1_1;
        this.readInProgress = false;
        this.flushIfNeeded((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void flushIfNeeded(ChannelHandlerContext ctx) {
        if (this.flushPendingCount > 0) {
            void var1_1;
            this.flushNow((ChannelHandlerContext)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void flushNow(ChannelHandlerContext ctx) {
        void var1_1;
        this.cancelScheduledFlush();
        this.flushPendingCount = 0;
        var1_1.flush();
    }

    /*
     * WARNING - void declaration
     */
    private void scheduleFlush(ChannelHandlerContext ctx) {
        if (this.nextScheduledFlush == null) {
            void var1_1;
            this.nextScheduledFlush = var1_1.channel().eventLoop().submit(this.flushTask);
        }
    }

    private void cancelScheduledFlush() {
        if (this.nextScheduledFlush != null) {
            this.nextScheduledFlush.cancel(false);
            this.nextScheduledFlush = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$002(FlushConsolidationHandler x0, int x1) {
        void var1_1;
        x0.flushPendingCount = var1_1;
        return x0.flushPendingCount;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Future access$202(FlushConsolidationHandler x0, Future x1) {
        void var1_1;
        x0.nextScheduledFlush = var1_1;
        return x0.nextScheduledFlush;
    }
}

