/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.flow;

import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;

public class FlowControlHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(FlowControlHandler.class);
    private final boolean releaseMessages;
    private RecyclableArrayDeque queue;
    private ChannelConfig config;
    private boolean shouldConsume;

    public FlowControlHandler() {
        this(true);
    }

    /*
     * WARNING - void declaration
     */
    public FlowControlHandler(boolean releaseMessages) {
        void var1_1;
        this.releaseMessages = var1_1;
    }

    boolean isQueueEmpty() {
        return this.queue == null || this.queue.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void destroy() {
        if (this.queue != null) {
            if (!this.queue.isEmpty()) {
                logger.trace("Non-empty queue: {}", (Object)this.queue);
                if (this.releaseMessages) {
                    Object msg;
                    while ((msg = this.queue.poll()) != null) {
                        void var1_1;
                        ReferenceCountUtil.safeRelease((Object)var1_1);
                    }
                }
            }
            this.queue.recycle();
            this.queue = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.config = var1_1.channel().config();
    }

    /*
     * WARNING - void declaration
     */
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        if (!this.isQueueEmpty()) {
            void var1_1;
            this.dequeue((ChannelHandlerContext)var1_1, this.queue.size());
        }
        this.destroy();
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.destroy();
        var1_1.fireChannelInactive();
    }

    /*
     * WARNING - void declaration
     */
    public void read(ChannelHandlerContext ctx) throws Exception {
        if (this.dequeue(ctx, 1) == 0) {
            this.shouldConsume = true;
            ctx.read();
            return;
        }
        if (this.config.isAutoRead()) {
            void var1_1;
            var1_1.read();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_3;
        void var1_1;
        if (this.queue == null) {
            this.queue = RecyclableArrayDeque.newInstance();
        }
        this.queue.offer(msg);
        boolean minConsume = this.shouldConsume;
        this.shouldConsume = false;
        this.dequeue((ChannelHandlerContext)var1_1, (int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.isQueueEmpty()) {
            void var1_1;
            var1_1.fireChannelReadComplete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private int dequeue(ChannelHandlerContext ctx, int minConsume) {
        void var3_3;
        Object msg;
        int consumed;
        for (consumed = 0; this.queue != null && (consumed < minConsume || this.config.isAutoRead()) && (msg = this.queue.poll()) != null; ++consumed) {
            ctx.fireChannelRead(msg);
        }
        if (this.queue != null && this.queue.isEmpty()) {
            this.queue.recycle();
            this.queue = null;
            if (consumed > 0) {
                void var1_1;
                var1_1.fireChannelReadComplete();
            }
        }
        return (int)var3_3;
    }

    private static final class RecyclableArrayDeque
    extends ArrayDeque<Object> {
        private static final long serialVersionUID = 0L;
        private static final int DEFAULT_NUM_ELEMENTS = 2;
        private static final ObjectPool<RecyclableArrayDeque> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<RecyclableArrayDeque>(){

            /*
             * WARNING - void declaration
             */
            public final RecyclableArrayDeque newObject(ObjectPool.Handle<RecyclableArrayDeque> handle) {
                void var1_1;
                return new RecyclableArrayDeque(2, (ObjectPool.Handle)var1_1);
            }
        });
        private final ObjectPool.Handle<RecyclableArrayDeque> handle;

        public static RecyclableArrayDeque newInstance() {
            return (RecyclableArrayDeque)RECYCLER.get();
        }

        /*
         * WARNING - void declaration
         */
        private RecyclableArrayDeque(int numElements, ObjectPool.Handle<RecyclableArrayDeque> handle) {
            super((int)var1_1);
            void var2_2;
            void var1_1;
            this.handle = var2_2;
        }

        public final void recycle() {
            this.clear();
            this.handle.recycle((Object)this);
        }
    }
}

