/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.xml;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class XmlFrameDecoder
extends ByteToMessageDecoder {
    private final int maxFrameLength;

    /*
     * WARNING - void declaration
     */
    public XmlFrameDecoder(int maxFrameLength) {
        void var1_1;
        this.maxFrameLength = ObjectUtil.checkPositive((int)var1_1, (String)"maxFrameLength");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        boolean openingBracketFound = false;
        boolean atLeastOneXmlElementFound = false;
        boolean inCDATASection = false;
        long openBracketsCount = 0L;
        int length = 0;
        int leadingWhiteSpaceCount = 0;
        int bufferLength = in.writerIndex();
        if (bufferLength > this.maxFrameLength) {
            ByteBuf byteBuf = in;
            byteBuf.skipBytes(byteBuf.readableBytes());
            this.fail(bufferLength);
            return;
        }
        block0: for (int i = in.readerIndex(); i < bufferLength; ++i) {
            int peekFurtherAheadIndex;
            byte readByte = in.getByte(i);
            if (!openingBracketFound && Character.isWhitespace(readByte)) {
                ++leadingWhiteSpaceCount;
                continue;
            }
            if (!openingBracketFound && readByte != 60) {
                XmlFrameDecoder.fail(ctx);
                ByteBuf byteBuf = in;
                byteBuf.skipBytes(byteBuf.readableBytes());
                return;
            }
            if (!inCDATASection && readByte == 60) {
                openingBracketFound = true;
                if (i >= bufferLength - 1) continue;
                byte peekAheadByte = in.getByte(i + 1);
                if (peekAheadByte == 47) {
                    for (peekFurtherAheadIndex = i + 2; peekFurtherAheadIndex <= bufferLength - 1; ++peekFurtherAheadIndex) {
                        if (in.getByte(peekFurtherAheadIndex) != 62) continue;
                        --openBracketsCount;
                        continue block0;
                    }
                    continue;
                }
                if (XmlFrameDecoder.isValidStartCharForXmlElement(peekAheadByte)) {
                    atLeastOneXmlElementFound = true;
                    ++openBracketsCount;
                    continue;
                }
                if (peekAheadByte == 33) {
                    if (XmlFrameDecoder.isCommentBlockStart(in, i)) {
                        ++openBracketsCount;
                        continue;
                    }
                    if (!XmlFrameDecoder.isCDATABlockStart(in, i)) continue;
                    ++openBracketsCount;
                    inCDATASection = true;
                    continue;
                }
                if (peekAheadByte != 63) continue;
                ++openBracketsCount;
                continue;
            }
            if (!inCDATASection && peekFurtherAheadIndex == 47) {
                if (i >= bufferLength - 1 || in.getByte(i + 1) != 62) continue;
                --openBracketsCount;
                continue;
            }
            if (peekFurtherAheadIndex != 62) continue;
            length = i + 1;
            if (i - 1 >= 0) {
                byte peekBehindByte = in.getByte(i - 1);
                if (!inCDATASection) {
                    if (peekBehindByte == 63) {
                        --openBracketsCount;
                    } else if (peekBehindByte == 45 && i - 2 >= 0 && in.getByte(i - 2) == 45) {
                        --openBracketsCount;
                    }
                } else if (peekBehindByte == 93 && i - 2 >= 0 && in.getByte(i - 2) == 93) {
                    --openBracketsCount;
                    inCDATASection = false;
                }
            }
            if (atLeastOneXmlElementFound && openBracketsCount == 0L) break;
        }
        int readerIndex = in.readerIndex();
        int xmlElementLength = length - readerIndex;
        if (openBracketsCount == 0L && xmlElementLength > 0) {
            void var3_3;
            void var2_2;
            if (readerIndex + xmlElementLength >= bufferLength) {
                xmlElementLength = in.readableBytes();
            }
            ByteBuf frame = XmlFrameDecoder.extractFrame(in, readerIndex + leadingWhiteSpaceCount, xmlElementLength - leadingWhiteSpaceCount);
            var2_2.skipBytes(xmlElementLength);
            var3_3.add(frame);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fail(long frameLength) {
        if (frameLength > 0L) {
            void var1_1;
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + ": " + (long)var1_1 + " - discarded");
        }
        throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + " - discarding");
    }

    private static void fail(ChannelHandlerContext ctx) {
        ctx.fireExceptionCaught((Throwable)new CorruptedFrameException("frame contains content before the xml starts"));
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf extractFrame(ByteBuf buffer, int index, int length) {
        void var2_2;
        void var1_1;
        return buffer.copy((int)var1_1, (int)var2_2);
    }

    private static boolean isValidStartCharForXmlElement(byte b) {
        byte by;
        return b >= 97 && b <= 122 || b >= 65 && b <= 90 || b == 58 || by == 95;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isCommentBlockStart(ByteBuf in, int i) {
        void var1_1;
        ByteBuf byteBuf;
        return i < in.writerIndex() - 3 && in.getByte(i + 2) == 45 && byteBuf.getByte((int)(var1_1 + 3)) == 45;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isCDATABlockStart(ByteBuf in, int i) {
        void var1_1;
        ByteBuf byteBuf;
        return i < in.writerIndex() - 8 && in.getByte(i + 2) == 91 && in.getByte(i + 3) == 67 && in.getByte(i + 4) == 68 && in.getByte(i + 5) == 65 && in.getByte(i + 6) == 84 && in.getByte(i + 7) == 65 && byteBuf.getByte((int)(var1_1 + 8)) == 91;
    }
}

