/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.serialization;

import io.netty.handler.codec.serialization.ClassResolver;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;

class CompactObjectInputStream
extends ObjectInputStream {
    private final ClassResolver classResolver;

    /*
     * WARNING - void declaration
     */
    CompactObjectInputStream(InputStream in, ClassResolver classResolver) throws IOException {
        super((InputStream)var1_1);
        void var2_2;
        void var1_1;
        this.classResolver = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void readStreamHeader() throws IOException {
        int version = this.readByte() & 0xFF;
        if (version != 5) {
            void var1_1;
            throw new StreamCorruptedException("Unsupported version: " + (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        void var1_1;
        int type = this.read();
        if (type < 0) {
            throw new EOFException();
        }
        switch (type) {
            case 0: {
                return super.readClassDescriptor();
            }
            case 1: {
                Class<?> clazz;
                String className = this.readUTF();
                clazz = this.classResolver.resolve((String)((Object)clazz));
                return ObjectStreamClass.lookupAny(clazz);
            }
        }
        throw new StreamCorruptedException("Unexpected class descriptor type: " + (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        void var2_2;
        Class<?> clazz;
        try {
            clazz = this.classResolver.resolve(desc.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            void var1_1;
            clazz = super.resolveClass((ObjectStreamClass)var1_1);
        }
        return var2_2;
    }
}

