/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.protobuf;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;

public class ProtobufVarint32FrameDecoder
extends ByteToMessageDecoder {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        void var2_3;
        void var3_4;
        void var1_2;
        in.markReaderIndex();
        int preIndex = in.readerIndex();
        int length = ProtobufVarint32FrameDecoder.readRawVarint32(in);
        if (var1_2 == in.readerIndex()) {
            return;
        }
        if (length < 0) {
            throw new CorruptedFrameException("negative length: " + length);
        }
        if (in.readableBytes() < length) {
            in.resetReaderIndex();
            return;
        }
        var3_4.add(var2_3.readRetainedSlice(length));
    }

    /*
     * WARNING - void declaration
     */
    static int readRawVarint32(ByteBuf buffer) {
        void var0_1;
        void var1_2;
        void var2_3;
        void var3_4;
        if (buffer.readableBytes() < 4) {
            return ProtobufVarint32FrameDecoder.readRawVarint24(buffer);
        }
        ByteBuf byteBuf = buffer;
        int wholeOrMore = byteBuf.getIntLE(byteBuf.readerIndex());
        int firstOneOnStop = ~wholeOrMore & 0x80808080;
        if (firstOneOnStop == 0) {
            return ProtobufVarint32FrameDecoder.readRawVarint40(buffer, wholeOrMore);
        }
        int bitsToKeep = Integer.numberOfTrailingZeros(firstOneOnStop) + 1;
        buffer.skipBytes((int)(var3_4 >> 3));
        void v1 = var2_3;
        int thisVarintMask = v1 ^ v1 - true;
        int wholeWithContinuations = var1_2 & thisVarintMask;
        wholeWithContinuations = wholeWithContinuations & 0x7F007F | (wholeWithContinuations & 0x7F007F00) >> 1;
        return wholeWithContinuations & 0x3FFF | (var0_1 & 0x3FFF0000) >> 2;
    }

    /*
     * WARNING - void declaration
     */
    private static int readRawVarint40(ByteBuf buffer, int wholeOrMore) {
        void var2_2;
        void var1_1;
        ByteBuf byteBuf;
        block3: {
            block2: {
                if (buffer.readableBytes() == 4) break block2;
                ByteBuf byteBuf2 = buffer;
                byte lastByte = byteBuf2.getByte(byteBuf2.readerIndex() + 4);
                if (lastByte >= 0) break block3;
            }
            throw new CorruptedFrameException("malformed varint.");
        }
        byteBuf.skipBytes(5);
        return wholeOrMore & 0x7F | (wholeOrMore >> 8 & 0x7F) << 7 | (wholeOrMore >> 16 & 0x7F) << 14 | (var1_1 >> 24 & 0x7F) << 21 | var2_2 << 28;
    }

    /*
     * WARNING - void declaration
     */
    private static int readRawVarint24(ByteBuf buffer) {
        void var1_1;
        void var2_2;
        ByteBuf byteBuf;
        if (!buffer.isReadable()) {
            return 0;
        }
        buffer.markReaderIndex();
        byte tmp = buffer.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if (!buffer.isReadable()) {
            buffer.resetReaderIndex();
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            return result | tmp << 7;
        }
        result |= (tmp & 0x7F) << 7;
        if (!buffer.isReadable()) {
            buffer.resetReaderIndex();
            return 0;
        }
        tmp = byteBuf.readByte();
        if (tmp >= 0) {
            return result | tmp << 14;
        }
        return var2_2 | (var1_1 & 0x7F) << 14;
    }
}

