/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.marshalling;

import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import org.jboss.marshalling.ByteInput;

class LimitingByteInput
implements ByteInput {
    private static final TooBigObjectException EXCEPTION = new TooBigObjectException();
    private final ByteInput input;
    private final long limit;
    private long read;

    /*
     * WARNING - void declaration
     */
    LimitingByteInput(ByteInput input, long limit) {
        void var2_2;
        void var1_1;
        this.input = var1_1;
        this.limit = ObjectUtil.checkPositive((long)var2_2, (String)"limit");
    }

    public void close() throws IOException {
    }

    public int available() throws IOException {
        LimitingByteInput limitingByteInput = this;
        return limitingByteInput.readable(limitingByteInput.input.available());
    }

    public int read() throws IOException {
        int n = this.readable(1);
        if (n > 0) {
            int b = this.input.read();
            ++this.read;
            return n;
        }
        throw EXCEPTION;
    }

    /*
     * WARNING - void declaration
     */
    public int read(byte[] array) throws IOException {
        void var1_1;
        return this.read(array, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public int read(byte[] array, int offset, int length) throws IOException {
        int readable = this.readable(length);
        if (readable > 0) {
            void var1_2;
            void var3_4;
            void var2_3;
            int i = this.input.read(array, (int)var2_3, (int)var3_4);
            this.read += (long)i;
            return (int)var1_2;
        }
        throw EXCEPTION;
    }

    /*
     * WARNING - void declaration
     */
    public long skip(long bytes) throws IOException {
        int readable = this.readable((int)bytes);
        if (readable > 0) {
            void var1_2;
            long i = this.input.skip((long)var1_2);
            this.read += i;
            return i;
        }
        throw EXCEPTION;
    }

    private int readable(int length) {
        return (int)Math.min((long)length, this.limit - this.read);
    }

    static final class TooBigObjectException
    extends IOException {
        private static final long serialVersionUID = 1L;

        TooBigObjectException() {
        }
    }
}

