/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.marshalling.ChannelBufferByteInput;
import io.netty.handler.codec.marshalling.LimitingByteInput;
import io.netty.handler.codec.marshalling.UnmarshallerProvider;
import java.util.List;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Unmarshaller;

public class CompatibleMarshallingDecoder
extends ReplayingDecoder<Void> {
    protected final UnmarshallerProvider provider;
    protected final int maxObjectSize;
    private boolean discardingTooLongFrame;

    /*
     * WARNING - void declaration
     */
    public CompatibleMarshallingDecoder(UnmarshallerProvider provider, int maxObjectSize) {
        void var2_2;
        void var1_1;
        this.provider = var1_1;
        this.maxObjectSize = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (this.discardingTooLongFrame) {
            buffer.skipBytes(this.actualReadableBytes());
            this.checkpoint();
            return;
        }
        Unmarshaller unmarshaller = this.provider.getUnmarshaller(ctx);
        Object input = new ChannelBufferByteInput(buffer);
        if (this.maxObjectSize != Integer.MAX_VALUE) {
            input = new LimitingByteInput((ByteInput)input, this.maxObjectSize);
        }
        try {
            void var2_2;
            void var3_4;
            unmarshaller.start((ByteInput)input);
            Object obj = unmarshaller.readObject();
            unmarshaller.finish();
            var3_4.add(var2_2);
        }
        catch (LimitingByteInput.TooBigObjectException tooBigObjectException) {
            try {
                this.discardingTooLongFrame = true;
                throw new TooLongFrameException();
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
        }
        unmarshaller.close();
        return;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        switch (buffer.readableBytes()) {
            case 0: {
                return;
            }
            case 1: {
                ByteBuf byteBuf = buffer;
                if (byteBuf.getByte(byteBuf.readerIndex()) != 121) break;
                buffer.skipBytes(1);
                return;
            }
        }
        this.decode((ChannelHandlerContext)var1_1, (ByteBuf)var2_2, (List<Object>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        void var2_2;
        void var1_1;
        if (cause instanceof TooLongFrameException) {
            ctx.close();
            return;
        }
        super.exceptionCaught((ChannelHandlerContext)var1_1, (Throwable)var2_2);
    }
}

