/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.json;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class JsonObjectDecoder
extends ByteToMessageDecoder {
    private static final int ST_CORRUPTED = -1;
    private static final int ST_INIT = 0;
    private static final int ST_DECODING_NORMAL = 1;
    private static final int ST_DECODING_ARRAY_STREAM = 2;
    private int openBraces;
    private int idx;
    private int lastReaderIndex;
    private int state;
    private boolean insideString;
    private final int maxObjectLength;
    private final boolean streamArrayElements;

    public JsonObjectDecoder() {
        this(0x100000);
    }

    /*
     * WARNING - void declaration
     */
    public JsonObjectDecoder(int maxObjectLength) {
        this((int)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JsonObjectDecoder(boolean streamArrayElements) {
        this(0x100000, (boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JsonObjectDecoder(int maxObjectLength, boolean streamArrayElements) {
        void var2_2;
        void var1_1;
        this.maxObjectLength = ObjectUtil.checkPositive((int)var1_1, (String)"maxObjectLength");
        this.streamArrayElements = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        void var2_2;
        int idx;
        int wrtIdx;
        if (this.state == -1) {
            ByteBuf byteBuf = in;
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        if (this.idx > in.readerIndex() && this.lastReaderIndex != in.readerIndex()) {
            this.idx = in.readerIndex() + (this.idx - this.lastReaderIndex);
        }
        if ((wrtIdx = in.writerIndex()) > this.maxObjectLength) {
            ByteBuf byteBuf = in;
            byteBuf.skipBytes(byteBuf.readableBytes());
            this.reset();
            throw new TooLongFrameException("object length exceeds " + this.maxObjectLength + ": " + wrtIdx + " bytes discarded");
        }
        for (idx = this.idx; idx < wrtIdx; ++idx) {
            ByteBuf json;
            byte c = in.getByte(idx);
            if (this.state == 1) {
                this.decodeByte(c, in, idx);
                if (this.openBraces != 0) continue;
                ByteBuf byteBuf = in;
                json = this.extractObject(ctx, byteBuf, byteBuf.readerIndex(), idx + 1 - in.readerIndex());
                if (json != null) {
                    out.add(json);
                }
                in.readerIndex(idx + 1);
                this.reset();
                continue;
            }
            if (this.state == 2) {
                int idxNoSpaces;
                this.decodeByte(c, in, idx);
                if (this.insideString || (this.openBraces != 1 || c != 44) && (this.openBraces != 0 || c != 93)) continue;
                int i = in.readerIndex();
                while (Character.isWhitespace(in.getByte(i))) {
                    in.skipBytes(1);
                    ++i;
                }
                for (idxNoSpaces = idx - 1; idxNoSpaces >= in.readerIndex() && Character.isWhitespace(in.getByte(idxNoSpaces)); --idxNoSpaces) {
                }
                ByteBuf byteBuf = in;
                json = this.extractObject(ctx, byteBuf, byteBuf.readerIndex(), idxNoSpaces + 1 - in.readerIndex());
                if (json != null) {
                    out.add(json);
                }
                in.readerIndex(idx + 1);
                if (c != 93) continue;
                this.reset();
                continue;
            }
            if (c == 123 || c == 91) {
                this.initDecoding(c);
                if (this.state != 2) continue;
                in.skipBytes(1);
                continue;
            }
            if (Character.isWhitespace(c)) {
                in.skipBytes(1);
                continue;
            }
            this.state = -1;
            throw new CorruptedFrameException("invalid JSON received at byte position " + idx + ": " + ByteBufUtil.hexDump((ByteBuf)in));
        }
        this.idx = in.readableBytes() == 0 ? 0 : idx;
        this.lastReaderIndex = var2_2.readerIndex();
    }

    /*
     * WARNING - void declaration
     */
    protected ByteBuf extractObject(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        void var3_3;
        return buffer.retainedSlice((int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    private void decodeByte(byte c, ByteBuf in, int idx) {
        if (!(c != 123 && c != 91 || this.insideString)) {
            ++this.openBraces;
            return;
        }
        if (!(c != 125 && c != 93 || this.insideString)) {
            --this.openBraces;
            return;
        }
        if (c == 34) {
            void var1_1;
            if (!this.insideString) {
                this.insideString = true;
                return;
            }
            int backslashCount = 0;
            --idx;
            while (idx >= 0 && in.getByte(idx) == 92) {
                ++backslashCount;
                --idx;
            }
            if (var1_1 % 2 == false) {
                this.insideString = false;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initDecoding(byte openingBrace) {
        void var1_1;
        this.openBraces = 1;
        if (var1_1 == 91 && this.streamArrayElements) {
            this.state = 2;
            return;
        }
        this.state = 1;
    }

    private void reset() {
        this.insideString = false;
        this.state = 0;
        this.openBraces = 0;
    }
}

