/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.compression.ZstdConstants;
import io.netty.util.internal.ObjectUtil;

public class ZstdOptions
implements CompressionOptions {
    private final int blockSize;
    private final int compressionLevel;
    private final int maxEncodeSize;
    static final ZstdOptions DEFAULT = new ZstdOptions(ZstdConstants.DEFAULT_COMPRESSION_LEVEL, 65536, ZstdConstants.MAX_BLOCK_SIZE);

    /*
     * WARNING - void declaration
     */
    ZstdOptions(int compressionLevel, int blockSize, int maxEncodeSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!Zstd.isAvailable()) {
            throw new IllegalStateException("zstd-jni is not available", Zstd.cause());
        }
        this.compressionLevel = ObjectUtil.checkInRange((int)var1_1, (int)ZstdConstants.MIN_COMPRESSION_LEVEL, (int)ZstdConstants.MAX_COMPRESSION_LEVEL, (String)"compressionLevel");
        this.blockSize = ObjectUtil.checkPositive((int)var2_2, (String)"blockSize");
        this.maxEncodeSize = ObjectUtil.checkPositive((int)var3_3, (String)"maxEncodeSize");
    }

    public int compressionLevel() {
        return this.compressionLevel;
    }

    public int blockSize() {
        return this.blockSize;
    }

    public int maxEncodeSize() {
        return this.maxEncodeSize;
    }
}

