/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.CompressionException;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.compression.ZstdConstants;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;

public final class ZstdEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final int blockSize;
    private final int compressionLevel;
    private final int maxEncodeSize;
    private ByteBuf buffer;

    public ZstdEncoder() {
        this(ZstdConstants.DEFAULT_COMPRESSION_LEVEL, 65536, ZstdConstants.MAX_BLOCK_SIZE);
    }

    /*
     * WARNING - void declaration
     */
    public ZstdEncoder(int compressionLevel) {
        this((int)var1_1, 65536, ZstdConstants.MAX_BLOCK_SIZE);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ZstdEncoder(int blockSize, int maxEncodeSize) {
        this(ZstdConstants.DEFAULT_COMPRESSION_LEVEL, (int)var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ZstdEncoder(int compressionLevel, int blockSize, int maxEncodeSize) {
        super(true);
        void var3_4;
        void var2_3;
        void var1_1;
        try {
            Zstd.ensureAvailability();
        }
        catch (Throwable throwable) {
            void var1_2;
            throw new ExceptionInInitializerError((Throwable)var1_2);
        }
        this.compressionLevel = ObjectUtil.checkInRange((int)var1_1, (int)ZstdConstants.MIN_COMPRESSION_LEVEL, (int)ZstdConstants.MAX_COMPRESSION_LEVEL, (String)"compressionLevel");
        this.blockSize = ObjectUtil.checkPositive((int)var2_3, (String)"blockSize");
        this.maxEncodeSize = ObjectUtil.checkPositive((int)var3_4, (String)"maxEncodeSize");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) {
        void var1_1;
        if (this.buffer == null) {
            throw new IllegalStateException("not added to a pipeline,or has been removed,buffer is null");
        }
        int remaining = msg.readableBytes() + this.buffer.readableBytes();
        if (remaining < 0) {
            throw new EncoderException("too much data to allocate a buffer for compression");
        }
        long bufferSize = 0L;
        while (remaining > 0) {
            void var3_4;
            int curSize = Math.min(this.blockSize, remaining);
            remaining -= curSize;
            bufferSize += com.github.luben.zstd.Zstd.compressBound((long)((long)var3_4));
        }
        if (bufferSize > (long)this.maxEncodeSize || 0L > bufferSize) {
            throw new EncoderException("requested encode buffer size (" + bufferSize + " bytes) exceeds the maximum allowable size (" + this.maxEncodeSize + " bytes)");
        }
        return var1_1.alloc().directBuffer((int)bufferSize);
    }

    @Override
    protected final void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) {
        int length;
        if (this.buffer == null) {
            throw new IllegalStateException("not added to a pipeline,or has been removed,buffer is null");
        }
        ByteBuf buffer = this.buffer;
        while ((length = in.readableBytes()) > 0) {
            int nextChunkSize = Math.min(length, buffer.writableBytes());
            in.readBytes(buffer, nextChunkSize);
            if (buffer.isWritable()) continue;
            this.flushBufferedData(out);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void flushBufferedData(ByteBuf out) {
        void var2_2;
        void var3_3;
        void var1_1;
        int flushableBytes = this.buffer.readableBytes();
        if (flushableBytes == 0) {
            return;
        }
        int bufSize = (int)com.github.luben.zstd.Zstd.compressBound((long)flushableBytes);
        out.ensureWritable(bufSize);
        int idx = out.writerIndex();
        try {
            ByteBuffer byteBuffer = out.internalNioBuffer(idx, out.writableBytes());
            int compressedLength = com.github.luben.zstd.Zstd.compress((ByteBuffer)byteBuffer, (ByteBuffer)this.buffer.internalNioBuffer(this.buffer.readerIndex(), flushableBytes), (int)this.compressionLevel);
        }
        catch (Exception e) {
            throw new CompressionException(e);
        }
        var1_1.writerIndex((int)(var3_3 + var2_2));
        this.buffer.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void flush(ChannelHandlerContext ctx) {
        void var1_1;
        if (this.buffer != null && this.buffer.isReadable()) {
            void var2_2;
            ByteBuf buf = this.allocateBuffer(ctx, Unpooled.EMPTY_BUFFER, this.isPreferDirect());
            this.flushBufferedData(buf);
            ctx.write((Object)var2_2);
        }
        var1_1.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final void handlerAdded(ChannelHandlerContext ctx) {
        void var1_1;
        this.buffer = var1_1.alloc().directBuffer(this.blockSize);
        this.buffer.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        super.handlerRemoved((ChannelHandlerContext)var1_1);
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }
}

