/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.Zstd;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public final class ZstdDecoder
extends ByteToMessageDecoder {
    private final MutableByteBufInputStream inputStream;
    private ZstdInputStreamNoFinalizer zstdIs;
    private State currentState;

    /*
     * WARNING - void declaration
     */
    public ZstdDecoder() {
        try {
            Zstd.ensureAvailability();
        }
        catch (Throwable throwable) {
            void var1_1;
            throw new ExceptionInInitializerError((Throwable)var1_1);
        }
        this.inputStream = new MutableByteBufInputStream();
        this.currentState = State.DECOMPRESS_DATA;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            if (this.currentState == State.CORRUPTED) {
                ByteBuf byteBuf = in;
                byteBuf.skipBytes(byteBuf.readableBytes());
                return;
            }
            int compressedLength = in.readableBytes();
            this.inputStream.current = in;
            ByteBuf outBuffer = null;
            try {
                int w;
                do {
                    if (outBuffer == null) {
                        outBuffer = ctx.alloc().heapBuffer(compressedLength << 1);
                    }
                    while ((w = outBuffer.writeBytes((InputStream)this.zstdIs, outBuffer.writableBytes())) != -1 && outBuffer.isWritable()) {
                    }
                    if (!outBuffer.isReadable()) continue;
                    out.add(outBuffer);
                    outBuffer = null;
                } while (w != -1);
                if (outBuffer == null) return;
            }
            catch (Throwable throwable) {
                void var2_4;
                if (outBuffer == null) throw throwable;
                var2_4.release();
                throw throwable;
            }
            outBuffer.release();
            return;
        }
        catch (Exception e) {
            this.currentState = State.CORRUPTED;
            throw new DecompressionException(e);
        }
        finally {
            this.inputStream.current = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        super.handlerAdded((ChannelHandlerContext)var1_1);
        this.zstdIs = new ZstdInputStreamNoFinalizer((InputStream)this.inputStream);
        this.zstdIs.setContinuous(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        try {
            ZstdDecoder.closeSilently((Closeable)this.zstdIs);
        }
        catch (Throwable throwable) {
            void var1_1;
            super.handlerRemoved0((ChannelHandlerContext)var1_1);
            throw throwable;
        }
        super.handlerRemoved0(ctx);
    }

    private static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                Closeable closeable2;
                closeable2.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    private static final class MutableByteBufInputStream
    extends InputStream {
        ByteBuf current;

        private MutableByteBufInputStream() {
        }

        @Override
        public final int read() {
            if (this.current == null || !this.current.isReadable()) {
                return -1;
            }
            return this.current.readByte() & 0xFF;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int read(byte[] b, int off, int len) {
            void var3_3;
            void var2_2;
            void var1_1;
            int available = this.available();
            if (available == 0) {
                return -1;
            }
            len = Math.min(available, len);
            this.current.readBytes((byte[])var1_1, (int)var2_2, len);
            return (int)var3_3;
        }

        @Override
        public final int available() {
            if (this.current == null) {
                return 0;
            }
            return this.current.readableBytes();
        }
    }

    private static enum State {
        DECOMPRESS_DATA,
        CORRUPTED;

    }
}

