/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.util.internal.ObjectUtil;

public abstract class ZlibDecoder
extends ByteToMessageDecoder {
    protected final int maxAllocation;

    public ZlibDecoder() {
        this(0);
    }

    /*
     * WARNING - void declaration
     */
    public ZlibDecoder(int maxAllocation) {
        void var1_1;
        this.maxAllocation = ObjectUtil.checkPositiveOrZero((int)var1_1, (String)"maxAllocation");
    }

    public abstract boolean isClosed();

    /*
     * WARNING - void declaration
     */
    protected ByteBuf prepareDecompressBuffer(ChannelHandlerContext ctx, ByteBuf buffer, int preferredSize) {
        void var2_2;
        void var3_3;
        if (buffer == null) {
            void var1_1;
            if (this.maxAllocation == 0) {
                return ctx.alloc().heapBuffer(preferredSize);
            }
            return var1_1.alloc().heapBuffer(Math.min(preferredSize, this.maxAllocation), this.maxAllocation);
        }
        if (buffer.ensureWritable((int)var3_3, true) == 1) {
            this.decompressionBufferExhausted(buffer.duplicate());
            ByteBuf byteBuf = buffer;
            byteBuf.skipBytes(byteBuf.readableBytes());
            throw new DecompressionException("Decompression buffer has reached maximum size: " + buffer.maxCapacity());
        }
        return var2_2;
    }

    protected void decompressionBufferExhausted(ByteBuf buffer) {
    }
}

