/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.handler.codec.compression.JZlibDecoder;
import io.netty.handler.codec.compression.JZlibEncoder;
import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.ZlibDecoder;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public final class ZlibCodecFactory {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ZlibCodecFactory.class);
    private static final int DEFAULT_JDK_WINDOW_SIZE = 15;
    private static final int DEFAULT_JDK_MEM_LEVEL = 8;
    private static final boolean noJdkZlibDecoder = SystemPropertyUtil.getBoolean((String)"io.netty.noJdkZlibDecoder", (PlatformDependent.javaVersion() < 7 ? 1 : 0) != 0);
    private static final boolean noJdkZlibEncoder;
    private static final boolean supportsWindowSizeAndMemLevel;

    public static boolean isSupportingWindowSizeAndMemLevel() {
        return supportsWindowSizeAndMemLevel;
    }

    public static ZlibEncoder newZlibEncoder(int compressionLevel) {
        int n;
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(compressionLevel);
        }
        return new JdkZlibEncoder(n);
    }

    public static ZlibEncoder newZlibEncoder(ZlibWrapper wrapper) {
        ZlibWrapper zlibWrapper;
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(wrapper);
        }
        return new JdkZlibEncoder(zlibWrapper);
    }

    /*
     * WARNING - void declaration
     */
    public static ZlibEncoder newZlibEncoder(ZlibWrapper wrapper, int compressionLevel) {
        void var1_1;
        ZlibWrapper zlibWrapper;
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(wrapper, compressionLevel);
        }
        return new JdkZlibEncoder(zlibWrapper, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ZlibEncoder newZlibEncoder(ZlibWrapper wrapper, int compressionLevel, int windowBits, int memLevel) {
        void var1_1;
        ZlibWrapper zlibWrapper;
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder || windowBits != 15 || memLevel != 8) {
            void var3_3;
            void var2_2;
            return new JZlibEncoder(wrapper, compressionLevel, (int)var2_2, (int)var3_3);
        }
        return new JdkZlibEncoder(zlibWrapper, (int)var1_1);
    }

    public static ZlibEncoder newZlibEncoder(byte[] dictionary) {
        byte[] byArray;
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(dictionary);
        }
        return new JdkZlibEncoder(byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static ZlibEncoder newZlibEncoder(int compressionLevel, byte[] dictionary) {
        void var1_1;
        int n;
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(compressionLevel, dictionary);
        }
        return new JdkZlibEncoder(n, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ZlibEncoder newZlibEncoder(int compressionLevel, int windowBits, int memLevel, byte[] dictionary) {
        void var3_3;
        int n;
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder || windowBits != 15 || memLevel != 8) {
            void var2_2;
            void var1_1;
            return new JZlibEncoder(compressionLevel, (int)var1_1, (int)var2_2, dictionary);
        }
        return new JdkZlibEncoder(n, (byte[])var3_3);
    }

    public static ZlibDecoder newZlibDecoder() {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibDecoder) {
            return new JZlibDecoder();
        }
        return new JdkZlibDecoder(true);
    }

    public static ZlibDecoder newZlibDecoder(ZlibWrapper wrapper) {
        ZlibWrapper zlibWrapper;
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibDecoder) {
            return new JZlibDecoder(wrapper);
        }
        return new JdkZlibDecoder(zlibWrapper, true);
    }

    public static ZlibDecoder newZlibDecoder(byte[] dictionary) {
        byte[] byArray;
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibDecoder) {
            return new JZlibDecoder(dictionary);
        }
        return new JdkZlibDecoder(byArray);
    }

    private ZlibCodecFactory() {
    }

    static {
        logger.debug("-Dio.netty.noJdkZlibDecoder: {}", (Object)noJdkZlibDecoder);
        noJdkZlibEncoder = SystemPropertyUtil.getBoolean((String)"io.netty.noJdkZlibEncoder", (boolean)false);
        logger.debug("-Dio.netty.noJdkZlibEncoder: {}", (Object)noJdkZlibEncoder);
        supportsWindowSizeAndMemLevel = noJdkZlibDecoder || PlatformDependent.javaVersion() >= 7;
    }
}

