/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.CompressionException;
import io.netty.handler.codec.compression.Snappy;

public class SnappyFrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final short SNAPPY_SLICE_SIZE = Short.MAX_VALUE;
    private static final int SNAPPY_SLICE_JUMBO_SIZE = 65535;
    private static final int MIN_COMPRESSIBLE_LENGTH = 18;
    private static final byte[] STREAM_START = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89};
    private final Snappy snappy = new Snappy();
    private boolean started;
    private final int sliceSize;

    public SnappyFrameEncoder() {
        this(Short.MAX_VALUE);
    }

    public static SnappyFrameEncoder snappyEncoderWithJumboFrames() {
        return new SnappyFrameEncoder(65535);
    }

    /*
     * WARNING - void declaration
     */
    private SnappyFrameEncoder(int sliceSize) {
        void var1_1;
        this.sliceSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        void var1_2;
        void var3_4;
        void var2_3;
        int dataLength;
        if (!in.isReadable()) {
            return;
        }
        if (!this.started) {
            this.started = true;
            out.writeBytes(STREAM_START);
        }
        if ((dataLength = in.readableBytes()) > 18) {
            ByteBuf slice;
            int lengthIdx;
            while (true) {
                lengthIdx = out.writerIndex() + 1;
                if (dataLength < 18) {
                    ByteBuf byteBuf = in.readSlice(dataLength);
                    SnappyFrameEncoder.writeUnencodedChunk(byteBuf, out, dataLength);
                    return;
                }
                out.writeInt(0);
                if (dataLength <= this.sliceSize) break;
                slice = in.readSlice(this.sliceSize);
                SnappyFrameEncoder.calculateAndWriteChecksum(slice, out);
                this.snappy.encode(slice, out, this.sliceSize);
                SnappyFrameEncoder.setChunkLength(out, lengthIdx);
                dataLength -= this.sliceSize;
            }
            slice = in.readSlice(dataLength);
            SnappyFrameEncoder.calculateAndWriteChecksum(slice, out);
            this.snappy.encode(slice, out, dataLength);
            SnappyFrameEncoder.setChunkLength(out, lengthIdx);
            return;
        }
        SnappyFrameEncoder.writeUnencodedChunk((ByteBuf)var2_3, (ByteBuf)var3_4, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void writeUnencodedChunk(ByteBuf in, ByteBuf out, int dataLength) {
        void var2_2;
        ByteBuf byteBuf;
        void var1_1;
        out.writeByte(1);
        SnappyFrameEncoder.writeChunkLength(out, dataLength + 4);
        SnappyFrameEncoder.calculateAndWriteChecksum(in, out);
        var1_1.writeBytes(byteBuf, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void setChunkLength(ByteBuf out, int lengthIdx) {
        void var2_2;
        void var1_1;
        ByteBuf byteBuf;
        int chunkLength = out.writerIndex() - lengthIdx - 3;
        if (chunkLength >>> 24 != 0) {
            throw new CompressionException("compressed data too large: " + chunkLength);
        }
        byteBuf.setMediumLE((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void writeChunkLength(ByteBuf out, int chunkLength) {
        void var1_1;
        out.writeMediumLE((int)var1_1);
    }

    private static void calculateAndWriteChecksum(ByteBuf slice, ByteBuf out) {
        ByteBuf byteBuf;
        out.writeIntLE(Snappy.calculateChecksum(byteBuf));
    }
}

