/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.Crc32c;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.Arrays;

public final class Snappy {
    private static final int MAX_HT_SIZE = 16384;
    private static final int MIN_COMPRESSIBLE_BYTES = 15;
    private static final int PREAMBLE_NOT_FULL = -1;
    private static final int NOT_ENOUGH_INPUT = -1;
    private static final int LITERAL = 0;
    private static final int COPY_1_BYTE_OFFSET = 1;
    private static final int COPY_2_BYTE_OFFSET = 2;
    private static final int COPY_4_BYTE_OFFSET = 3;
    private static final FastThreadLocal<short[]> HASH_TABLE = new FastThreadLocal();
    private static final boolean DEFAULT_REUSE_HASHTABLE = SystemPropertyUtil.getBoolean((String)"io.netty.handler.codec.compression.snappy.reuseHashTable", (boolean)false);
    private final boolean reuseHashtable;
    private State state = State.READING_PREAMBLE;
    private byte tag;
    private int written;

    public Snappy() {
        this(DEFAULT_REUSE_HASHTABLE);
    }

    /*
     * WARNING - void declaration
     */
    Snappy(boolean reuseHashtable) {
        void var1_1;
        this.reuseHashtable = var1_1;
    }

    public static Snappy withHashTableReuse() {
        return new Snappy(true);
    }

    public final void reset() {
        this.state = State.READING_PREAMBLE;
        this.tag = 0;
        this.written = 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void encode(ByteBuf in, ByteBuf out, int length) {
        int n;
        int inIndex;
        int b;
        int i = 0;
        while (true) {
            if (((b = length >>> i * 7) & 0xFFFFFF80) == 0) break;
            out.writeByte(b & 0x7F | 0x80);
            ++i;
        }
        out.writeByte(b);
        int baseIndex = inIndex = in.readerIndex();
        int n2 = MathUtil.findNextPositivePowerOfTwo((int)length);
        int hashTableSize = Math.min(n2, 16384);
        short[] table = this.getHashTable(hashTableSize);
        int shift = Integer.numberOfLeadingZeros(hashTableSize) + 1;
        int nextEmit = inIndex;
        if (length - inIndex >= 15) {
            int nextHash = Snappy.hash(in, ++inIndex, shift);
            block1: while (true) {
                int insertTail;
                int candidate;
                int skip = 32;
                int nextIndex = inIndex;
                do {
                    int bytesBetweenHashLookups;
                    inIndex = nextIndex;
                    int hash = nextHash;
                    if ((nextIndex = inIndex + (bytesBetweenHashLookups = skip++ >> 5)) > length - 4) break block1;
                    bytesBetweenHashLookups = Snappy.hash(in, nextIndex, shift);
                    candidate = baseIndex + table[hash] & 0xFFFF;
                    table[hash] = (short)(inIndex - baseIndex);
                } while (in.getInt(inIndex) != in.getInt(candidate));
                Snappy.encodeLiteral(in, out, inIndex - nextEmit);
                do {
                    int base = inIndex;
                    int matched = 4 + Snappy.findMatchingLength(in, candidate + 4, inIndex + 4, length);
                    inIndex += matched;
                    int offset = base - candidate;
                    Snappy.encodeCopy(out, offset, matched);
                    ByteBuf byteBuf = in;
                    byteBuf.readerIndex(byteBuf.readerIndex() + matched);
                    insertTail = inIndex - 1;
                    n = inIndex;
                    if (inIndex >= length - 4) break block1;
                    int prevHash = Snappy.hash(in, insertTail, shift);
                    table[prevHash] = (short)(inIndex - baseIndex - 1);
                    int currentHash = Snappy.hash(in, insertTail + 1, shift);
                    candidate = baseIndex + table[currentHash];
                    table[currentHash] = (short)(inIndex - baseIndex);
                } while (in.getInt(insertTail + 1) == in.getInt(candidate));
                int n3 = Snappy.hash(in, insertTail + 2, shift);
                ++inIndex;
            }
        }
        if (n < length) {
            void var3_3;
            void var2_2;
            void var1_1;
            Snappy.encodeLiteral((ByteBuf)var1_1, (ByteBuf)var2_2, (int)(var3_3 - n));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int hash(ByteBuf in, int index, int shift) {
        void var2_2;
        void var1_1;
        return in.getInt((int)var1_1) * 506832829 >>> var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private short[] getHashTable(int hashTableSize) {
        void var1_1;
        if (this.reuseHashtable) {
            return Snappy.getHashTableFastThreadLocalArrayFill(hashTableSize);
        }
        return new short[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public static short[] getHashTableFastThreadLocalArrayFill(int hashTableSize) {
        void var1_1;
        int n;
        short[] hashTable = (short[])HASH_TABLE.get();
        if (hashTable == null || hashTable.length < hashTableSize) {
            hashTable = new short[hashTableSize];
            HASH_TABLE.set((Object)hashTable);
            return hashTable;
        }
        Arrays.fill(hashTable, 0, n, (short)0);
        return var1_1;
    }

    private static int findMatchingLength(ByteBuf in, int minIndex, int inIndex, int maxIndex) {
        int matched = 0;
        while (inIndex <= maxIndex - 4 && in.getInt(inIndex) == in.getInt(minIndex + matched)) {
            inIndex += 4;
            matched += 4;
        }
        while (inIndex < maxIndex && in.getByte(minIndex + matched) == in.getByte(inIndex)) {
            ++inIndex;
            ++matched;
        }
        return matched;
    }

    /*
     * WARNING - void declaration
     */
    private static int bitsToEncode(int value) {
        void var1_1;
        int highestOneBit = Integer.highestOneBit(value);
        int bitLength = 0;
        while ((highestOneBit >>= 1) != 0) {
            ++bitLength;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static void encodeLiteral(ByteBuf in, ByteBuf out, int length) {
        void var2_2;
        ByteBuf byteBuf;
        void var1_1;
        if (length < 61) {
            out.writeByte(length - 1 << 2);
        } else {
            int bitLength = Snappy.bitsToEncode(length - 1);
            int bytesToEncode = 1 + bitLength / 8;
            out.writeByte(bytesToEncode + 59 << 2);
            for (int i = 0; i < bytesToEncode; ++i) {
                out.writeByte(length - 1 >> (i << 3) & 0xFF);
            }
        }
        var1_1.writeBytes(byteBuf, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void encodeCopyWithOffset(ByteBuf out, int offset, int length) {
        void var1_1;
        ByteBuf byteBuf;
        void var2_2;
        if (length < 12 && offset < 2048) {
            out.writeByte(1 | length - 4 << 2 | offset >> 8 << 5);
            out.writeByte(offset & 0xFF);
            return;
        }
        out.writeByte(2 | var2_2 - true << 2);
        out.writeByte(offset & 0xFF);
        byteBuf.writeByte(var1_1 >> 8 & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    private static void encodeCopy(ByteBuf out, int offset, int length) {
        void var2_2;
        void var1_1;
        ByteBuf byteBuf;
        while (length >= 68) {
            Snappy.encodeCopyWithOffset(out, offset, 64);
            length -= 64;
        }
        if (length > 64) {
            Snappy.encodeCopyWithOffset(out, offset, 60);
            length -= 60;
        }
        Snappy.encodeCopyWithOffset(byteBuf, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void decode(ByteBuf in, ByteBuf out) {
        while (in.isReadable()) {
            block19: {
                switch (this.state) {
                    case READING_PREAMBLE: {
                        int uncompressedLength = Snappy.readPreamble(in);
                        if (uncompressedLength == -1) {
                            return;
                        }
                        if (uncompressedLength == 0) {
                            return;
                        }
                        out.ensureWritable(uncompressedLength);
                        this.state = State.READING_TAG;
                    }
                    case READING_TAG: {
                        if (!in.isReadable()) {
                            return;
                        }
                        this.tag = in.readByte();
                        switch (this.tag & 3) {
                            case 0: {
                                this.state = State.READING_LITERAL;
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                this.state = State.READING_COPY;
                            }
                        }
                        break;
                    }
                    case READING_LITERAL: {
                        int literalWritten = Snappy.decodeLiteral(this.tag, in, out);
                        if (literalWritten == -1) return;
                        this.state = State.READING_TAG;
                        this.written += literalWritten;
                        break;
                    }
                    case READING_COPY: {
                        switch (this.tag & 3) {
                            case 1: {
                                int decodeWritten = Snappy.decodeCopyWith1ByteOffset(this.tag, in, out, this.written);
                                if (decodeWritten == -1) return;
                                this.state = State.READING_TAG;
                                this.written += decodeWritten;
                                break block19;
                            }
                            case 2: {
                                int decodeWritten = Snappy.decodeCopyWith2ByteOffset(this.tag, in, out, this.written);
                                if (decodeWritten == -1) return;
                                this.state = State.READING_TAG;
                                this.written += decodeWritten;
                                break block19;
                            }
                            case 3: {
                                void var3_3;
                                int decodeWritten = Snappy.decodeCopyWith4ByteOffset(this.tag, in, out, this.written);
                                if (decodeWritten == -1) return;
                                this.state = State.READING_TAG;
                                this.written += var3_3;
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int readPreamble(ByteBuf in) {
        int length = 0;
        int byteIndex = 0;
        while (in.isReadable()) {
            void var3_3;
            short current = in.readUnsignedByte();
            length |= (current & 0x7F) << byteIndex++ * 7;
            if ((var3_3 & 0x80) == 0) {
                return length;
            }
            if (byteIndex < 4) continue;
            throw new DecompressionException("Preamble is greater than 4 bytes");
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    final int getPreamble(ByteBuf in) {
        if (this.state == State.READING_PREAMBLE) {
            int n;
            int readerIndex = in.readerIndex();
            try {
                n = Snappy.readPreamble(in);
            }
            catch (Throwable throwable) {
                void var2_2;
                void var1_1;
                var1_1.readerIndex((int)var2_2);
                throw throwable;
            }
            in.readerIndex(readerIndex);
            return n;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    static int decodeLiteral(byte tag, ByteBuf in, ByteBuf out) {
        byte by;
        void var1_1;
        void var2_2;
        byte length;
        in.markReaderIndex();
        switch (tag >> 2 & 0x3F) {
            case 60: {
                if (!in.isReadable()) {
                    return -1;
                }
                length = (byte)in.readUnsignedByte();
                break;
            }
            case 61: {
                if (in.readableBytes() < 2) {
                    return -1;
                }
                length = (byte)in.readUnsignedShortLE();
                break;
            }
            case 62: {
                if (in.readableBytes() < 3) {
                    return -1;
                }
                length = (byte)in.readUnsignedMediumLE();
                break;
            }
            case 63: {
                if (in.readableBytes() < 4) {
                    return -1;
                }
                length = (byte)in.readIntLE();
                break;
            }
            default: {
                length = (byte)(length >> 2 & 0x3F);
            }
        }
        length = (byte)(length + 1);
        if (in.readableBytes() < length) {
            in.resetReaderIndex();
            return -1;
        }
        var2_2.writeBytes((ByteBuf)var1_1, (int)length);
        return by;
    }

    /*
     * WARNING - void declaration
     */
    private static int decodeCopyWith1ByteOffset(byte tag, ByteBuf in, ByteBuf out, int writtenSoFar) {
        void var2_3;
        void var3_4;
        if (!in.isReadable()) {
            return -1;
        }
        int initialIndex = out.writerIndex();
        int length = 4 + ((tag & 0x1C) >> 2);
        int n = (tag & 0xE0) << 8 >> 5 | in.readUnsignedByte();
        byte offset = (byte)n;
        Snappy.validateOffset(n, (int)var3_4);
        out.markReaderIndex();
        if (offset < length) {
            for (int copies = length / offset; copies > 0; --copies) {
                out.readerIndex(initialIndex - offset);
                ByteBuf byteBuf = out;
                byteBuf.readBytes(byteBuf, (int)offset);
            }
            if (length % offset != 0) {
                out.readerIndex(initialIndex - offset);
                ByteBuf byteBuf = out;
                byteBuf.readBytes(byteBuf, length % offset);
            }
        } else {
            byte by;
            out.readerIndex(initialIndex - by);
            ByteBuf byteBuf = out;
            byteBuf.readBytes(byteBuf, length);
        }
        var2_3.resetReaderIndex();
        return length;
    }

    /*
     * WARNING - void declaration
     */
    private static int decodeCopyWith2ByteOffset(byte tag, ByteBuf in, ByteBuf out, int writtenSoFar) {
        byte by;
        void var2_3;
        if (in.readableBytes() < 2) {
            return -1;
        }
        int initialIndex = out.writerIndex();
        byte length = (byte)(1 + (tag >> 2 & 0x3F));
        int offset = in.readUnsignedShortLE();
        Snappy.validateOffset(offset, writtenSoFar);
        out.markReaderIndex();
        if (offset < length) {
            for (int copies = length / offset; copies > 0; --copies) {
                out.readerIndex(initialIndex - offset);
                ByteBuf byteBuf = out;
                byteBuf.readBytes(byteBuf, offset);
            }
            if (length % offset != 0) {
                out.readerIndex(initialIndex - offset);
                ByteBuf byteBuf = out;
                byteBuf.readBytes(byteBuf, length % offset);
            }
        } else {
            void var1_2;
            out.readerIndex(initialIndex - var1_2);
            ByteBuf byteBuf = out;
            byteBuf.readBytes(byteBuf, (int)length);
        }
        var2_3.resetReaderIndex();
        return by;
    }

    /*
     * WARNING - void declaration
     */
    private static int decodeCopyWith4ByteOffset(byte tag, ByteBuf in, ByteBuf out, int writtenSoFar) {
        byte by;
        void var2_3;
        if (in.readableBytes() < 4) {
            return -1;
        }
        int initialIndex = out.writerIndex();
        byte length = (byte)(1 + (tag >> 2 & 0x3F));
        int offset = in.readIntLE();
        Snappy.validateOffset(offset, writtenSoFar);
        out.markReaderIndex();
        if (offset < length) {
            for (int copies = length / offset; copies > 0; --copies) {
                out.readerIndex(initialIndex - offset);
                ByteBuf byteBuf = out;
                byteBuf.readBytes(byteBuf, offset);
            }
            if (length % offset != 0) {
                out.readerIndex(initialIndex - offset);
                ByteBuf byteBuf = out;
                byteBuf.readBytes(byteBuf, length % offset);
            }
        } else {
            void var1_2;
            out.readerIndex(initialIndex - var1_2);
            ByteBuf byteBuf = out;
            byteBuf.readBytes(byteBuf, (int)length);
        }
        var2_3.resetReaderIndex();
        return by;
    }

    /*
     * WARNING - void declaration
     */
    private static void validateOffset(int offset, int chunkSizeSoFar) {
        void var1_1;
        int n;
        if (offset == 0) {
            throw new DecompressionException("Offset is less than minimum permissible value");
        }
        if (offset < 0) {
            throw new DecompressionException("Offset is greater than maximum value supported by this implementation");
        }
        if (n > var1_1) {
            throw new DecompressionException("Offset exceeds size of chunk");
        }
    }

    static int calculateChecksum(ByteBuf data) {
        ByteBuf byteBuf;
        ByteBuf byteBuf2 = data;
        return Snappy.calculateChecksum(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    /*
     * WARNING - void declaration
     */
    static int calculateChecksum(ByteBuf data, int offset, int length) {
        Crc32c crc32 = new Crc32c();
        try {
            void var2_4;
            void var1_3;
            ByteBuf byteBuf;
            crc32.update(byteBuf, (int)var1_3, (int)var2_4);
            int n = Snappy.maskChecksum(crc32.getValue());
            crc32.reset();
            return n;
        }
        catch (Throwable throwable) {
            void var3_5;
            var3_5.reset();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void validateChecksum(int expectedChecksum, ByteBuf data) {
        void var1_1;
        ByteBuf byteBuf = data;
        Snappy.validateChecksum(expectedChecksum, byteBuf, byteBuf.readerIndex(), var1_1.readableBytes());
    }

    /*
     * WARNING - void declaration
     */
    static void validateChecksum(int expectedChecksum, ByteBuf data, int offset, int length) {
        void var3_4;
        void var2_3;
        int actualChecksum = Snappy.calculateChecksum(data, (int)var2_3, (int)var3_4);
        if (actualChecksum != expectedChecksum) {
            int n;
            void var1_2;
            throw new DecompressionException("mismatching checksum: " + Integer.toHexString((int)var1_2) + " (expected: " + Integer.toHexString(n) + ')');
        }
    }

    static int maskChecksum(long checksum) {
        long l;
        return (int)((checksum >> 15 | l << 17) + -1568478504L);
    }

    private static enum State {
        READING_PREAMBLE,
        READING_TAG,
        READING_LITERAL,
        READING_COPY;

    }
}

