/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkEncoder;
import com.ning.compress.lzf.LZFChunk;
import com.ning.compress.lzf.LZFEncoder;
import com.ning.compress.lzf.util.ChunkEncoderFactory;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.internal.PlatformDependent;

public class LzfEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final int MIN_BLOCK_TO_COMPRESS = 16;
    private static final boolean DEFAULT_SAFE = !PlatformDependent.hasUnsafe();
    private final int compressThreshold;
    private final ChunkEncoder encoder;
    private final BufferRecycler recycler;

    public LzfEncoder() {
        this(DEFAULT_SAFE);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public LzfEncoder(boolean safeInstance) {
        this((boolean)var1_1, 65535);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public LzfEncoder(boolean safeInstance, int totalLength) {
        this((boolean)var1_1, (int)var2_2, 16);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LzfEncoder(int totalLength) {
        this(DEFAULT_SAFE, (int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LzfEncoder(int totalLength, int compressThreshold) {
        this(DEFAULT_SAFE, (int)var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public LzfEncoder(boolean safeInstance, int totalLength, int compressThreshold) {
        super(false);
        void var2_2;
        void var1_1;
        void var3_3;
        if (totalLength < 16 || totalLength > 65535) {
            throw new IllegalArgumentException("totalLength: " + totalLength + " (expected: 16" + '-' + 65535 + ')');
        }
        if (compressThreshold < 16) {
            throw new IllegalArgumentException("compressThreshold:" + compressThreshold + " expected >=16");
        }
        this.compressThreshold = var3_3;
        this.encoder = var1_1 != false ? ChunkEncoderFactory.safeNonAllocatingInstance((int)totalLength) : ChunkEncoderFactory.optimalNonAllocatingInstance((int)var2_2);
        this.recycler = BufferRecycler.instance();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        void var2_3;
        void var1_2;
        int outputLength;
        int outputPtr;
        byte[] output22;
        int inputPtr;
        byte[] input;
        int length = in.readableBytes();
        int idx = in.readerIndex();
        if (in.hasArray()) {
            input = in.array();
            inputPtr = in.arrayOffset() + idx;
        } else {
            input = this.recycler.allocInputBuffer(length);
            in.getBytes(inputPtr, input, 0, length);
            inputPtr = 0;
        }
        int maxOutputLength = LZFEncoder.estimateMaxWorkspaceSize((int)length) + 1;
        out.ensureWritable(maxOutputLength);
        if (out.hasArray()) {
            output22 = out.array();
            outputPtr = out.arrayOffset() + out.writerIndex();
        } else {
            void output22;
            output22 = new byte[output22];
            outputPtr = 0;
        }
        outputLength = length >= this.compressThreshold ? this.encodeCompress(input, inputPtr, length, output22, outputPtr) : LzfEncoder.encodeNonCompress(input, outputLength, length, output22, outputPtr);
        if (out.hasArray()) {
            ByteBuf byteBuf = out;
            byteBuf.writerIndex(byteBuf.writerIndex() + outputLength);
        } else {
            void var3_4;
            var3_4.writeBytes(output22, 0, outputLength);
        }
        in.skipBytes((int)var1_2);
        if (!var2_3.hasArray()) {
            this.recycler.releaseInputBuffer(input);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int encodeCompress(byte[] input, int inputPtr, int length, byte[] output, int outputPtr) {
        void var3_3;
        void var2_2;
        void var1_1;
        return LZFEncoder.appendEncoded((ChunkEncoder)this.encoder, (byte[])var1_1, (int)var2_2, (int)var3_3, (byte[])output, (int)outputPtr) - outputPtr;
    }

    private static int lzfEncodeNonCompress(byte[] input, int inputPtr, int length, byte[] output, int outputPtr) {
        int left = length;
        int chunkLen = Math.min(65535, left);
        outputPtr = LZFChunk.appendNonCompressed((byte[])input, (int)inputPtr, (int)chunkLen, (byte[])output, (int)outputPtr);
        if ((left -= chunkLen) <= 0) {
            return outputPtr;
        }
        inputPtr += chunkLen;
        do {
            chunkLen = Math.min(left, 65535);
            outputPtr = LZFChunk.appendNonCompressed((byte[])input, (int)inputPtr, (int)chunkLen, (byte[])output, (int)outputPtr);
            inputPtr += chunkLen;
        } while ((left -= chunkLen) > 0);
        return outputPtr;
    }

    /*
     * WARNING - void declaration
     */
    private static int encodeNonCompress(byte[] input, int inputPtr, int length, byte[] output, int outputPtr) {
        void var3_3;
        void var2_2;
        void var1_1;
        return LzfEncoder.lzfEncodeNonCompress(input, (int)var1_1, (int)var2_2, (byte[])var3_3, outputPtr) - outputPtr;
    }

    /*
     * WARNING - void declaration
     */
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.encoder.close();
        super.handlerRemoved((ChannelHandlerContext)var1_1);
    }
}

