/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkDecoder;
import com.ning.compress.lzf.util.ChunkDecoderFactory;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.DecompressionException;
import java.util.List;

public class LzfDecoder
extends ByteToMessageDecoder {
    private State currentState = State.INIT_BLOCK;
    private static final short MAGIC_NUMBER = 23126;
    private ChunkDecoder decoder;
    private BufferRecycler recycler;
    private int chunkLength;
    private int originalLength;
    private boolean isCompressed;

    public LzfDecoder() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    public LzfDecoder(boolean safeInstance) {
        void var1_1;
        this.decoder = var1_1 != false ? ChunkDecoderFactory.safeInstance() : ChunkDecoderFactory.optimalInstance();
        this.recycler = BufferRecycler.instance();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in2, List<Object> out) throws Exception {
        block27: {
            try {
                switch (this.currentState) {
                    case INIT_BLOCK: {
                        if (in2.readableBytes() < 5) break;
                        int n = in2.readUnsignedShort();
                        if (n != 23126) {
                            throw new DecompressionException("unexpected block identifier");
                        }
                        byte type = in2.readByte();
                        switch (type) {
                            case 0: {
                                this.isCompressed = false;
                                this.currentState = State.DECOMPRESS_DATA;
                                break;
                            }
                            case 1: {
                                this.isCompressed = true;
                                this.currentState = State.INIT_ORIGINAL_LENGTH;
                                break;
                            }
                            default: {
                                throw new DecompressionException(String.format("unknown type of chunk: %d (expected: %d or %d)", type, 0, 1));
                            }
                        }
                        this.chunkLength = in2.readUnsignedShort();
                        if (this.chunkLength > 65535) {
                            throw new DecompressionException(String.format("chunk length exceeds maximum: %d (expected: =< %d)", this.chunkLength, 65535));
                        }
                        if (type != 1) break;
                    }
                    case INIT_ORIGINAL_LENGTH: {
                        if (in2.readableBytes() < 2) break;
                        this.originalLength = in2.readUnsignedShort();
                        if (this.originalLength > 65535) {
                            throw new DecompressionException(String.format("original length exceeds maximum: %d (expected: =< %d)", this.chunkLength, 65535));
                        }
                        this.currentState = State.DECOMPRESS_DATA;
                    }
                    case DECOMPRESS_DATA: {
                        int chunkLength = this.chunkLength;
                        if (in2.readableBytes() < chunkLength) break;
                        int originalLength = this.originalLength;
                        if (this.isCompressed) {
                            int outPos;
                            byte[] outputArray;
                            int inPos;
                            byte[] inputArray;
                            int idx = in2.readerIndex();
                            if (in2.hasArray()) {
                                inputArray = in2.array();
                                inPos = in2.arrayOffset() + idx;
                            } else {
                                inputArray = this.recycler.allocInputBuffer(chunkLength);
                                in2.getBytes(inPos, inputArray, 0, chunkLength);
                                inPos = 0;
                            }
                            int n = originalLength;
                            ByteBuf uncompressed = ctx.alloc().heapBuffer(n, n);
                            if (uncompressed.hasArray()) {
                                outputArray = uncompressed.array();
                                outPos = uncompressed.arrayOffset() + uncompressed.writerIndex();
                            } else {
                                outputArray = new byte[originalLength];
                                outPos = 0;
                            }
                            try {
                                int n2 = outPos;
                                this.decoder.decodeChunk(inputArray, inPos, outputArray, n2, n2 + originalLength);
                                if (uncompressed.hasArray()) {
                                    ByteBuf byteBuf = uncompressed;
                                    byteBuf.writerIndex(byteBuf.writerIndex() + originalLength);
                                } else {
                                    uncompressed.writeBytes(outputArray);
                                }
                                out.add(uncompressed);
                                in2.skipBytes(chunkLength);
                            }
                            catch (Throwable in2) {
                                void var1_1;
                                var1_1.release();
                                throw in2;
                            }
                            if (!in2.hasArray()) {
                                this.recycler.releaseInputBuffer(inputArray);
                            }
                        } else if (chunkLength > 0) {
                            ByteBuf in2;
                            void var3_4;
                            var3_4.add(in2.readRetainedSlice(chunkLength));
                        }
                        this.currentState = State.INIT_BLOCK;
                        break block27;
                    }
                    case CORRUPTED: {
                        void var2_2;
                        void v3 = var2_2;
                        v3.skipBytes(v3.readableBytes());
                        break block27;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return;
            }
            catch (Exception e) {
                this.currentState = State.CORRUPTED;
                this.decoder = null;
                this.recycler = null;
                throw e;
            }
        }
    }

    private static enum State {
        INIT_BLOCK,
        INIT_ORIGINAL_LENGTH,
        DECOMPRESS_DATA,
        CORRUPTED;

    }
}

