/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.CompressionUtil;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;

public final class Lz4XXHash32
extends ByteBufChecksum {
    private static final XXHash32 XXHASH32 = XXHashFactory.fastestInstance().hash32();
    private final int seed;
    private boolean used;
    private int value;

    /*
     * WARNING - void declaration
     */
    public Lz4XXHash32(int seed) {
        void var1_1;
        this.seed = var1_1;
    }

    @Override
    public final void update(int b) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void update(byte[] b, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.used) {
            throw new IllegalStateException();
        }
        this.value = XXHASH32.hash((byte[])var1_1, (int)var2_2, (int)var3_3, this.seed);
        this.used = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void update(ByteBuf b, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.used) {
            throw new IllegalStateException();
        }
        this.value = b.hasArray() ? XXHASH32.hash(b.array(), b.arrayOffset() + off, len, this.seed) : XXHASH32.hash(CompressionUtil.safeNioBuffer((ByteBuf)var1_1, (int)var2_2, (int)var3_3), this.seed);
        this.used = true;
    }

    @Override
    public final long getValue() {
        if (!this.used) {
            throw new IllegalStateException();
        }
        return (long)this.value & 0xFFFFFFFL;
    }

    @Override
    public final void reset() {
        this.used = false;
    }
}

