/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.CompressionException;
import io.netty.handler.codec.compression.EncoderUtil;
import io.netty.handler.codec.compression.Lz4XXHash32;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;

public class Lz4FrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    static final int DEFAULT_MAX_ENCODE_SIZE = Integer.MAX_VALUE;
    private final int blockSize;
    private final LZ4Compressor compressor;
    private final ByteBufChecksum checksum;
    private final int compressionLevel;
    private ByteBuf buffer;
    private final int maxEncodeSize;
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;

    public Lz4FrameEncoder() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    public Lz4FrameEncoder(boolean highCompressor) {
        this(LZ4Factory.fastestInstance(), (boolean)var1_1, 65536, new Lz4XXHash32(-1756908916));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Lz4FrameEncoder(LZ4Factory factory, boolean highCompressor, int blockSize, Checksum checksum) {
        this((LZ4Factory)var1_1, (boolean)var2_2, (int)var3_3, checksum, Integer.MAX_VALUE);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Lz4FrameEncoder(LZ4Factory factory, boolean highCompressor, int blockSize, Checksum checksum, int maxEncodeSize) {
        void var3_3;
        void var1_1;
        void var2_2;
        ObjectUtil.checkNotNull((Object)factory, (String)"factory");
        ObjectUtil.checkNotNull((Object)checksum, (String)"checksum");
        this.compressor = var2_2 != false ? factory.highCompressor() : var1_1.fastCompressor();
        this.checksum = ByteBufChecksum.wrapChecksum(checksum);
        this.compressionLevel = Lz4FrameEncoder.compressionLevel(blockSize);
        this.blockSize = var3_3;
        this.maxEncodeSize = ObjectUtil.checkPositive((int)maxEncodeSize, (String)"maxEncodeSize");
        this.finished = false;
    }

    private static int compressionLevel(int blockSize) {
        int n;
        if (blockSize < 64 || blockSize > 0x2000000) {
            throw new IllegalArgumentException(String.format("blockSize: %d (expected: %d-%d)", blockSize, 64, 0x2000000));
        }
        int compressionLevel = 32 - Integer.numberOfLeadingZeros(blockSize - 1);
        n = Math.max(0, n - 10);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.allocateBuffer((ChannelHandlerContext)var1_1, (ByteBuf)var2_2, (boolean)var3_3, true);
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect, boolean allowEmptyReturn) {
        void var1_1;
        void var3_4;
        int targetBufSize = 0;
        int remaining = msg.readableBytes() + this.buffer.readableBytes();
        if (remaining < 0) {
            throw new EncoderException("too much data to allocate a buffer for compression");
        }
        while (remaining > 0) {
            int curSize = Math.min(this.blockSize, remaining);
            remaining -= curSize;
            targetBufSize += this.compressor.maxCompressedLength(curSize) + 21;
        }
        if (targetBufSize > this.maxEncodeSize || targetBufSize < 0) {
            throw new EncoderException(String.format("requested encode buffer size (%d bytes) exceeds the maximum allowable size (%d bytes)", targetBufSize, this.maxEncodeSize));
        }
        if (allowEmptyReturn && targetBufSize < this.blockSize) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (var3_4 != false) {
            int n = targetBufSize;
            return ctx.alloc().ioBuffer(n, n);
        }
        int n = targetBufSize;
        return var1_1.alloc().heapBuffer(n, n);
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        int length;
        if (this.finished) {
            if (!out.isWritable(in.readableBytes())) {
                throw new IllegalStateException("encode finished and not enough space to write remaining data");
            }
            out.writeBytes(in);
            return;
        }
        ByteBuf buffer = this.buffer;
        while ((length = in.readableBytes()) > 0) {
            int nextChunkSize = Math.min(length, buffer.writableBytes());
            in.readBytes(buffer, nextChunkSize);
            if (buffer.isWritable()) continue;
            this.flushBufferedData(out);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void flushBufferedData(ByteBuf out) {
        void var1_1;
        void var3_3;
        void var2_2;
        int blockType;
        int compressedLength;
        int flushableBytes = this.buffer.readableBytes();
        if (flushableBytes == 0) {
            return;
        }
        this.checksum.reset();
        this.checksum.update(this.buffer, this.buffer.readerIndex(), flushableBytes);
        int check = (int)this.checksum.getValue();
        int bufSize = this.compressor.maxCompressedLength(flushableBytes) + 21;
        out.ensureWritable(bufSize);
        int idx = out.writerIndex();
        try {
            ByteBuffer outNioBuffer = out.internalNioBuffer(idx + 21, out.writableBytes() - 21);
            int pos = outNioBuffer.position();
            this.compressor.compress(this.buffer.internalNioBuffer(this.buffer.readerIndex(), flushableBytes), outNioBuffer);
            compressedLength = outNioBuffer.position() - pos;
        }
        catch (LZ4Exception e) {
            throw new CompressionException(e);
        }
        if (compressedLength >= flushableBytes) {
            blockType = 16;
            compressedLength = flushableBytes;
            out.setBytes(idx + 21, this.buffer, this.buffer.readerIndex(), flushableBytes);
        } else {
            blockType = 32;
        }
        out.setLong(idx, 5501767354678207339L);
        out.setByte(idx + 8, (int)((byte)(blockType | this.compressionLevel)));
        out.setIntLE(idx + 9, compressedLength);
        out.setIntLE(idx + 13, (int)var2_2);
        out.setIntLE(idx + 17, (int)var3_3);
        var1_1.writerIndex(idx + 21 + compressedLength);
        this.buffer.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void flush(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.buffer != null && this.buffer.isReadable()) {
            void var2_2;
            ByteBuf buf = this.allocateBuffer(ctx, Unpooled.EMPTY_BUFFER, this.isPreferDirect(), false);
            this.flushBufferedData(buf);
            ctx.write((Object)var2_2);
        }
        var1_1.flush();
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture finishEncode(ChannelHandlerContext ctx, ChannelPromise promise) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (this.finished) {
            promise.setSuccess();
            return promise;
        }
        this.finished = true;
        ByteBuf footer = ctx.alloc().heapBuffer(this.compressor.maxCompressedLength(this.buffer.readableBytes()) + 21);
        this.flushBufferedData(footer);
        footer.ensureWritable(21);
        int idx = footer.writerIndex();
        footer.setLong(idx, 5501767354678207339L);
        footer.setByte(idx + 8, (int)((byte)(0x10 | this.compressionLevel)));
        footer.setInt(idx + 9, 0);
        footer.setInt(idx + 13, 0);
        footer.setInt(idx + 17, 0);
        footer.writerIndex(idx + 21);
        return var1_1.writeAndFlush((Object)var3_3, (ChannelPromise)var2_2);
    }

    public boolean isClosed() {
        return this.finished;
    }

    public ChannelFuture close() {
        Lz4FrameEncoder lz4FrameEncoder = this;
        return lz4FrameEncoder.close(lz4FrameEncoder.ctx().newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture close(ChannelPromise promise) {
        void var1_1;
        void var3_3;
        ChannelHandlerContext ctx = this.ctx();
        EventExecutor executor = ctx.executor();
        if (executor.inEventLoop()) {
            void var2_2;
            return this.finishEncode((ChannelHandlerContext)var2_2, promise);
        }
        var3_3.execute(new Runnable(this, promise){
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ Lz4FrameEncoder this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$promise = channelPromise;
            }

            @Override
            public void run() {
                ChannelFuture channelFuture = Lz4FrameEncoder.access$100(this.this$0, this.this$0.ctx(), this.val$promise);
                PromiseNotifier.cascade((Future)channelFuture, (Promise)this.val$promise);
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var3_3;
        void var1_1;
        ChannelHandlerContext channelHandlerContext = ctx;
        ChannelFuture f = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        EncoderUtil.closeAfterFinishEncode((ChannelHandlerContext)var1_1, (ChannelFuture)var3_3, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelHandlerContext ctx() {
        void var1_1;
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) {
        void var1_1;
        this.ctx = var1_1;
        this.buffer = Unpooled.wrappedBuffer((byte[])new byte[this.blockSize]);
        this.buffer.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        super.handlerRemoved((ChannelHandlerContext)var1_1);
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    final ByteBuf getBackingBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ChannelFuture access$100(Lz4FrameEncoder x0, ChannelHandlerContext x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        return x0.finishEncode((ChannelHandlerContext)var1_1, (ChannelPromise)var2_2);
    }
}

