/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.CompressionUtil;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.Lz4XXHash32;
import io.netty.util.internal.ObjectUtil;
import java.util.List;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class Lz4FrameDecoder
extends ByteToMessageDecoder {
    private State currentState = State.INIT_BLOCK;
    private LZ4FastDecompressor decompressor;
    private ByteBufChecksum checksum;
    private int blockType;
    private int compressedLength;
    private int decompressedLength;
    private int currentChecksum;

    public Lz4FrameDecoder() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    public Lz4FrameDecoder(boolean validateChecksums) {
        this(LZ4Factory.fastestInstance(), (boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Lz4FrameDecoder(LZ4Factory factory, boolean validateChecksums) {
        this((LZ4Factory)var1_1, var2_2 != false ? new Lz4XXHash32(-1756908916) : null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Lz4FrameDecoder(LZ4Factory factory, Checksum checksum) {
        void var2_2;
        void var1_1;
        this.decompressor = ((LZ4Factory)ObjectUtil.checkNotNull((Object)var1_1, (String)"factory")).fastDecompressor();
        this.checksum = checksum == null ? null : ByteBufChecksum.wrapChecksum((Checksum)var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            switch (this.currentState) {
                case INIT_BLOCK: {
                    if (in.readableBytes() < 21) return;
                    long l = in.readLong();
                    if (l != 5501767354678207339L) {
                        throw new DecompressionException("unexpected block identifier");
                    }
                    byte token = in.readByte();
                    int compressionLevel = (token & 0xF) + 10;
                    int blockType = token & 0xF0;
                    int compressedLength = Integer.reverseBytes(in.readInt());
                    if (compressedLength < 0 || compressedLength > 0x2000000) {
                        throw new DecompressionException(String.format("invalid compressedLength: %d (expected: 0-%d)", compressedLength, 0x2000000));
                    }
                    int decompressedLength = Integer.reverseBytes(in.readInt());
                    int maxDecompressedLength = 1 << compressionLevel;
                    if (decompressedLength < 0 || decompressedLength > maxDecompressedLength) {
                        throw new DecompressionException(String.format("invalid decompressedLength: %d (expected: 0-%d)", decompressedLength, maxDecompressedLength));
                    }
                    if (decompressedLength == 0 && compressedLength != 0 || decompressedLength != 0 && compressedLength == 0 || blockType == 16 && decompressedLength != compressedLength) {
                        throw new DecompressionException(String.format("stream corrupted: compressedLength(%d) and decompressedLength(%d) mismatch", compressedLength, decompressedLength));
                    }
                    int currentChecksum = Integer.reverseBytes(in.readInt());
                    if (decompressedLength == 0 && compressedLength == 0) {
                        if (currentChecksum != 0) {
                            throw new DecompressionException("stream corrupted: checksum error");
                        }
                        this.currentState = State.FINISHED;
                        this.decompressor = null;
                        this.checksum = null;
                        return;
                    }
                    this.blockType = blockType;
                    this.compressedLength = compressedLength;
                    this.decompressedLength = decompressedLength;
                    this.currentChecksum = currentChecksum;
                    this.currentState = State.DECOMPRESS_DATA;
                }
                case DECOMPRESS_DATA: {
                    int blockType = this.blockType;
                    int compressedLength = this.compressedLength;
                    int decompressedLength = this.decompressedLength;
                    int currentChecksum = this.currentChecksum;
                    if (in.readableBytes() < compressedLength) return;
                    ByteBufChecksum checksum = this.checksum;
                    ByteBuf uncompressed = null;
                    try {
                        try {
                            void var3_5;
                            switch (blockType) {
                                case 16: {
                                    ByteBuf byteBuf = in;
                                    uncompressed = byteBuf.retainedSlice(byteBuf.readerIndex(), decompressedLength);
                                    break;
                                }
                                case 32: {
                                    int n = decompressedLength;
                                    ByteBuf byteBuf = uncompressed = ctx.alloc().buffer(n, n);
                                    this.decompressor.decompress(CompressionUtil.safeReadableNioBuffer(in), byteBuf.internalNioBuffer(byteBuf.writerIndex(), decompressedLength));
                                    ByteBuf byteBuf2 = uncompressed;
                                    byteBuf2.writerIndex(byteBuf2.writerIndex() + decompressedLength);
                                    break;
                                }
                                default: {
                                    throw new DecompressionException(String.format("unexpected blockType: %d (expected: %d or %d)", blockType, 16, 32));
                                }
                            }
                            in.skipBytes(compressedLength);
                            if (checksum != null) {
                                CompressionUtil.checkChecksum(checksum, uncompressed, currentChecksum);
                            }
                            var3_5.add(uncompressed);
                            uncompressed = null;
                            this.currentState = State.INIT_BLOCK;
                            return;
                        }
                        catch (LZ4Exception e) {
                            void var1_2;
                            throw new DecompressionException((Throwable)var1_2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (uncompressed == null) throw throwable;
                        uncompressed.release();
                        throw throwable;
                    }
                }
                case FINISHED: 
                case CORRUPTED: {
                    void var2_4;
                    void v4 = var2_4;
                    v4.skipBytes(v4.readableBytes());
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Exception e) {
            this.currentState = State.CORRUPTED;
            throw e;
        }
    }

    public boolean isClosed() {
        return this.currentState == State.FINISHED;
    }

    private static enum State {
        INIT_BLOCK,
        DECOMPRESS_DATA,
        FINISHED,
        CORRUPTED;

    }
}

