/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.EncoderUtil;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class JdkZlibEncoder
extends ZlibEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JdkZlibEncoder.class);
    private static final int MAX_INITIAL_OUTPUT_BUFFER_SIZE;
    private static final int MAX_INPUT_BUFFER_SIZE;
    private final ZlibWrapper wrapper;
    private final Deflater deflater;
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;
    private final CRC32 crc = new CRC32();
    private static final byte[] gzipHeader;
    private boolean writeHeader = true;

    public JdkZlibEncoder() {
        this(6);
    }

    /*
     * WARNING - void declaration
     */
    public JdkZlibEncoder(int compressionLevel) {
        this(ZlibWrapper.ZLIB, (int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JdkZlibEncoder(ZlibWrapper wrapper) {
        this((ZlibWrapper)var1_1, 6);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JdkZlibEncoder(ZlibWrapper wrapper, int compressionLevel) {
        void var1_1;
        void var2_2;
        ObjectUtil.checkInRange((int)compressionLevel, (int)0, (int)9, (String)"compressionLevel");
        ObjectUtil.checkNotNull((Object)((Object)wrapper), (String)"wrapper");
        if (wrapper == ZlibWrapper.ZLIB_OR_NONE) {
            throw new IllegalArgumentException("wrapper '" + (Object)((Object)ZlibWrapper.ZLIB_OR_NONE) + "' is not allowed for compression.");
        }
        this.wrapper = wrapper;
        this.deflater = new Deflater((int)var2_2, var1_1 != ZlibWrapper.ZLIB);
    }

    /*
     * WARNING - void declaration
     */
    public JdkZlibEncoder(byte[] dictionary) {
        this(6, (byte[])var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JdkZlibEncoder(int compressionLevel, byte[] dictionary) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkInRange((int)compressionLevel, (int)0, (int)9, (String)"compressionLevel");
        ObjectUtil.checkNotNull((Object)dictionary, (String)"dictionary");
        this.wrapper = ZlibWrapper.ZLIB;
        this.deflater = new Deflater((int)var1_1);
        this.deflater.setDictionary((byte[])var2_2);
    }

    @Override
    public ChannelFuture close() {
        JdkZlibEncoder jdkZlibEncoder = this;
        return ((ZlibEncoder)jdkZlibEncoder).close(jdkZlibEncoder.ctx().newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture close(ChannelPromise promise) {
        void var2_2;
        void var1_1;
        void var3_3;
        ChannelHandlerContext ctx = this.ctx();
        EventExecutor executor = ctx.executor();
        if (executor.inEventLoop()) {
            return this.finishEncode(ctx, promise);
        }
        ChannelPromise p = ctx.newPromise();
        var3_3.execute(new Runnable(this, p, (ChannelPromise)var1_1){
            final /* synthetic */ ChannelPromise val$p;
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ JdkZlibEncoder this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$p = channelPromise;
                this.val$promise = channelPromise2;
            }

            @Override
            public void run() {
                ChannelFuture channelFuture = JdkZlibEncoder.access$100(this.this$0, this.this$0.ctx(), this.val$p);
                PromiseNotifier.cascade((Future)channelFuture, (Promise)this.val$promise);
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private ChannelHandlerContext ctx() {
        void var1_1;
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return var1_1;
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf uncompressed, ByteBuf out) throws Exception {
        if (this.finished) {
            out.writeBytes(uncompressed);
            return;
        }
        int len = uncompressed.readableBytes();
        if (len == 0) {
            return;
        }
        if (uncompressed.hasArray()) {
            this.encodeSome(uncompressed, out);
        } else {
            int heapBufferSize;
            int n = heapBufferSize = Math.min(len, MAX_INPUT_BUFFER_SIZE);
            ByteBuf heapBuf = ctx.alloc().heapBuffer(n, n);
            try {
                while (uncompressed.isReadable()) {
                    ByteBuf byteBuf = heapBuf;
                    uncompressed.readBytes(byteBuf, Math.min(byteBuf.writableBytes(), uncompressed.readableBytes()));
                    this.encodeSome(heapBuf, out);
                    heapBuf.clear();
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.release();
                throw throwable;
            }
            heapBuf.release();
        }
        this.deflater.setInput(EmptyArrays.EMPTY_BYTES);
    }

    /*
     * WARNING - void declaration
     */
    private void encodeSome(ByteBuf in, ByteBuf out) {
        void var1_1;
        void var3_3;
        byte[] inAry = in.array();
        int offset = in.arrayOffset() + in.readerIndex();
        if (this.writeHeader) {
            this.writeHeader = false;
            if (this.wrapper == ZlibWrapper.GZIP) {
                out.writeBytes(gzipHeader);
            }
        }
        int len = in.readableBytes();
        if (this.wrapper == ZlibWrapper.GZIP) {
            this.crc.update(inAry, offset, len);
        }
        this.deflater.setInput((byte[])var3_3, offset, len);
        while (true) {
            this.deflate(out);
            if (!out.isWritable()) {
                ByteBuf byteBuf = out;
                byteBuf.ensureWritable(byteBuf.writerIndex());
                continue;
            }
            if (this.deflater.needsInput()) break;
        }
        var1_1.skipBytes(len);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
        void var2_3;
        void var1_1;
        int sizeEstimate = (int)Math.ceil((double)msg.readableBytes() * 1.001) + 12;
        if (this.writeHeader) {
            switch (this.wrapper) {
                case GZIP: {
                    sizeEstimate += gzipHeader.length;
                    break;
                }
                case ZLIB: {
                    sizeEstimate += 2;
                }
            }
        }
        if (sizeEstimate < 0 || sizeEstimate > MAX_INITIAL_OUTPUT_BUFFER_SIZE) {
            return ctx.alloc().heapBuffer(MAX_INITIAL_OUTPUT_BUFFER_SIZE);
        }
        return var1_1.alloc().heapBuffer((int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var3_3;
        void var1_1;
        ChannelHandlerContext channelHandlerContext = ctx;
        ChannelFuture f = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        EncoderUtil.closeAfterFinishEncode((ChannelHandlerContext)var1_1, (ChannelFuture)var3_3, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture finishEncode(ChannelHandlerContext ctx, ChannelPromise promise) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (this.finished) {
            promise.setSuccess();
            return promise;
        }
        this.finished = true;
        ByteBuf footer = ctx.alloc().heapBuffer();
        if (this.writeHeader && this.wrapper == ZlibWrapper.GZIP) {
            this.writeHeader = false;
            footer.writeBytes(gzipHeader);
        }
        this.deflater.finish();
        while (!this.deflater.finished()) {
            this.deflate(footer);
            if (footer.isWritable()) continue;
            ctx.write((Object)footer);
            footer = ctx.alloc().heapBuffer();
        }
        if (this.wrapper == ZlibWrapper.GZIP) {
            int crcValue = (int)this.crc.getValue();
            int uncBytes = this.deflater.getTotalIn();
            footer.writeByte(crcValue);
            footer.writeByte(crcValue >>> 8);
            footer.writeByte(crcValue >>> 16);
            footer.writeByte(crcValue >>> 24);
            footer.writeByte(uncBytes);
            footer.writeByte(uncBytes >>> 8);
            footer.writeByte(uncBytes >>> 16);
            footer.writeByte(uncBytes >>> 24);
        }
        this.deflater.end();
        return var1_1.writeAndFlush((Object)var3_3, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private void deflate(ByteBuf out) {
        void var2_2;
        if (PlatformDependent.javaVersion() < 7) {
            this.deflateJdk6(out);
        }
        do {
            void var3_3;
            int writerIndex = out.writerIndex();
            int numBytes = this.deflater.deflate(out.array(), out.arrayOffset() + writerIndex, out.writableBytes(), 2);
            out.writerIndex((int)(var3_3 + numBytes));
        } while (var2_2 > 0);
    }

    /*
     * WARNING - void declaration
     */
    private void deflateJdk6(ByteBuf out) {
        void var2_2;
        do {
            void var3_3;
            int writerIndex = out.writerIndex();
            int numBytes = this.deflater.deflate(out.array(), out.arrayOffset() + writerIndex, out.writableBytes());
            out.writerIndex((int)(var3_3 + numBytes));
        } while (var2_2 > 0);
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.ctx = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ChannelFuture access$100(JdkZlibEncoder x0, ChannelHandlerContext x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        return x0.finishEncode((ChannelHandlerContext)var1_1, (ChannelPromise)var2_2);
    }

    static {
        gzipHeader = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
        MAX_INITIAL_OUTPUT_BUFFER_SIZE = SystemPropertyUtil.getInt((String)"io.netty.jdkzlib.encoder.maxInitialOutputBufferSize", (int)65536);
        MAX_INPUT_BUFFER_SIZE = SystemPropertyUtil.getInt((String)"io.netty.jdkzlib.encoder.maxInputBufferSize", (int)65536);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.jdkzlib.encoder.maxInitialOutputBufferSize={}", (Object)MAX_INITIAL_OUTPUT_BUFFER_SIZE);
            logger.debug("-Dio.netty.jdkzlib.encoder.maxInputBufferSize={}", (Object)MAX_INPUT_BUFFER_SIZE);
        }
    }
}

