/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.JZlib;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibUtil;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

public class JZlibEncoder
extends ZlibEncoder {
    private final int wrapperOverhead;
    private final Deflater z = new Deflater();
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;
    private static final int THREAD_POOL_DELAY_SECONDS = 10;

    public JZlibEncoder() {
        this(6);
    }

    /*
     * WARNING - void declaration
     */
    public JZlibEncoder(int compressionLevel) {
        this(ZlibWrapper.ZLIB, (int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JZlibEncoder(ZlibWrapper wrapper) {
        this((ZlibWrapper)var1_1, 6);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JZlibEncoder(ZlibWrapper wrapper, int compressionLevel) {
        this((ZlibWrapper)var1_1, (int)var2_2, 15, 8);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JZlibEncoder(ZlibWrapper wrapper, int compressionLevel, int windowBits, int memLevel) {
        void var1_1;
        void var3_3;
        ObjectUtil.checkInRange((int)compressionLevel, (int)0, (int)9, (String)"compressionLevel");
        ObjectUtil.checkInRange((int)windowBits, (int)9, (int)15, (String)"windowBits");
        ObjectUtil.checkInRange((int)memLevel, (int)1, (int)9, (String)"memLevel");
        ObjectUtil.checkNotNull((Object)((Object)wrapper), (String)"wrapper");
        if (wrapper == ZlibWrapper.ZLIB_OR_NONE) {
            throw new IllegalArgumentException("wrapper '" + (Object)((Object)ZlibWrapper.ZLIB_OR_NONE) + "' is not allowed for compression.");
        }
        int resultCode = this.z.init(compressionLevel, (int)var3_3, memLevel, ZlibUtil.convertWrapperType(wrapper));
        if (resultCode != 0) {
            void var2_2;
            ZlibUtil.fail(this.z, "initialization failure", (int)var2_2);
        }
        this.wrapperOverhead = ZlibUtil.wrapperOverhead((ZlibWrapper)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JZlibEncoder(byte[] dictionary) {
        this(6, (byte[])var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JZlibEncoder(int compressionLevel, byte[] dictionary) {
        this((int)var1_1, 15, 8, (byte[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JZlibEncoder(int compressionLevel, int windowBits, int memLevel, byte[] dictionary) {
        void var3_3;
        void var2_2;
        ObjectUtil.checkInRange((int)compressionLevel, (int)0, (int)9, (String)"compressionLevel");
        ObjectUtil.checkInRange((int)windowBits, (int)9, (int)15, (String)"windowBits");
        ObjectUtil.checkInRange((int)memLevel, (int)1, (int)9, (String)"memLevel");
        ObjectUtil.checkNotNull((Object)dictionary, (String)"dictionary");
        int resultCode = this.z.deflateInit(compressionLevel, (int)var2_2, (int)var3_3, JZlib.W_ZLIB);
        if (resultCode != 0) {
            ZlibUtil.fail(this.z, "initialization failure", resultCode);
        } else {
            resultCode = this.z.deflateSetDictionary(dictionary, dictionary.length);
            if (resultCode != 0) {
                void var1_1;
                ZlibUtil.fail(this.z, "failed to set the dictionary", (int)var1_1);
            }
        }
        this.wrapperOverhead = ZlibUtil.wrapperOverhead(ZlibWrapper.ZLIB);
    }

    @Override
    public ChannelFuture close() {
        JZlibEncoder jZlibEncoder = this;
        return ((ZlibEncoder)jZlibEncoder).close(jZlibEncoder.ctx().channel().newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture close(ChannelPromise promise) {
        void var2_2;
        void var1_1;
        void var3_3;
        ChannelHandlerContext ctx = this.ctx();
        EventExecutor executor = ctx.executor();
        if (executor.inEventLoop()) {
            return this.finishEncode(ctx, promise);
        }
        ChannelPromise p = ctx.newPromise();
        var3_3.execute(new Runnable(this, p, (ChannelPromise)var1_1){
            final /* synthetic */ ChannelPromise val$p;
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ JZlibEncoder this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$p = channelPromise;
                this.val$promise = channelPromise2;
            }

            @Override
            public void run() {
                ChannelFuture channelFuture = JZlibEncoder.access$100(this.this$0, this.this$0.ctx(), this.val$p);
                PromiseNotifier.cascade((Future)channelFuture, (Promise)this.val$promise);
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private ChannelHandlerContext ctx() {
        void var1_1;
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return var1_1;
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        if (this.finished) {
            out.writeBytes(in);
            return;
        }
        int inputLength = in.readableBytes();
        if (inputLength == 0) {
            return;
        }
        try {
            int outputLength;
            int resultCode;
            boolean inHasArray = in.hasArray();
            this.z.avail_in = inputLength;
            if (inHasArray) {
                this.z.next_in = in.array();
                this.z.next_in_index = in.arrayOffset() + in.readerIndex();
            } else {
                byte[] array = new byte[inputLength];
                ByteBuf byteBuf = in;
                byteBuf.getBytes(byteBuf.readerIndex(), array);
                this.z.next_in = array;
                this.z.next_in_index = 0;
            }
            int oldNextInIndex = this.z.next_in_index;
            int maxOutputLength = (int)Math.ceil((double)inputLength * 1.001) + 12 + this.wrapperOverhead;
            out.ensureWritable(maxOutputLength);
            this.z.avail_out = maxOutputLength;
            this.z.next_out = out.array();
            int oldNextOutIndex22 = this.z.next_out_index = out.arrayOffset() + out.writerIndex();
            try {
                resultCode = this.z.deflate(2);
            }
            catch (Throwable oldNextOutIndex22) {
                void var2_5;
                var2_5.skipBytes(this.z.next_in_index - oldNextInIndex);
                throw oldNextOutIndex22;
            }
            in.skipBytes(this.z.next_in_index - oldNextInIndex);
            if (resultCode != 0) {
                ZlibUtil.fail(this.z, "compression failure", resultCode);
            }
            if ((outputLength = this.z.next_out_index - oldNextOutIndex22) > 0) {
                void var1_2;
                void var3_6;
                void v1 = var3_6;
                v1.writerIndex(v1.writerIndex() + var1_2);
            }
            return;
        }
        finally {
            this.z.next_in = null;
            this.z.next_out = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        ChannelHandlerContext channelHandlerContext = ctx;
        ChannelFuture f = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        if (!f.isDone()) {
            void var3_3;
            ScheduledFuture future = ctx.executor().schedule(new Runnable(this, promise, ctx){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ ChannelHandlerContext val$ctx;
                final /* synthetic */ JZlibEncoder this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                    this.val$ctx = channelHandlerContext;
                }

                @Override
                public void run() {
                    if (!this.val$promise.isDone()) {
                        this.val$ctx.close(this.val$promise);
                    }
                }
            }, 10L, TimeUnit.SECONDS);
            var3_3.addListener((GenericFutureListener)new ChannelFutureListener(this, (Future)future, promise, ctx){
                final /* synthetic */ Future val$future;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ ChannelHandlerContext val$ctx;
                final /* synthetic */ JZlibEncoder this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$future = future;
                    this.val$promise = channelPromise;
                    this.val$ctx = channelHandlerContext;
                }

                public void operationComplete(ChannelFuture f) {
                    this.val$future.cancel(true);
                    if (!this.val$promise.isDone()) {
                        this.val$ctx.close(this.val$promise);
                    }
                }
            });
            return;
        }
        var1_1.close((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture finishEncode(ChannelHandlerContext ctx, ChannelPromise promise) {
        void var2_3;
        void var3_4;
        void var1_1;
        if (this.finished) {
            promise.setSuccess();
            return promise;
        }
        this.finished = true;
        try {
            this.z.next_in = EmptyArrays.EMPTY_BYTES;
            this.z.next_in_index = 0;
            this.z.avail_in = 0;
            byte[] out = new byte[32];
            this.z.next_out = out;
            this.z.next_out_index = 0;
            this.z.avail_out = out.length;
            int resultCode = this.z.deflate(4);
            if (resultCode != 0 && resultCode != 1) {
                promise.setFailure((Throwable)ZlibUtil.deflaterException(this.z, "compression failure", resultCode));
                ctx = promise;
                return ctx;
            }
            ByteBuf footer = this.z.next_out_index != 0 ? Unpooled.wrappedBuffer((byte[])out, (int)0, (int)this.z.next_out_index) : Unpooled.EMPTY_BUFFER;
        }
        finally {
            this.z.deflateEnd();
            this.z.next_in = null;
            this.z.next_out = null;
        }
        return var1_1.writeAndFlush((Object)var3_4, (ChannelPromise)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.ctx = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ChannelFuture access$100(JZlibEncoder x0, ChannelHandlerContext x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        return x0.finishEncode((ChannelHandlerContext)var1_1, (ChannelPromise)var2_2);
    }
}

