/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.jcraft.jzlib.Inflater;
import com.jcraft.jzlib.JZlib;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.compression.ZlibDecoder;
import io.netty.handler.codec.compression.ZlibUtil;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class JZlibDecoder
extends ZlibDecoder {
    private final Inflater z = new Inflater();
    private byte[] dictionary;
    private volatile boolean finished;

    public JZlibDecoder() {
        this(ZlibWrapper.ZLIB, 0);
    }

    /*
     * WARNING - void declaration
     */
    public JZlibDecoder(int maxAllocation) {
        this(ZlibWrapper.ZLIB, (int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JZlibDecoder(ZlibWrapper wrapper) {
        this((ZlibWrapper)var1_1, 0);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JZlibDecoder(ZlibWrapper wrapper, int maxAllocation) {
        super((int)var2_3);
        void var2_3;
        ObjectUtil.checkNotNull((Object)((Object)wrapper), (String)"wrapper");
        int resultCode = this.z.init(ZlibUtil.convertWrapperType(wrapper));
        if (resultCode != 0) {
            void var1_2;
            ZlibUtil.fail(this.z, "initialization failure", (int)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public JZlibDecoder(byte[] dictionary) {
        this((byte[])var1_1, 0);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public JZlibDecoder(byte[] dictionary, int maxAllocation) {
        super((int)var2_3);
        void var2_3;
        this.dictionary = (byte[])ObjectUtil.checkNotNull((Object)dictionary, (String)"dictionary");
        int resultCode = this.z.inflateInit(JZlib.W_ZLIB);
        if (resultCode != 0) {
            void var1_2;
            ZlibUtil.fail(this.z, "initialization failure", (int)var1_2);
        }
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.finished) {
            v0 = in;
            v0.skipBytes(v0.readableBytes());
            return;
        }
        inputLength = in.readableBytes();
        if (inputLength == 0) {
            return;
        }
        try {
            block23: {
                this.z.avail_in = inputLength;
                if (in.hasArray()) {
                    this.z.next_in = in.array();
                    this.z.next_in_index = in.arrayOffset() + in.readerIndex();
                } else {
                    array = new byte[inputLength];
                    v1 = in;
                    v1.getBytes(v1.readerIndex(), array);
                    this.z.next_in = array;
                    this.z.next_in_index = 0;
                }
                oldNextInIndex = this.z.next_in_index;
                decompressed = this.prepareDecompressBuffer(ctx, null, inputLength << 1);
                block11: while (true) {
                    block12: while (true) {
                        decompressed = this.prepareDecompressBuffer(ctx, decompressed, this.z.avail_in << 1);
                        this.z.avail_out = decompressed.writableBytes();
                        this.z.next_out = decompressed.array();
                        oldNextOutIndex = this.z.next_out_index = decompressed.arrayOffset() + decompressed.writerIndex();
                        resultCode = this.z.inflate(2);
                        outputLength = this.z.next_out_index - oldNextOutIndex;
                        if (outputLength > 0) {
                            v2 = decompressed;
                            v2.writerIndex(v2.writerIndex() + outputLength);
                        }
                        switch (resultCode) {
                            case 2: {
                                if (this.dictionary != null) {
                                    resultCode = this.z.inflateSetDictionary(this.dictionary, this.dictionary.length);
                                    if (resultCode == 0) continue block11;
                                    ZlibUtil.fail(this.z, "failed to set the dictionary", resultCode);
                                    continue block12;
                                }
                                ** GOTO lbl55
                            }
                            case 1: {
                                this.finished = true;
                                this.z.inflateEnd();
                                break block11;
                            }
                            case 0: {
                                continue block12;
                            }
                            case -5: {
                                if (this.z.avail_in <= 0) ** break;
                                continue block11;
                                break block11;
                            }
lbl55:
                            // 2 sources

                            default: {
                                ZlibUtil.fail(this.z, "decompression failure", resultCode);
                                continue block12;
                            }
                        }
                        break;
                    }
                    break;
                }
                in.skipBytes(this.z.next_in_index - oldNextInIndex);
                if (decompressed.isReadable()) {
                    out.add(decompressed);
                } else {
                    decompressed.release();
                }
                break block23;
                catch (Throwable var1_2) {
                    var2_4.skipBytes(this.z.next_in_index - oldNextInIndex);
                    if (decompressed.isReadable()) {
                        var3_5.add(decompressed);
                    } else {
                        decompressed.release();
                    }
                    throw var1_2;
                }
            }
            return;
        }
        finally {
            this.z.next_in = null;
            this.z.next_out = null;
        }
    }

    @Override
    protected void decompressionBufferExhausted(ByteBuf buffer) {
        this.finished = true;
    }
}

