/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.FastLz;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class FastLzFrameDecoder
extends ByteToMessageDecoder {
    private State currentState = State.INIT_BLOCK;
    private final ByteBufChecksum checksum;
    private int chunkLength;
    private int originalLength;
    private boolean isCompressed;
    private boolean hasChecksum;
    private int currentChecksum;

    public FastLzFrameDecoder() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    public FastLzFrameDecoder(boolean validateChecksums) {
        this(var1_1 != false ? new Adler32() : null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FastLzFrameDecoder(Checksum checksum) {
        void var1_1;
        this.checksum = checksum == null ? null : ByteBufChecksum.wrapChecksum((Checksum)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        block19: {
            try {
                switch (this.currentState) {
                    case INIT_BLOCK: {
                        if (in.readableBytes() < 4) break;
                        int n = in.readUnsignedMedium();
                        if (n != 4607066) {
                            throw new DecompressionException("unexpected block identifier");
                        }
                        byte options = in.readByte();
                        this.isCompressed = (options & 1) == 1;
                        this.hasChecksum = (options & 0x10) == 16;
                        this.currentState = State.INIT_BLOCK_PARAMS;
                    }
                    case INIT_BLOCK_PARAMS: {
                        if (in.readableBytes() < 2 + (this.isCompressed ? 2 : 0) + (this.hasChecksum ? 4 : 0)) break;
                        this.currentChecksum = this.hasChecksum ? in.readInt() : 0;
                        this.chunkLength = in.readUnsignedShort();
                        this.originalLength = this.isCompressed ? in.readUnsignedShort() : this.chunkLength;
                        this.currentState = State.DECOMPRESS_DATA;
                    }
                    case DECOMPRESS_DATA: {
                        int chunkLength = this.chunkLength;
                        if (in.readableBytes() < chunkLength) break;
                        int idx = in.readerIndex();
                        int originalLength = this.originalLength;
                        ByteBuf output = null;
                        try {
                            if (this.isCompressed) {
                                int outputOffset;
                                output = ctx.alloc().buffer(originalLength);
                                int decompressedBytes = FastLz.decompress(in, idx, chunkLength, output, outputOffset = output.writerIndex(), originalLength);
                                if (originalLength != decompressedBytes) {
                                    throw new DecompressionException(String.format("stream corrupted: originalLength(%d) and actual length(%d) mismatch", originalLength, decompressedBytes));
                                }
                                ByteBuf byteBuf = output;
                                byteBuf.writerIndex(byteBuf.writerIndex() + decompressedBytes);
                            } else {
                                output = in.retainedSlice(idx, chunkLength);
                            }
                            ByteBufChecksum checksum = this.checksum;
                            if (this.hasChecksum && checksum != null) {
                                checksum.reset();
                                ByteBuf byteBuf = output;
                                checksum.update(byteBuf, byteBuf.readerIndex(), output.readableBytes());
                                int checksumResult = (int)checksum.getValue();
                                if (checksumResult != this.currentChecksum) {
                                    void var1_4;
                                    throw new DecompressionException(String.format("stream corrupted: mismatching checksum: %d (expected: %d)", (int)var1_4, this.currentChecksum));
                                }
                            }
                            if (output.readableBytes() > 0) {
                                void var3_7;
                                var3_7.add(output);
                            } else {
                                output.release();
                            }
                            output = null;
                            in.skipBytes(chunkLength);
                            this.currentState = State.INIT_BLOCK;
                            break;
                        }
                        catch (Throwable throwable) {
                            if (output != null) {
                                output.release();
                            }
                            throw throwable;
                        }
                    }
                    case CORRUPTED: {
                        void var2_6;
                        void v2 = var2_6;
                        v2.skipBytes(v2.readableBytes());
                        break block19;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return;
            }
            catch (Exception e) {
                this.currentState = State.CORRUPTED;
                throw e;
            }
        }
    }

    private static enum State {
        INIT_BLOCK,
        INIT_BLOCK_PARAMS,
        DECOMPRESS_DATA,
        CORRUPTED;

    }
}

