/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.DecompressionException;

final class FastLz {
    private static final int MAX_DISTANCE = 8191;
    private static final int MAX_FARDISTANCE = 73725;
    private static final int HASH_LOG = 13;
    private static final int HASH_SIZE = 8192;
    private static final int HASH_MASK = 8191;
    private static final int MAX_COPY = 32;
    private static final int MAX_LEN = 264;
    private static final int MIN_RECOMENDED_LENGTH_FOR_LEVEL_2 = 65536;
    static final int MAGIC_NUMBER = 4607066;
    static final byte BLOCK_TYPE_NON_COMPRESSED = 0;
    static final byte BLOCK_TYPE_COMPRESSED = 1;
    static final byte BLOCK_WITHOUT_CHECKSUM = 0;
    static final byte BLOCK_WITH_CHECKSUM = 16;
    static final int OPTIONS_OFFSET = 3;
    static final int CHECKSUM_OFFSET = 4;
    static final int MAX_CHUNK_LENGTH = 65535;
    static final int MIN_LENGTH_TO_COMPRESSION = 32;
    static final int LEVEL_AUTO = 0;
    static final int LEVEL_1 = 1;
    static final int LEVEL_2 = 2;

    static int calculateOutputBufferLength(int inputLength) {
        int n = (int)((double)inputLength * 1.06);
        return Math.max(n, 66);
    }

    /*
     * WARNING - void declaration
     */
    static int compress(ByteBuf input, int inOffset, int inLength, ByteBuf output, int outOffset, int proposedLevel) {
        int level;
        if (proposedLevel == 0) {
            level = inLength < 65536 ? 1 : 2;
        }
        int ip = 0;
        int ipBound = inLength + 0 - 2;
        int ipLimit = inLength + 0 - 12;
        int op = 0;
        int[] htab = new int[8192];
        if (inLength < 4) {
            if (inLength != 0) {
                ++op;
                output.setByte(outOffset + 0, (int)((byte)(inLength - 1)));
                ++ipBound;
                while (ip <= ipBound) {
                    output.setByte(outOffset + op++, (int)input.getByte(inOffset + ip++));
                }
                return inLength + 1;
            }
            return 0;
        }
        for (int hslot = 0; hslot < 8192; ++hslot) {
            htab[hslot] = 0;
        }
        int copy = 2;
        ++op;
        output.setByte(outOffset + 0, 31);
        ++op;
        ++ip;
        output.setByte(outOffset + 1, (int)input.getByte(inOffset + 0));
        ++op;
        ++ip;
        output.setByte(outOffset + 2, (int)input.getByte(inOffset + 1));
        while (ip < ipLimit) {
            int n;
            int hval;
            long distance;
            block39: {
                int anchor;
                block41: {
                    block40: {
                        int ref = 0;
                        distance = 0L;
                        int len = 3;
                        anchor = ip;
                        int matchLabel = 0;
                        if (level == 2 && input.getByte(inOffset + ip) == input.getByte(inOffset + ip - 1) && FastLz.readU16(input, inOffset + ip - 1) == FastLz.readU16(input, inOffset + ip + 1)) {
                            distance = 1L;
                            ip += 3;
                            ref = anchor + 2;
                            matchLabel = 1;
                        }
                        if (matchLabel != 0) break block39;
                        matchLabel = hval = FastLz.hashFunction(input, inOffset + ip);
                        hval = htab[hval];
                        distance = anchor - hval;
                        htab[matchLabel] = anchor;
                        if (distance == 0L || (level != 1 ? distance >= 73725L : distance >= 8191L)) break block40;
                        if (input.getByte(inOffset + hval++) == input.getByte(inOffset + ip++) && input.getByte(inOffset + hval++) == input.getByte(inOffset + ip++) && input.getByte(inOffset + hval++) == input.getByte(inOffset + ip++)) break block41;
                    }
                    output.setByte(outOffset + op++, (int)input.getByte(inOffset + anchor++));
                    ip = anchor;
                    if (++copy != 32) continue;
                    copy = 0;
                    output.setByte(outOffset + op++, 31);
                    continue;
                }
                if (level == 2 && distance >= 8191L) {
                    if (input.getByte(inOffset + ip++) != input.getByte(inOffset + hval++) || input.getByte(inOffset + ip) != input.getByte(inOffset + hval++)) {
                        output.setByte(outOffset + op++, (int)input.getByte(inOffset + anchor++));
                        ip = anchor;
                        if (++copy != 32) continue;
                        copy = 0;
                        output.setByte(outOffset + op++, 31);
                        continue;
                    }
                    len += 2;
                }
            }
            if (--distance == 0L) {
                byte x = input.getByte(inOffset + ip - 1);
                for (ip = anchor + len; ip < ipBound && input.getByte(inOffset + hval++) == x; ++ip) {
                }
            } else {
                void var2_2;
                boolean missMatch = false;
                for (int i = 0; i < 8; ++i) {
                    if (input.getByte(inOffset + hval++) == input.getByte(inOffset + ip++)) continue;
                    missMatch = true;
                    break;
                }
                if (var2_2 == false) {
                    while (ip < ipBound && input.getByte(inOffset + hval++) == input.getByte(inOffset + ip++)) {
                    }
                }
            }
            if (copy != 0) {
                output.setByte(outOffset + op - copy - 1, (int)((byte)(copy - 1)));
            } else {
                --op;
            }
            copy = 0;
            if (level == 2) {
                if (distance < 8191L) {
                    if (n < 7) {
                        output.setByte(outOffset + op++, (int)((byte)((long)(n << 5) + (distance >>> 8))));
                        output.setByte(outOffset + op++, (int)((byte)(distance & 0xFFL)));
                    } else {
                        output.setByte(outOffset + op++, (int)((byte)(224L + (distance >>> 8))));
                        n -= 7;
                        while (n >= 255) {
                            output.setByte(outOffset + op++, -1);
                            n -= 255;
                        }
                        output.setByte(outOffset + op++, (int)((byte)n));
                        output.setByte(outOffset + op++, (int)((byte)(distance & 0xFFL)));
                    }
                } else if (n < 7) {
                    output.setByte(outOffset + op++, (int)((byte)((n << 5) + 31)));
                    output.setByte(outOffset + op++, -1);
                    output.setByte(outOffset + op++, (int)((byte)((distance -= 8191L) >>> 8)));
                    output.setByte(outOffset + op++, (int)((byte)(distance & 0xFFL)));
                } else {
                    distance -= 8191L;
                    output.setByte(outOffset + op++, -1);
                    n -= 7;
                    while (n >= 255) {
                        output.setByte(outOffset + op++, -1);
                        n -= 255;
                    }
                    output.setByte(outOffset + op++, (int)((byte)n));
                    output.setByte(outOffset + op++, -1);
                    output.setByte(outOffset + op++, (int)((byte)(distance >>> 8)));
                    output.setByte(outOffset + op++, (int)((byte)(distance & 0xFFL)));
                }
            } else {
                if (n > 262) {
                    for (n = (ip -= 3) - anchor; n > 262; n -= 262) {
                        output.setByte(outOffset + op++, (int)((byte)(224L + (distance >>> 8))));
                        output.setByte(outOffset + op++, -3);
                        output.setByte(outOffset + op++, (int)((byte)(distance & 0xFFL)));
                    }
                }
                if (n < 7) {
                    output.setByte(outOffset + op++, (int)((byte)((long)(n << 5) + (distance >>> 8))));
                    output.setByte(outOffset + op++, (int)((byte)(distance & 0xFFL)));
                } else {
                    output.setByte(outOffset + op++, (int)((byte)(224L + (distance >>> 8))));
                    output.setByte(outOffset + op++, (int)((byte)(n - 7)));
                    output.setByte(outOffset + op++, (int)((byte)(distance & 0xFFL)));
                }
            }
            hval = FastLz.hashFunction(input, inOffset + ip);
            htab[hval] = ip++;
            hval = FastLz.hashFunction(input, inOffset + ip);
            htab[hval] = ip++;
            output.setByte(outOffset + op++, 31);
        }
        ++ipBound;
        while (ip <= ipBound) {
            output.setByte(outOffset + op++, (int)input.getByte(inOffset + ip++));
            if (++copy != 32) continue;
            copy = 0;
            output.setByte(outOffset + op++, 31);
        }
        if (copy != 0) {
            output.setByte(outOffset + op - copy - 1, (int)((byte)(copy - 1)));
        } else {
            --op;
        }
        if (level == 2) {
            void var3_3;
            output.setByte(outOffset, var3_3.getByte(outOffset) | 0x20);
        }
        return op;
    }

    /*
     * WARNING - void declaration
     */
    static int decompress(ByteBuf input, int inOffset, int inLength, ByteBuf output, int outOffset, int outLength) {
        int level = (input.getByte(inOffset) >> 5) + 1;
        if (level != 1 && level != 2) {
            throw new DecompressionException(String.format("invalid level: %d (expected: %d or %d)", level, 1, 2));
        }
        int ip = 0;
        int op = 0;
        ++ip;
        long ctrl = input.getByte(inOffset + 0) & 0x1F;
        boolean loop = true;
        do {
            int ref = op;
            long len = ctrl >> 5;
            long ofs = (ctrl & 0x1FL) << 8;
            if (ctrl >= 32L) {
                short code;
                ref = (int)((long)ref - ofs);
                if (--len == 6L) {
                    if (level == 1) {
                        len += (long)input.getUnsignedByte(inOffset + ip++);
                    } else {
                        do {
                            code = input.getUnsignedByte(inOffset + ip++);
                            len += (long)code;
                        } while (code == 255);
                    }
                }
                if (level == 1) {
                    ref -= input.getUnsignedByte(inOffset + ip++);
                } else {
                    code = input.getUnsignedByte(inOffset + ip++);
                    ref -= code;
                    if (code == 255 && ofs == 7936L) {
                        ofs = input.getUnsignedByte(inOffset + ip++) << 8;
                        ref = (int)((long)op - (ofs += (long)input.getUnsignedByte(inOffset + ip++)) - 8191L);
                    }
                }
                if ((long)op + len + 3L > (long)outLength) {
                    return 0;
                }
                if (ref - 1 < 0) {
                    return 0;
                }
                if (ip < inLength) {
                    ctrl = input.getUnsignedByte(inOffset + ip++);
                } else {
                    loop = false;
                }
                if (ref == op) {
                    byte b = output.getByte(outOffset + ref - 1);
                    output.setByte(outOffset + op++, (int)b);
                    output.setByte(outOffset + op++, (int)b);
                    output.setByte(outOffset + op++, (int)b);
                    while (len != 0L) {
                        output.setByte(outOffset + op++, (int)b);
                        --len;
                    }
                } else {
                    void var12_11;
                    int n = op++;
                    void v1 = --var12_11;
                    output.setByte(outOffset + n, (int)output.getByte(outOffset + v1));
                    int n2 = op++;
                    void v3 = ++var12_11;
                    output.setByte(outOffset + n2, (int)output.getByte(outOffset + v3));
                    int n3 = op++;
                    void v5 = ++var12_11;
                    ++var12_11;
                    output.setByte(outOffset + n3, (int)output.getByte(outOffset + v5));
                    while (len != 0L) {
                        output.setByte(outOffset + op++, (int)output.getByte(outOffset + var12_11++));
                        --len;
                    }
                }
            } else {
                if ((long)op + ++ctrl > (long)outLength) {
                    return 0;
                }
                if ((long)ip + ctrl > (long)inLength) {
                    return 0;
                }
                output.setByte(outOffset + op++, (int)input.getByte(inOffset + ip++));
                --ctrl;
                while (ctrl != 0L) {
                    output.setByte(outOffset + op++, (int)input.getByte(inOffset + ip++));
                    --ctrl;
                }
                loop = ip < inLength;
                if (!loop) continue;
                ctrl = input.getUnsignedByte(inOffset + ip++);
            }
        } while (loop);
        return op;
    }

    /*
     * WARNING - void declaration
     */
    private static int hashFunction(ByteBuf p, int offset) {
        int n;
        void var1_1;
        ByteBuf byteBuf;
        int v = FastLz.readU16(p, offset);
        n = v ^ (FastLz.readU16(byteBuf, (int)(var1_1 + true)) ^ n >> 3);
        return n &= 0x1FFF;
    }

    /*
     * WARNING - void declaration
     */
    private static int readU16(ByteBuf data, int offset) {
        void var1_1;
        ByteBuf byteBuf;
        if (offset + 1 >= data.readableBytes()) {
            return data.getUnsignedByte(offset);
        }
        return data.getUnsignedByte(offset + 1) << 8 | byteBuf.getUnsignedByte((int)var1_1);
    }

    private FastLz() {
    }
}

