/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.DecompressionException;
import java.nio.ByteBuffer;

final class CompressionUtil {
    private CompressionUtil() {
    }

    /*
     * WARNING - void declaration
     */
    static void checkChecksum(ByteBufChecksum checksum, ByteBuf uncompressed, int currentChecksum) {
        void var1_2;
        checksum.reset();
        ByteBuf byteBuf = uncompressed;
        checksum.update(byteBuf, byteBuf.readerIndex(), var1_2.readableBytes());
        int checksumResult = (int)checksum.getValue();
        if (checksumResult != currentChecksum) {
            void var2_3;
            void var0_1;
            throw new DecompressionException(String.format("stream corrupted: mismatching checksum: %d (expected: %d)", (int)var0_1, (int)var2_3));
        }
    }

    static ByteBuffer safeReadableNioBuffer(ByteBuf buffer) {
        ByteBuf byteBuf;
        ByteBuf byteBuf2 = buffer;
        return CompressionUtil.safeNioBuffer(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    /*
     * WARNING - void declaration
     */
    static ByteBuffer safeNioBuffer(ByteBuf buffer, int index, int length) {
        void var2_2;
        void var1_1;
        ByteBuf byteBuf;
        if (buffer.nioBufferCount() == 1) {
            return buffer.internalNioBuffer(index, length);
        }
        return byteBuf.nioBuffer((int)var1_1, (int)var2_2);
    }
}

