/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.handler.codec.compression.Bzip2MoveToFrontTable;

final class Bzip2MTFAndRLE2StageEncoder {
    private final int[] bwtBlock;
    private final int bwtLength;
    private final boolean[] bwtValuesPresent;
    private final char[] mtfBlock;
    private int mtfLength;
    private final int[] mtfSymbolFrequencies = new int[258];
    private int alphabetSize;

    /*
     * WARNING - void declaration
     */
    Bzip2MTFAndRLE2StageEncoder(int[] bwtBlock, int bwtLength, boolean[] bwtValuesPresent) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.bwtBlock = var1_1;
        this.bwtLength = bwtLength;
        this.bwtValuesPresent = var3_3;
        this.mtfBlock = new char[var2_2 + true];
    }

    /*
     * WARNING - void declaration
     */
    final void encode() {
        void var2_3;
        int bwtLength = this.bwtLength;
        boolean[] bwtValuesPresent = this.bwtValuesPresent;
        int[] bwtBlock = this.bwtBlock;
        char[] mtfBlock = this.mtfBlock;
        int[] mtfSymbolFrequencies = this.mtfSymbolFrequencies;
        byte[] huffmanSymbolMap = new byte[256];
        Bzip2MoveToFrontTable symbolMTF = new Bzip2MoveToFrontTable();
        int totalUniqueValues = 0;
        for (int i = 0; i < huffmanSymbolMap.length; ++i) {
            if (!bwtValuesPresent[i]) continue;
            huffmanSymbolMap[i] = (byte)totalUniqueValues++;
        }
        int endOfBlockSymbol = totalUniqueValues + 1;
        int mtfIndex = 0;
        int repeatCount = 0;
        int totalRunAs = 0;
        int totalRunBs = 0;
        for (int i = 0; i < bwtLength; ++i) {
            int mtfPosition = symbolMTF.valueToFront(huffmanSymbolMap[bwtBlock[i] & 0xFF]);
            if (mtfPosition == 0) {
                ++repeatCount;
                continue;
            }
            if (repeatCount > 0) {
                --repeatCount;
                while (true) {
                    if ((repeatCount & 1) == 0) {
                        mtfBlock[mtfIndex++] = '\u0000';
                        ++totalRunAs;
                    } else {
                        mtfBlock[mtfIndex++] = '\u0001';
                        ++totalRunBs;
                    }
                    if (repeatCount <= 1) break;
                    repeatCount = repeatCount - 2 >>> 1;
                }
                repeatCount = 0;
            }
            mtfBlock[mtfIndex++] = (char)(mtfPosition + 1);
            int n = mtfPosition + 1;
            mtfSymbolFrequencies[n] = mtfSymbolFrequencies[n] + 1;
        }
        if (repeatCount > 0) {
            --repeatCount;
            while (true) {
                if ((repeatCount & 1) == 0) {
                    mtfBlock[mtfIndex++] = '\u0000';
                    ++totalRunAs;
                } else {
                    mtfBlock[mtfIndex++] = '\u0001';
                    ++totalRunBs;
                }
                if (repeatCount <= 1) break;
                repeatCount = repeatCount - 2 >>> 1;
            }
        }
        mtfBlock[mtfIndex] = (char)endOfBlockSymbol;
        int n = endOfBlockSymbol;
        mtfSymbolFrequencies[n] = mtfSymbolFrequencies[n] + 1;
        mtfSymbolFrequencies[0] = mtfSymbolFrequencies[0] + totalRunAs;
        mtfSymbolFrequencies[1] = mtfSymbolFrequencies[1] + totalRunBs;
        this.mtfLength = var2_3 + true;
        this.alphabetSize = endOfBlockSymbol + 1;
    }

    final char[] mtfBlock() {
        return this.mtfBlock;
    }

    final int mtfLength() {
        return this.mtfLength;
    }

    final int mtfAlphabetSize() {
        return this.alphabetSize;
    }

    final int[] mtfSymbolFrequencies() {
        return this.mtfSymbolFrequencies;
    }
}

